/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.term;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.search.spell.DirectSpellChecker;
import org.apache.lucene.search.spell.JaroWinklerDistance;
import org.apache.lucene.search.spell.LevensteinDistance;
import org.apache.lucene.search.spell.LuceneLevenshteinDistance;
import org.apache.lucene.search.spell.NGramDistance;
import org.apache.lucene.search.spell.StringDistance;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.suggest.DirectSpellcheckerSettings;
import org.elasticsearch.search.suggest.SortBy;
import org.elasticsearch.search.suggest.SuggestionBuilder;
import org.elasticsearch.search.suggest.SuggestionSearchContext;
import org.elasticsearch.search.suggest.phrase.DirectCandidateGeneratorBuilder;
import org.elasticsearch.search.suggest.term.TermSuggestionContext;

public class TermSuggestionBuilder
extends SuggestionBuilder<TermSuggestionBuilder> {
    private static final String SUGGESTION_NAME = "term";
    private SuggestMode suggestMode = SuggestMode.MISSING;
    private float accuracy = DirectSpellcheckerSettings.DEFAULT_ACCURACY;
    private SortBy sort = SortBy.SCORE;
    private StringDistanceImpl stringDistance = StringDistanceImpl.INTERNAL;
    private int maxEdits = DirectSpellcheckerSettings.DEFAULT_MAX_EDITS;
    private int maxInspections = DirectSpellcheckerSettings.DEFAULT_MAX_INSPECTIONS;
    private float maxTermFreq = DirectSpellcheckerSettings.DEFAULT_MAX_TERM_FREQ;
    private int prefixLength = DirectSpellcheckerSettings.DEFAULT_PREFIX_LENGTH;
    private int minWordLength = DirectSpellcheckerSettings.DEFAULT_MIN_WORD_LENGTH;
    private float minDocFreq = DirectSpellcheckerSettings.DEFAULT_MIN_DOC_FREQ;

    public TermSuggestionBuilder(String field) {
        super(field);
    }

    private TermSuggestionBuilder(String field, TermSuggestionBuilder in) {
        super(field, in);
        this.suggestMode = in.suggestMode;
        this.accuracy = in.accuracy;
        this.sort = in.sort;
        this.stringDistance = in.stringDistance;
        this.maxEdits = in.maxEdits;
        this.maxInspections = in.maxInspections;
        this.maxTermFreq = in.maxTermFreq;
        this.prefixLength = in.prefixLength;
        this.minWordLength = in.minWordLength;
        this.minDocFreq = in.minDocFreq;
    }

    TermSuggestionBuilder(StreamInput in) throws IOException {
        super(in);
        this.suggestMode = SuggestMode.readFromStream(in);
        this.accuracy = in.readFloat();
        this.sort = SortBy.readFromStream(in);
        this.stringDistance = StringDistanceImpl.readFromStream(in);
        this.maxEdits = in.readVInt();
        this.maxInspections = in.readVInt();
        this.maxTermFreq = in.readFloat();
        this.prefixLength = in.readVInt();
        this.minWordLength = in.readVInt();
        this.minDocFreq = in.readFloat();
    }

    @Override
    public void doWriteTo(StreamOutput out) throws IOException {
        this.suggestMode.writeTo(out);
        out.writeFloat(this.accuracy);
        this.sort.writeTo(out);
        this.stringDistance.writeTo(out);
        out.writeVInt(this.maxEdits);
        out.writeVInt(this.maxInspections);
        out.writeFloat(this.maxTermFreq);
        out.writeVInt(this.prefixLength);
        out.writeVInt(this.minWordLength);
        out.writeFloat(this.minDocFreq);
    }

    public TermSuggestionBuilder suggestMode(SuggestMode suggestMode) {
        Objects.requireNonNull(suggestMode, "suggestMode must not be null");
        this.suggestMode = suggestMode;
        return this;
    }

    public SuggestMode suggestMode() {
        return this.suggestMode;
    }

    public TermSuggestionBuilder accuracy(float accuracy) {
        if (accuracy < 0.0f || accuracy > 1.0f) {
            throw new IllegalArgumentException("accuracy must be between 0 and 1");
        }
        this.accuracy = accuracy;
        return this;
    }

    public float accuracy() {
        return this.accuracy;
    }

    public TermSuggestionBuilder sort(SortBy sort) {
        Objects.requireNonNull(sort, "sort must not be null");
        this.sort = sort;
        return this;
    }

    public SortBy sort() {
        return this.sort;
    }

    public TermSuggestionBuilder stringDistance(StringDistanceImpl stringDistance) {
        Objects.requireNonNull(stringDistance, "stringDistance must not be null");
        this.stringDistance = stringDistance;
        return this;
    }

    public StringDistanceImpl stringDistance() {
        return this.stringDistance;
    }

    public TermSuggestionBuilder maxEdits(int maxEdits) {
        if (maxEdits < 1 || maxEdits > 2) {
            throw new IllegalArgumentException("maxEdits must be between 1 and 2");
        }
        this.maxEdits = maxEdits;
        return this;
    }

    public int maxEdits() {
        return this.maxEdits;
    }

    public TermSuggestionBuilder maxInspections(int maxInspections) {
        if (maxInspections < 0) {
            throw new IllegalArgumentException("maxInspections must be positive");
        }
        this.maxInspections = maxInspections;
        return this;
    }

    public int maxInspections() {
        return this.maxInspections;
    }

    public TermSuggestionBuilder maxTermFreq(float maxTermFreq) {
        if (maxTermFreq < 0.0f) {
            throw new IllegalArgumentException("maxTermFreq must be positive");
        }
        if (maxTermFreq > 1.0f && (double)maxTermFreq != Math.floor(maxTermFreq)) {
            throw new IllegalArgumentException("if maxTermFreq is greater than 1, it must not be a fraction");
        }
        this.maxTermFreq = maxTermFreq;
        return this;
    }

    public float maxTermFreq() {
        return this.maxTermFreq;
    }

    public TermSuggestionBuilder prefixLength(int prefixLength) {
        if (prefixLength < 0) {
            throw new IllegalArgumentException("prefixLength must be positive");
        }
        this.prefixLength = prefixLength;
        return this;
    }

    public int prefixLength() {
        return this.prefixLength;
    }

    public TermSuggestionBuilder minWordLength(int minWordLength) {
        if (minWordLength < 1) {
            throw new IllegalArgumentException("minWordLength must be greater or equal to 1");
        }
        this.minWordLength = minWordLength;
        return this;
    }

    public int minWordLength() {
        return this.minWordLength;
    }

    public TermSuggestionBuilder minDocFreq(float minDocFreq) {
        if (minDocFreq < 0.0f) {
            throw new IllegalArgumentException("minDocFreq must be positive");
        }
        if (minDocFreq > 1.0f && (double)minDocFreq != Math.floor(minDocFreq)) {
            throw new IllegalArgumentException("if minDocFreq is greater than 1, it must not be a fraction");
        }
        this.minDocFreq = minDocFreq;
        return this;
    }

    public float minDocFreq() {
        return this.minDocFreq;
    }

    @Override
    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(DirectCandidateGeneratorBuilder.SUGGESTMODE_FIELD.getPreferredName(), this.suggestMode);
        builder.field(DirectCandidateGeneratorBuilder.ACCURACY_FIELD.getPreferredName(), this.accuracy);
        builder.field(DirectCandidateGeneratorBuilder.SORT_FIELD.getPreferredName(), this.sort);
        builder.field(DirectCandidateGeneratorBuilder.STRING_DISTANCE_FIELD.getPreferredName(), this.stringDistance);
        builder.field(DirectCandidateGeneratorBuilder.MAX_EDITS_FIELD.getPreferredName(), this.maxEdits);
        builder.field(DirectCandidateGeneratorBuilder.MAX_INSPECTIONS_FIELD.getPreferredName(), this.maxInspections);
        builder.field(DirectCandidateGeneratorBuilder.MAX_TERM_FREQ_FIELD.getPreferredName(), this.maxTermFreq);
        builder.field(DirectCandidateGeneratorBuilder.PREFIX_LENGTH_FIELD.getPreferredName(), this.prefixLength);
        builder.field(DirectCandidateGeneratorBuilder.MIN_WORD_LENGTH_FIELD.getPreferredName(), this.minWordLength);
        builder.field(DirectCandidateGeneratorBuilder.MIN_DOC_FREQ_FIELD.getPreferredName(), this.minDocFreq);
        return builder;
    }

    static TermSuggestionBuilder innerFromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        TermSuggestionBuilder tmpSuggestion = new TermSuggestionBuilder("_na_");
        ParseFieldMatcher parseFieldMatcher = parseContext.getParseFieldMatcher();
        String currentFieldName = null;
        String fieldname = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (SuggestionBuilder.ANALYZER_FIELD.match(currentFieldName)) {
                    tmpSuggestion.analyzer(parser.text());
                    continue;
                }
                if (SuggestionBuilder.FIELDNAME_FIELD.match(currentFieldName)) {
                    fieldname = parser.text();
                    continue;
                }
                if (SuggestionBuilder.SIZE_FIELD.match(currentFieldName)) {
                    tmpSuggestion.size(parser.intValue());
                    continue;
                }
                if (SuggestionBuilder.SHARDSIZE_FIELD.match(currentFieldName)) {
                    tmpSuggestion.shardSize(parser.intValue());
                    continue;
                }
                if (DirectCandidateGeneratorBuilder.SUGGESTMODE_FIELD.match(currentFieldName)) {
                    tmpSuggestion.suggestMode(SuggestMode.resolve(parser.text()));
                    continue;
                }
                if (DirectCandidateGeneratorBuilder.ACCURACY_FIELD.match(currentFieldName)) {
                    tmpSuggestion.accuracy(parser.floatValue());
                    continue;
                }
                if (DirectCandidateGeneratorBuilder.SORT_FIELD.match(currentFieldName)) {
                    tmpSuggestion.sort(SortBy.resolve(parser.text()));
                    continue;
                }
                if (DirectCandidateGeneratorBuilder.STRING_DISTANCE_FIELD.match(currentFieldName)) {
                    tmpSuggestion.stringDistance(StringDistanceImpl.resolve(parser.text()));
                    continue;
                }
                if (DirectCandidateGeneratorBuilder.MAX_EDITS_FIELD.match(currentFieldName)) {
                    tmpSuggestion.maxEdits(parser.intValue());
                    continue;
                }
                if (DirectCandidateGeneratorBuilder.MAX_INSPECTIONS_FIELD.match(currentFieldName)) {
                    tmpSuggestion.maxInspections(parser.intValue());
                    continue;
                }
                if (DirectCandidateGeneratorBuilder.MAX_TERM_FREQ_FIELD.match(currentFieldName)) {
                    tmpSuggestion.maxTermFreq(parser.floatValue());
                    continue;
                }
                if (DirectCandidateGeneratorBuilder.PREFIX_LENGTH_FIELD.match(currentFieldName)) {
                    tmpSuggestion.prefixLength(parser.intValue());
                    continue;
                }
                if (DirectCandidateGeneratorBuilder.MIN_WORD_LENGTH_FIELD.match(currentFieldName)) {
                    tmpSuggestion.minWordLength(parser.intValue());
                    continue;
                }
                if (DirectCandidateGeneratorBuilder.MIN_DOC_FREQ_FIELD.match(currentFieldName)) {
                    tmpSuggestion.minDocFreq(parser.floatValue());
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "suggester[term] doesn't support field [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "suggester[term] parsing failed on [" + currentFieldName + "]", new Object[0]);
        }
        if (fieldname == null) {
            throw new ElasticsearchParseException("the required field option [" + FIELDNAME_FIELD.getPreferredName() + "] is missing", new Object[0]);
        }
        return new TermSuggestionBuilder(fieldname, tmpSuggestion);
    }

    @Override
    public SuggestionSearchContext.SuggestionContext build(QueryShardContext context) throws IOException {
        TermSuggestionContext suggestionContext = new TermSuggestionContext(context);
        this.populateCommonFields(context.getMapperService(), suggestionContext);
        DirectSpellcheckerSettings settings = suggestionContext.getDirectSpellCheckerSettings();
        settings.accuracy(this.accuracy);
        settings.maxEdits(this.maxEdits);
        settings.maxInspections(this.maxInspections);
        settings.maxTermFreq(this.maxTermFreq);
        settings.minDocFreq(this.minDocFreq);
        settings.minWordLength(this.minWordLength);
        settings.prefixLength(this.prefixLength);
        settings.sort(this.sort);
        settings.stringDistance(this.stringDistance.toLucene());
        settings.suggestMode(this.suggestMode.toLucene());
        return suggestionContext;
    }

    @Override
    public String getWriteableName() {
        return SUGGESTION_NAME;
    }

    @Override
    protected boolean doEquals(TermSuggestionBuilder other) {
        return Objects.equals(this.suggestMode, other.suggestMode) && Objects.equals(Float.valueOf(this.accuracy), Float.valueOf(other.accuracy)) && Objects.equals(this.sort, other.sort) && Objects.equals(this.stringDistance, other.stringDistance) && Objects.equals(this.maxEdits, other.maxEdits) && Objects.equals(this.maxInspections, other.maxInspections) && Objects.equals(Float.valueOf(this.maxTermFreq), Float.valueOf(other.maxTermFreq)) && Objects.equals(this.prefixLength, other.prefixLength) && Objects.equals(this.minWordLength, other.minWordLength) && Objects.equals(Float.valueOf(this.minDocFreq), Float.valueOf(other.minDocFreq));
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.suggestMode, Float.valueOf(this.accuracy), this.sort, this.stringDistance, this.maxEdits, this.maxInspections, Float.valueOf(this.maxTermFreq), this.prefixLength, this.minWordLength, Float.valueOf(this.minDocFreq));
    }

    public static enum StringDistanceImpl implements Writeable
    {
        INTERNAL{

            @Override
            public StringDistance toLucene() {
                return DirectSpellChecker.INTERNAL_LEVENSHTEIN;
            }
        }
        ,
        DAMERAU_LEVENSHTEIN{

            @Override
            public StringDistance toLucene() {
                return new LuceneLevenshteinDistance();
            }
        }
        ,
        LEVENSTEIN{

            @Override
            public StringDistance toLucene() {
                return new LevensteinDistance();
            }
        }
        ,
        JAROWINKLER{

            @Override
            public StringDistance toLucene() {
                return new JaroWinklerDistance();
            }
        }
        ,
        NGRAM{

            @Override
            public StringDistance toLucene() {
                return new NGramDistance();
            }
        };


        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.ordinal());
        }

        public static StringDistanceImpl readFromStream(StreamInput in) throws IOException {
            int ordinal = in.readVInt();
            if (ordinal < 0 || ordinal >= StringDistanceImpl.values().length) {
                throw new IOException("Unknown StringDistanceImpl ordinal [" + ordinal + "]");
            }
            return StringDistanceImpl.values()[ordinal];
        }

        public static StringDistanceImpl resolve(String str) {
            String distanceVal;
            Objects.requireNonNull(str, "Input string is null");
            switch (distanceVal = str.toLowerCase(Locale.US)) {
                case "internal": {
                    return INTERNAL;
                }
                case "damerau_levenshtein": 
                case "damerauLevenshtein": {
                    return DAMERAU_LEVENSHTEIN;
                }
                case "levenstein": {
                    return LEVENSTEIN;
                }
                case "ngram": {
                    return NGRAM;
                }
                case "jarowinkler": {
                    return JAROWINKLER;
                }
            }
            throw new IllegalArgumentException("Illegal distance option " + str);
        }

        public abstract StringDistance toLucene();
    }

    public static enum SuggestMode implements Writeable
    {
        MISSING{

            @Override
            public org.apache.lucene.search.spell.SuggestMode toLucene() {
                return org.apache.lucene.search.spell.SuggestMode.SUGGEST_WHEN_NOT_IN_INDEX;
            }
        }
        ,
        POPULAR{

            @Override
            public org.apache.lucene.search.spell.SuggestMode toLucene() {
                return org.apache.lucene.search.spell.SuggestMode.SUGGEST_MORE_POPULAR;
            }
        }
        ,
        ALWAYS{

            @Override
            public org.apache.lucene.search.spell.SuggestMode toLucene() {
                return org.apache.lucene.search.spell.SuggestMode.SUGGEST_ALWAYS;
            }
        };


        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.ordinal());
        }

        public static SuggestMode readFromStream(StreamInput in) throws IOException {
            int ordinal = in.readVInt();
            if (ordinal < 0 || ordinal >= SuggestMode.values().length) {
                throw new IOException("Unknown SuggestMode ordinal [" + ordinal + "]");
            }
            return SuggestMode.values()[ordinal];
        }

        public static SuggestMode resolve(String str) {
            Objects.requireNonNull(str, "Input string is null");
            return SuggestMode.valueOf(str.toUpperCase(Locale.ROOT));
        }

        public abstract org.apache.lucene.search.spell.SuggestMode toLucene();
    }
}

