/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.awt.Point;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.tilesources.TMSTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TileSourceInfo;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projection;

public abstract class AbstractWMSTileSource
extends TMSTileSource {
    private EastNorth anchorPosition;
    private int[] tileXMin;
    private int[] tileYMin;
    private int[] tileXMax;
    private int[] tileYMax;
    private double[] degreesPerTile;
    private static final float SCALE_DENOMINATOR_ZOOM_LEVEL_1 = 5.5908224E8f;

    public AbstractWMSTileSource(TileSourceInfo tileSourceInfo) {
        super(tileSourceInfo);
    }

    private void initAnchorPosition(Projection projection) {
        Bounds bounds = projection.getWorldBoundsLatLon();
        EastNorth eastNorth = projection.latlon2eastNorth(bounds.getMin());
        EastNorth eastNorth2 = projection.latlon2eastNorth(bounds.getMax());
        this.anchorPosition = new EastNorth(eastNorth.east(), eastNorth2.north());
    }

    public void initProjection() {
        this.initProjection(Main.getProjection());
    }

    public void initProjection(Projection projection) {
        this.initAnchorPosition(projection);
        ProjectionBounds projectionBounds = projection.getWorldBoundsBoxEastNorth();
        EastNorth eastNorth = new EastNorth(projectionBounds.getMin().east(), projectionBounds.getMax().north());
        EastNorth eastNorth2 = new EastNorth(projectionBounds.getMax().east(), projectionBounds.getMin().north());
        double d = 0.07168 / projection.getMetersPerUnit();
        this.tileXMin = new int[this.getMaxZoom() + 1];
        this.tileYMin = new int[this.getMaxZoom() + 1];
        this.tileXMax = new int[this.getMaxZoom() + 1];
        this.tileYMax = new int[this.getMaxZoom() + 1];
        this.degreesPerTile = new double[this.getMaxZoom() + 1];
        for (int i = 1; i <= this.getMaxZoom(); ++i) {
            this.degreesPerTile[i] = 5.5908224E8 / Math.pow(2.0, (double)i - 1.0) * d;
            TileXY tileXY = this.eastNorthToTileXY(eastNorth, i);
            this.tileXMin[i] = tileXY.getXIndex();
            this.tileYMin[i] = tileXY.getYIndex();
            TileXY tileXY2 = this.eastNorthToTileXY(eastNorth2, i);
            this.tileXMax[i] = tileXY2.getXIndex();
            this.tileYMax[i] = tileXY2.getYIndex();
        }
    }

    @Override
    public ICoordinate tileXYToLatLon(Tile tile) {
        return this.tileXYToLatLon(tile.getXtile(), tile.getYtile(), tile.getZoom());
    }

    @Override
    public ICoordinate tileXYToLatLon(TileXY tileXY, int n) {
        return this.tileXYToLatLon(tileXY.getXIndex(), tileXY.getYIndex(), n);
    }

    @Override
    public ICoordinate tileXYToLatLon(int n, int n2, int n3) {
        return Main.getProjection().eastNorth2latlon(this.getTileEastNorth(n, n2, n3)).toCoordinate();
    }

    private TileXY eastNorthToTileXY(EastNorth eastNorth, int n) {
        double d = this.getDegreesPerTile(n);
        return new TileXY((eastNorth.east() - this.anchorPosition.east()) / d, (this.anchorPosition.north() - eastNorth.north()) / d);
    }

    @Override
    public TileXY latLonToTileXY(double d, double d2, int n) {
        EastNorth eastNorth = Main.getProjection().latlon2eastNorth(new LatLon(d, d2));
        return this.eastNorthToTileXY(eastNorth, n);
    }

    @Override
    public TileXY latLonToTileXY(ICoordinate iCoordinate, int n) {
        return this.latLonToTileXY(iCoordinate.getLat(), iCoordinate.getLon(), n);
    }

    @Override
    public int getTileXMax(int n) {
        return this.tileXMax[n];
    }

    @Override
    public int getTileXMin(int n) {
        return this.tileXMin[n];
    }

    @Override
    public int getTileYMax(int n) {
        return this.tileYMax[n];
    }

    @Override
    public int getTileYMin(int n) {
        return this.tileYMin[n];
    }

    @Override
    public Point latLonToXY(double d, double d2, int n) {
        double d3 = this.getDegreesPerTile(n) / (double)this.getTileSize();
        EastNorth eastNorth = Main.getProjection().latlon2eastNorth(new LatLon(d, d2));
        return new Point((int)Math.round((eastNorth.east() - this.anchorPosition.east()) / d3), (int)Math.round((this.anchorPosition.north() - eastNorth.north()) / d3));
    }

    @Override
    public Point latLonToXY(ICoordinate iCoordinate, int n) {
        return this.latLonToXY(iCoordinate.getLat(), iCoordinate.getLon(), n);
    }

    @Override
    public ICoordinate xyToLatLon(Point point, int n) {
        return this.xyToLatLon(point.x, point.y, n);
    }

    @Override
    public ICoordinate xyToLatLon(int n, int n2, int n3) {
        double d = this.getDegreesPerTile(n3) / (double)this.getTileSize();
        Projection projection = Main.getProjection();
        EastNorth eastNorth = new EastNorth(this.anchorPosition.east() + (double)n * d, this.anchorPosition.north() - (double)n2 * d);
        return projection.eastNorth2latlon(eastNorth).toCoordinate();
    }

    protected EastNorth getTileEastNorth(int n, int n2, int n3) {
        double d = this.getDegreesPerTile(n3);
        return new EastNorth(this.anchorPosition.east() + (double)n * d, this.anchorPosition.north() - (double)n2 * d);
    }

    private double getDegreesPerTile(int n) {
        return this.degreesPerTile[n];
    }
}

