/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.relation.DownloadMembersAction;
import org.openstreetmap.josm.actions.relation.DownloadSelectedIncompleteMembersAction;
import org.openstreetmap.josm.actions.relation.SelectInRelationListAction;
import org.openstreetmap.josm.actions.relation.SelectMembersAction;
import org.openstreetmap.josm.actions.relation.SelectRelationAction;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.PopupMenuHandler;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.properties.PresetListPanel;
import org.openstreetmap.josm.gui.dialogs.properties.PropertiesCellRenderer;
import org.openstreetmap.josm.gui.dialogs.properties.SearchBasedRowFilter;
import org.openstreetmap.josm.gui.dialogs.properties.TagEditHelper;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetHandler;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.gui.util.HighlightHelper;
import org.openstreetmap.josm.gui.widgets.CompileSearchTextDecorator;
import org.openstreetmap.josm.gui.widgets.DisableShortcutsOnFocusGainedTextField;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class PropertiesDialog
extends ToggleDialog
implements SelectionChangedListener,
MainLayerManager.ActiveLayerChangeListener,
DataSetListenerAdapter.Listener {
    public static final JPanel pluginHook = new JPanel();
    private final ReadOnlyTableModel tagData = new ReadOnlyTableModel();
    private final PropertiesCellRenderer cellRenderer = new PropertiesCellRenderer();
    private final transient TableRowSorter<ReadOnlyTableModel> tagRowSorter = new TableRowSorter<ReadOnlyTableModel>(this.tagData);
    private final JosmTextField tagTableFilter;
    private final DefaultTableModel membershipData = new ReadOnlyTableModel();
    private final JTable tagTable = new JTable(this.tagData);
    private final JTable membershipTable = new JTable(this.membershipData);
    private final JPanel bothTables = new JPanel(new GridBagLayout());
    private final JPopupMenu tagMenu = new JPopupMenu();
    private final JPopupMenu membershipMenu = new JPopupMenu();
    private final JPopupMenu blankSpaceMenu = new JPopupMenu();
    private final transient PopupMenuHandler tagMenuHandler = new PopupMenuHandler(this.tagMenu);
    private final transient PopupMenuHandler membershipMenuHandler = new PopupMenuHandler(this.membershipMenu);
    private final transient PopupMenuHandler blankSpaceMenuHandler = new PopupMenuHandler(this.blankSpaceMenu);
    private final transient Map<String, Map<String, Integer>> valueCount = new TreeMap<String, Map<String, Integer>>();
    private final transient TagEditHelper editHelper = new TagEditHelper(this.tagTable, this.tagData, this.valueCount);
    private final transient DataSetListenerAdapter dataChangedAdapter = new DataSetListenerAdapter(this);
    private final HelpAction helpAction = new HelpAction();
    private final TaginfoAction taginfoAction = new TaginfoAction();
    private final PasteValueAction pasteValueAction = new PasteValueAction();
    private final CopyValueAction copyValueAction = new CopyValueAction();
    private final CopyKeyValueAction copyKeyValueAction = new CopyKeyValueAction();
    private final CopyAllKeyValueAction copyAllKeyValueAction = new CopyAllKeyValueAction();
    private final SearchAction searchActionSame = new SearchAction(true);
    private final SearchAction searchActionAny = new SearchAction(false);
    private final AddAction addAction = new AddAction();
    private final EditAction editAction = new EditAction();
    private final DeleteAction deleteAction = new DeleteAction();
    private final JosmAction[] josmActions = new JosmAction[]{this.addAction, this.editAction, this.deleteAction};
    private final SelectInRelationListAction setRelationSelectionAction = new SelectInRelationListAction();
    private final SelectRelationAction selectRelationAction = new SelectRelationAction(false);
    private final SelectRelationAction addRelationToSelectionAction = new SelectRelationAction(true);
    private final DownloadMembersAction downloadMembersAction = new DownloadMembersAction();
    private final DownloadSelectedIncompleteMembersAction downloadSelectedIncompleteMembersAction = new DownloadSelectedIncompleteMembersAction();
    private final SelectMembersAction selectMembersAction = new SelectMembersAction(false);
    private final SelectMembersAction addMembersToSelectionAction = new SelectMembersAction(true);
    private final transient HighlightHelper highlightHelper = new HighlightHelper();
    private final SideButton btnAdd = new SideButton(this.addAction);
    private final SideButton btnEdit = new SideButton(this.editAction);
    private final SideButton btnDel = new SideButton(this.deleteAction);
    private final PresetListPanel presets = new PresetListPanel();
    private final JLabel selectSth = new JLabel("<html><p>" + I18n.tr("Select objects for which to change tags.", new Object[0]) + "</p></html>");
    private final Preferences.PreferenceChangedListener preferenceListener = preferenceChangeEvent -> {
        if (Main.getLayerManager().getEditDataSet() != null) {
            this.updateSelection();
        }
    };
    private final transient TaggingPresetHandler presetHandler = new TaggingPresetCommandHandler();

    public PropertiesDialog() {
        super(I18n.tr("Tags/Memberships", new Object[0]), "propertiesdialog", I18n.tr("Tags for selected objects.", new Object[0]), Shortcut.registerShortcut("subwindow:properties", I18n.tr("Toggle: {0}", I18n.tr("Tags/Memberships", new Object[0])), 80, 5007), 150, true);
        HelpUtil.setHelpContext(this, HelpUtil.ht("/Dialog/TagsMembership"));
        this.setupTagsMenu();
        this.buildTagsTable();
        this.setupMembershipMenu();
        this.buildMembershipTable();
        this.tagTableFilter = this.setupFilter();
        boolean bl = Main.pref.getBoolean("properties.presets.top", true);
        if (bl) {
            this.bothTables.add((Component)this.presets, GBC.std().fill(2).insets(5, 2, 5, 2).anchor(18));
            double d = Double.MIN_VALUE;
            this.bothTables.add((Component)pluginHook, GBC.eol().insets(0, 1, 1, 1).anchor(12).weight(d, d));
        }
        this.bothTables.add((Component)this.selectSth, GBC.eol().fill().insets(10, 10, 10, 10));
        this.bothTables.add((Component)this.tagTableFilter, GBC.eol().fill(2));
        this.bothTables.add((Component)this.tagTable.getTableHeader(), GBC.eol().fill(2));
        this.bothTables.add((Component)this.tagTable, GBC.eol().fill(1));
        this.bothTables.add((Component)this.membershipTable.getTableHeader(), GBC.eol().fill(2));
        this.bothTables.add((Component)this.membershipTable, GBC.eol().fill(1));
        if (!bl) {
            this.bothTables.add((Component)this.presets, GBC.eol().fill(2).insets(5, 2, 5, 2));
        }
        this.setupBlankSpaceMenu();
        this.setupKeyboardShortcuts();
        this.tagTable.getSelectionModel().addListSelectionListener(this.editAction);
        this.membershipTable.getSelectionModel().addListSelectionListener(this.editAction);
        this.tagTable.getSelectionModel().addListSelectionListener(this.deleteAction);
        this.membershipTable.getSelectionModel().addListSelectionListener(this.deleteAction);
        JScrollPane jScrollPane = (JScrollPane)this.createLayout(this.bothTables, true, Arrays.asList(this.btnAdd, this.btnEdit, this.btnDel));
        MouseClickWatch mouseClickWatch = new MouseClickWatch();
        this.tagTable.addMouseListener(mouseClickWatch);
        this.membershipTable.addMouseListener(mouseClickWatch);
        jScrollPane.addMouseListener(mouseClickWatch);
        this.selectSth.setPreferredSize(jScrollPane.getSize());
        this.presets.setSize(jScrollPane.getSize());
        this.editHelper.loadTagsIfNeeded();
        Main.pref.addKeyPreferenceChangeListener("display.discardable-keys", this.preferenceListener);
    }

    private void buildTagsTable() {
        this.tagData.setColumnIdentifiers(new String[]{I18n.tr("Key", new Object[0]), I18n.tr("Value", new Object[0])});
        this.tagTable.setSelectionMode(2);
        this.tagTable.getTableHeader().setReorderingAllowed(false);
        this.tagTable.getColumnModel().getColumn(0).setCellRenderer(this.cellRenderer);
        this.tagTable.getColumnModel().getColumn(1).setCellRenderer(this.cellRenderer);
        this.tagTable.setRowSorter(this.tagRowSorter);
        RemoveHiddenSelection removeHiddenSelection = new RemoveHiddenSelection();
        this.tagTable.getSelectionModel().addListSelectionListener(removeHiddenSelection);
        this.tagRowSorter.addRowSorterListener(removeHiddenSelection);
        this.tagRowSorter.setComparator(0, AlphanumComparator.getInstance());
        this.tagRowSorter.setComparator(1, (object, object2) -> {
            if (object instanceof Map && object2 instanceof Map) {
                String string = ((Map)object).size() == 1 ? (String)((Map)object).keySet().iterator().next() : I18n.tr("<different>", new Object[0]);
                String string2 = ((Map)object2).size() == 1 ? (String)((Map)object2).keySet().iterator().next() : I18n.tr("<different>", new Object[0]);
                return AlphanumComparator.getInstance().compare(string, string2);
            }
            return AlphanumComparator.getInstance().compare(String.valueOf(object), String.valueOf(object2));
        });
    }

    private void buildMembershipTable() {
        this.membershipData.setColumnIdentifiers(new String[]{I18n.tr("Member Of", new Object[0]), I18n.tr("Role", new Object[0]), I18n.tr("Position", new Object[0])});
        this.membershipTable.setSelectionMode(2);
        TableColumnModel tableColumnModel = this.membershipTable.getColumnModel();
        this.membershipTable.getTableHeader().setReorderingAllowed(false);
        tableColumnModel.getColumn(0).setCellRenderer(new MemberOfCellRenderer());
        tableColumnModel.getColumn(1).setCellRenderer(new RoleCellRenderer());
        tableColumnModel.getColumn(2).setCellRenderer(new PositionCellRenderer());
        tableColumnModel.getColumn(2).setPreferredWidth(20);
        tableColumnModel.getColumn(1).setPreferredWidth(40);
        tableColumnModel.getColumn(0).setPreferredWidth(200);
    }

    private void setupBlankSpaceMenu() {
        if (Main.pref.getBoolean("properties.menu.add_edit_delete", true)) {
            this.blankSpaceMenuHandler.addAction(this.addAction);
            BlankSpaceMenuLauncher blankSpaceMenuLauncher = new BlankSpaceMenuLauncher(this.blankSpaceMenu);
            this.bothTables.addMouseListener(blankSpaceMenuLauncher);
            this.tagTable.addMouseListener(blankSpaceMenuLauncher);
        }
    }

    private void setupMembershipMenu() {
        if (Main.pref.getBoolean("properties.menu.add_edit_delete", true)) {
            this.membershipMenuHandler.addAction(this.editAction);
            this.membershipMenuHandler.addAction(this.deleteAction);
            this.membershipMenu.addSeparator();
        }
        this.membershipMenuHandler.addAction(this.setRelationSelectionAction);
        this.membershipMenuHandler.addAction(this.selectRelationAction);
        this.membershipMenuHandler.addAction(this.addRelationToSelectionAction);
        this.membershipMenuHandler.addAction(this.selectMembersAction);
        this.membershipMenuHandler.addAction(this.addMembersToSelectionAction);
        this.membershipMenu.addSeparator();
        this.membershipMenuHandler.addAction(this.downloadMembersAction);
        this.membershipMenuHandler.addAction(this.downloadSelectedIncompleteMembersAction);
        this.membershipMenu.addSeparator();
        this.membershipMenu.add(this.helpAction);
        this.membershipMenu.add(this.taginfoAction);
        this.membershipTable.addMouseListener(new PopupMenuLauncher(this.membershipMenu){

            @Override
            protected int checkTableSelection(JTable jTable, Point point) {
                int n = super.checkTableSelection(jTable, point);
                ArrayList<Relation> arrayList = new ArrayList<Relation>();
                for (int n2 : jTable.getSelectedRows()) {
                    arrayList.add((Relation)jTable.getValueAt(n2, 0));
                }
                PropertiesDialog.this.membershipMenuHandler.setPrimitives(arrayList);
                return n;
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (Main.isDisplayingMapView() && (n = PropertiesDialog.this.membershipTable.rowAtPoint(mouseEvent.getPoint())) >= 0 && PropertiesDialog.this.highlightHelper.highlightOnly((Relation)PropertiesDialog.this.membershipTable.getValueAt(n, 0))) {
                    Main.map.mapView.repaint();
                }
                super.mouseClicked(mouseEvent);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PropertiesDialog.this.highlightHelper.clear();
            }
        });
    }

    private void setupTagsMenu() {
        if (Main.pref.getBoolean("properties.menu.add_edit_delete", true)) {
            this.tagMenu.add(this.addAction);
            this.tagMenu.add(this.editAction);
            this.tagMenu.add(this.deleteAction);
            this.tagMenu.addSeparator();
        }
        this.tagMenu.add(this.pasteValueAction);
        this.tagMenu.add(this.copyValueAction);
        this.tagMenu.add(this.copyKeyValueAction);
        this.tagMenu.add(this.copyAllKeyValueAction);
        this.tagMenu.addSeparator();
        this.tagMenu.add(this.searchActionAny);
        this.tagMenu.add(this.searchActionSame);
        this.tagMenu.addSeparator();
        this.tagMenu.add(this.helpAction);
        this.tagMenu.add(this.taginfoAction);
        this.tagTable.addMouseListener(new PopupMenuLauncher(this.tagMenu));
    }

    public void setFilter(SearchCompiler.Match match) {
        this.tagRowSorter.setRowFilter(new SearchBasedRowFilter(match));
    }

    private void setupKeyboardShortcuts() {
        InputMapUtils.addEnterActionWhenAncestor(this.tagTable, this.editAction);
        InputMapUtils.addEnterActionWhenAncestor(this.membershipTable, this.editAction);
        this.tagTable.getInputMap(1).put(KeyStroke.getKeyStroke(155, 0), "onTableInsert");
        this.tagTable.getActionMap().put("onTableInsert", this.addAction);
        InputMapUtils.unassignCtrlShiftUpDown(this.tagTable, 1);
        InputMapUtils.unassignPageUpDown(this.tagTable, 1);
        this.tagTable.setTransferHandler(null);
        this.tagTable.getInputMap(1).put(KeyStroke.getKeyStroke(67, 2), "onCopy");
        this.tagTable.getActionMap().put("onCopy", this.copyKeyValueAction);
        InputMapUtils.enableEnter(this.btnAdd);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.getActionMap().put("delete", this.deleteAction);
        this.getInputMap(1).put(this.helpAction.getKeyStroke(), "onHelp");
        this.getActionMap().put("onHelp", this.helpAction);
    }

    private JosmTextField setupFilter() {
        DisableShortcutsOnFocusGainedTextField disableShortcutsOnFocusGainedTextField = new DisableShortcutsOnFocusGainedTextField();
        disableShortcutsOnFocusGainedTextField.setToolTipText(I18n.tr("Tag filter", new Object[0]));
        CompileSearchTextDecorator compileSearchTextDecorator = CompileSearchTextDecorator.decorate(disableShortcutsOnFocusGainedTextField);
        disableShortcutsOnFocusGainedTextField.addPropertyChangeListener("filter", propertyChangeEvent -> this.setFilter(compileSearchTextDecorator.getMatch()));
        return disableShortcutsOnFocusGainedTextField;
    }

    private void editMembership(int n) {
        Relation relation = (Relation)this.membershipData.getValueAt(n, 0);
        Main.map.relationListDialog.selectRelation(relation);
        RelationEditor.getEditor(Main.getLayerManager().getEditLayer(), relation, ((MemberInfo)this.membershipData.getValueAt(n, 1)).role).setVisible(true);
    }

    private static int findViewRow(JTable jTable, TableModel tableModel, Object object) {
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            if (!tableModel.getValueAt(i, 0).equals(object)) continue;
            return jTable.convertRowIndexToView(i);
        }
        return -1;
    }

    private void updateSelection() {
        this.selectionChanged(null);
    }

    @Override
    public void showNotify() {
        DatasetEventManager.getInstance().addDatasetListener(this.dataChangedAdapter, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        SelectionEventManager.getInstance().addSelectionListener(this, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        Main.getLayerManager().addActiveLayerChangeListener(this);
        for (JosmAction josmAction : this.josmActions) {
            Main.registerActionShortcut(josmAction);
        }
        this.updateSelection();
    }

    @Override
    public void hideNotify() {
        DatasetEventManager.getInstance().removeDatasetListener(this.dataChangedAdapter);
        SelectionEventManager.getInstance().removeSelectionListener(this);
        Main.getLayerManager().removeActiveLayerChangeListener(this);
        for (JosmAction josmAction : this.josmActions) {
            Main.unregisterActionShortcut(josmAction);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && Main.getLayerManager().getEditDataSet() != null) {
            this.updateSelection();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        Main.pref.removeKeyPreferenceChangeListener("display.discardable-keys", this.preferenceListener);
        Container container = pluginHook.getParent();
        if (container != null) {
            container.remove(pluginHook);
        }
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        int n;
        int n2;
        Object object;
        Collection<OsmPrimitive> collection2;
        if (!this.isVisible()) {
            return;
        }
        if (this.tagTable == null) {
            return;
        }
        if (this.tagTable.getCellEditor() != null) {
            this.tagTable.getCellEditor().cancelCellEditing();
        }
        if ((collection2 = Main.main.getInProgressSelection()) == null) {
            collection2 = Collections.emptyList();
        }
        Relation relation3 = null;
        String string = this.editHelper.getChangedKey();
        if (string == null && this.tagTable.getSelectedRowCount() == 1) {
            string = this.editHelper.getDataKey(this.tagTable.getSelectedRow());
        }
        if (this.membershipTable.getSelectedRowCount() == 1) {
            relation3 = (Relation)this.membershipData.getValueAt(this.membershipTable.getSelectedRow(), 0);
        }
        this.tagData.setRowCount(0);
        boolean bl = Main.pref.getBoolean("display.discardable-keys", false);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        this.valueCount.clear();
        EnumSet<TaggingPresetType> enumSet = EnumSet.noneOf(TaggingPresetType.class);
        for (OsmPrimitive object22 : collection2) {
            enumSet.add(TaggingPresetType.forPrimitive(object22));
            for (String string2 : object22.keySet()) {
                if (!bl && OsmPrimitive.getDiscardableKeys().contains(string2)) continue;
                String string3 = object22.get(string2);
                hashMap.put(string2, hashMap.containsKey(string2) ? (Integer)hashMap.get(string2) + 1 : 1);
                if (this.valueCount.containsKey(string2)) {
                    object.put((Object)string3, (object = this.valueCount.get(string2)).containsKey(string3) ? (Integer)object.get(string3) + 1 : 1);
                    continue;
                }
                object = new TreeMap<String, Integer>();
                object.put(string3, 1);
                this.valueCount.put(string2, (Map<String, Integer>)object);
            }
        }
        for (Map.Entry entry : this.valueCount.entrySet()) {
            int n3 = 0;
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                n3 += ((Integer)entry2.getValue()).intValue();
            }
            if (n3 < collection2.size()) {
                ((Map)entry.getValue()).put("", collection2.size() - n3);
            }
            this.tagData.addRow(new Object[]{entry.getKey(), entry.getValue()});
            hashMap2.put((String)entry.getKey(), ((Map)entry.getValue()).size() == 1 ? (String)((Map)entry.getValue()).keySet().iterator().next() : I18n.tr("<different>", new Object[0]));
        }
        this.membershipData.setRowCount(0);
        HashMap hashMap3 = new HashMap();
        for (OsmPrimitive osmPrimitive : collection2) {
            for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers(true)) {
                if (!(osmPrimitive2 instanceof Relation) || osmPrimitive2.isIncomplete() || osmPrimitive2.isDeleted()) continue;
                object = (Relation)osmPrimitive2;
                MemberInfo memberInfo = (MemberInfo)hashMap3.get(object);
                if (memberInfo == null) {
                    memberInfo = new MemberInfo(collection2);
                }
                hashMap3.put(object, memberInfo);
                int n4 = 1;
                for (RelationMember relationMember : ((Relation)object).getMembers()) {
                    if (relationMember.getMember() == osmPrimitive) {
                        memberInfo.add(relationMember, n4);
                    }
                    ++n4;
                }
            }
        }
        ArrayList arrayList = new ArrayList(hashMap3.keySet());
        arrayList.sort((relation, relation2) -> {
            int n = Boolean.compare(relation.isDisabledAndHidden(), relation2.isDisabledAndHidden());
            return n != 0 ? n : DefaultNameFormatter.getInstance().getRelationComparator().compare((Relation)relation, (Relation)relation2);
        });
        for (Relation relation4 : arrayList) {
            this.membershipData.addRow(new Object[]{relation4, hashMap3.get(relation4)});
        }
        this.presets.updatePresets(enumSet, hashMap2, this.presetHandler);
        this.membershipTable.getTableHeader().setVisible(this.membershipData.getRowCount() > 0);
        this.membershipTable.setVisible(this.membershipData.getRowCount() > 0);
        boolean bl2 = !collection2.isEmpty();
        boolean bl3 = bl2 && this.tagData.getRowCount() > 0;
        boolean bl4 = bl2 && this.membershipData.getRowCount() > 0;
        this.addAction.setEnabled(bl2);
        this.editAction.setEnabled(bl3 || bl4);
        this.deleteAction.setEnabled(bl3 || bl4);
        this.tagTable.setVisible(bl3);
        this.tagTable.getTableHeader().setVisible(bl3);
        this.tagTableFilter.setVisible(bl3);
        this.selectSth.setVisible(!bl2);
        pluginHook.setVisible(bl2);
        if (string != null && (n2 = PropertiesDialog.findViewRow(this.tagTable, this.tagData, string)) != -1) {
            this.tagTable.changeSelection(n2, 0, false, false);
        } else if (relation3 != null && (n = PropertiesDialog.findViewRow(this.membershipTable, this.membershipData, relation3)) != -1) {
            this.membershipTable.changeSelection(n, 0, false, false);
        } else if (bl3) {
            this.tagTable.changeSelection(0, 0, false, false);
        } else if (bl4) {
            this.membershipTable.changeSelection(0, 0, false, false);
        }
        if (this.tagData.getRowCount() != 0 || this.membershipData.getRowCount() != 0) {
            if (collection2.size() > 1) {
                this.setTitle(I18n.tr("Objects: {2} / Tags: {0} / Memberships: {1}", this.tagData.getRowCount(), this.membershipData.getRowCount(), collection2.size()));
            } else {
                this.setTitle(I18n.tr("Tags: {0} / Memberships: {1}", this.tagData.getRowCount(), this.membershipData.getRowCount()));
            }
        } else {
            this.setTitle(I18n.tr("Tags / Memberships", new Object[0]));
        }
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent activeLayerChangeEvent) {
        if (activeLayerChangeEvent.getSource().getEditLayer() == null) {
            this.editHelper.saveTagsIfNeeded();
        }
        this.updateSelection();
    }

    @Override
    public void processDatasetEvent(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
        this.updateSelection();
    }

    public PopupMenuHandler getPropertyPopupMenuHandler() {
        return this.tagMenuHandler;
    }

    public Tag getSelectedProperty() {
        int n = this.tagTable.getSelectedRow();
        if (n == -1) {
            return null;
        }
        Map<String, Integer> map = this.editHelper.getDataValues(n);
        return new Tag(this.editHelper.getDataKey(n), map.size() > 1 ? "" : map.keySet().iterator().next());
    }

    public PopupMenuHandler getMembershipPopupMenuHandler() {
        return this.membershipMenuHandler;
    }

    public IRelation getSelectedMembershipRelation() {
        int n = this.membershipTable.getSelectedRow();
        return n > -1 ? (IRelation)this.membershipData.getValueAt(n, 0) : null;
    }

    public void addCustomPropertiesCellRenderer(TableCellRenderer tableCellRenderer) {
        this.cellRenderer.addCustomRenderer(tableCellRenderer);
    }

    public void removeCustomPropertiesCellRenderer(TableCellRenderer tableCellRenderer) {
        this.cellRenderer.removeCustomRenderer(tableCellRenderer);
    }

    static SearchAction.SearchSetting createSearchSetting(String string, Collection<OsmPrimitive> collection, boolean bl) {
        String string2 = "";
        StringBuilder stringBuilder = new StringBuilder();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (OsmPrimitive osmPrimitive : collection) {
            String string3;
            String string4 = osmPrimitive.get(string);
            if (string4 == null || !bl && treeSet.contains(string4)) continue;
            String string5 = "";
            if (!bl) {
                string5 = "";
            } else if (osmPrimitive instanceof Node) {
                string5 = "type:node ";
            } else if (osmPrimitive instanceof Way) {
                string5 = "type:way ";
            } else if (osmPrimitive instanceof Relation) {
                string5 = "type:relation ";
            }
            if (!treeSet.add(string3 = string5 + string4)) continue;
            stringBuilder.append(string2).append('(').append(string5).append(SearchCompiler.buildSearchStringForTag(string, string4)).append(')');
            string2 = " OR ";
        }
        SearchAction.SearchSetting searchSetting = new SearchAction.SearchSetting();
        searchSetting.text = stringBuilder.toString();
        searchSetting.caseSensitive = true;
        return searchSetting;
    }

    private class RemoveHiddenSelection
    implements ListSelectionListener,
    RowSorterListener {
        private RemoveHiddenSelection() {
        }

        void removeHiddenSelection() {
            try {
                PropertiesDialog.this.tagRowSorter.convertRowIndexToModel(PropertiesDialog.this.tagTable.getSelectedRow());
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Main.trace(indexOutOfBoundsException);
                Main.trace("Clearing tagTable selection");
                PropertiesDialog.this.tagTable.clearSelection();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.removeHiddenSelection();
        }

        @Override
        public void sorterChanged(RowSorterEvent rowSorterEvent) {
            this.removeHiddenSelection();
        }
    }

    class SearchAction
    extends AbstractAction {
        private final boolean sameType;

        SearchAction(boolean bl) {
            this.sameType = bl;
            if (bl) {
                this.putValue("Name", I18n.tr("Search Key/Value/Type", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Search with the key and value of the selected tag, restrict to type (i.e., node/way/relation)", new Object[0]));
            } else {
                this.putValue("Name", I18n.tr("Search Key/Value", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Search with the key and value of the selected tag", new Object[0]));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PropertiesDialog.this.tagTable.getSelectedRowCount() != 1) {
                return;
            }
            String string = PropertiesDialog.this.editHelper.getDataKey(PropertiesDialog.this.tagTable.getSelectedRow());
            Collection<OsmPrimitive> collection = Main.main.getInProgressSelection();
            if (collection.isEmpty()) {
                return;
            }
            SearchAction.SearchSetting searchSetting = PropertiesDialog.createSearchSetting(string, collection, this.sameType);
            org.openstreetmap.josm.actions.search.SearchAction.searchWithoutHistory(searchSetting);
        }
    }

    class CopyAllKeyValueAction
    extends AbstractCopyAction {
        CopyAllKeyValueAction() {
            this.putValue("Name", I18n.tr("Copy all Keys/Values", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Copy the key and value of all the tags to clipboard", new Object[0]));
            Shortcut shortcut = Shortcut.registerShortcut("system:copytags", I18n.tr("Edit: {0}", I18n.tr("Copy Tags", new Object[0])), 65535, 5000);
            Main.registerActionShortcut(this, shortcut);
            shortcut.setAccelerator(this);
        }

        @Override
        protected Collection<String> getString(OsmPrimitive osmPrimitive, String string) {
            LinkedList<String> linkedList = new LinkedList<String>();
            for (Map.Entry<String, String> entry : osmPrimitive.getKeys().entrySet()) {
                linkedList.add(new Tag(entry.getKey(), entry.getValue()).toString());
            }
            return linkedList;
        }
    }

    class CopyKeyValueAction
    extends AbstractCopyAction {
        CopyKeyValueAction() {
            this.putValue("Name", I18n.tr("Copy selected Key(s)/Value(s)", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Copy the key and value of the selected tag(s) to clipboard", new Object[0]));
        }

        @Override
        protected Collection<String> getString(OsmPrimitive osmPrimitive, String string) {
            String string2 = osmPrimitive.get(string);
            return string2 == null ? null : Collections.singleton(new Tag(string, string2).toString());
        }
    }

    class CopyValueAction
    extends AbstractCopyAction {
        CopyValueAction() {
            this.putValue("Name", I18n.tr("Copy Value", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Copy the value of the selected tag to clipboard", new Object[0]));
        }

        @Override
        protected Collection<String> getString(OsmPrimitive osmPrimitive, String string) {
            String string2 = osmPrimitive.get(string);
            return string2 == null ? null : Collections.singleton(string2);
        }
    }

    abstract class AbstractCopyAction
    extends AbstractAction {
        AbstractCopyAction() {
        }

        protected abstract Collection<String> getString(OsmPrimitive var1, String var2);

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = PropertiesDialog.this.tagTable.getSelectedRows();
            TreeSet<String> treeSet = new TreeSet<String>();
            Collection<OsmPrimitive> collection = Main.main.getInProgressSelection();
            if (nArray.length == 0 || collection.isEmpty()) {
                return;
            }
            for (int n : nArray) {
                String string = PropertiesDialog.this.editHelper.getDataKey(n);
                if (collection.isEmpty()) {
                    return;
                }
                for (OsmPrimitive osmPrimitive : collection) {
                    Collection<String> collection2 = this.getString(osmPrimitive, string);
                    if (collection2 == null) continue;
                    treeSet.addAll(collection2);
                }
            }
            if (!treeSet.isEmpty()) {
                ClipboardUtils.copyString(Utils.join("\n", treeSet));
            }
        }
    }

    class PasteValueAction
    extends AbstractAction {
        PasteValueAction() {
            this.putValue("Name", I18n.tr("Paste Value", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Paste the value of the selected tag from clipboard", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PropertiesDialog.this.tagTable.getSelectedRowCount() != 1) {
                return;
            }
            String string = PropertiesDialog.this.editHelper.getDataKey(PropertiesDialog.this.tagTable.getSelectedRow());
            Collection<OsmPrimitive> collection = Main.main.getInProgressSelection();
            String string2 = ClipboardUtils.getClipboardStringContent();
            if (collection.isEmpty() || string2 == null) {
                return;
            }
            Main.main.undoRedo.add(new ChangePropertyCommand(collection, string, Utils.strip(string2)));
        }
    }

    class TaginfoAction
    extends JosmAction {
        final transient StringProperty TAGINFO_URL_PROP;

        TaginfoAction() {
            super(I18n.tr("Go to Taginfo", new Object[0]), "dialogs/taginfo", I18n.tr("Launch browser with Taginfo statistics for selected object", new Object[0]), null, false);
            this.TAGINFO_URL_PROP = new StringProperty("taginfo.url", "https://taginfo.openstreetmap.org/");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            if (PropertiesDialog.this.tagTable.getSelectedRowCount() == 1) {
                int n = PropertiesDialog.this.tagTable.getSelectedRow();
                String string2 = Utils.encodeUrl(PropertiesDialog.this.editHelper.getDataKey(n));
                Map<String, Integer> map = PropertiesDialog.this.editHelper.getDataValues(n);
                string = map.size() == 1 ? this.TAGINFO_URL_PROP.get() + "tags/" + string2 + '=' + Utils.encodeUrl(map.keySet().iterator().next()) : this.TAGINFO_URL_PROP.get() + "keys/" + string2;
            } else if (PropertiesDialog.this.membershipTable.getSelectedRowCount() == 1) {
                String string3 = ((Relation)PropertiesDialog.this.membershipData.getValueAt(PropertiesDialog.this.membershipTable.getSelectedRow(), 0)).get("type");
                string = this.TAGINFO_URL_PROP.get() + "relations/" + string3;
            } else {
                return;
            }
            OpenBrowser.displayUrl(string);
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", I18n.tr("Go to OSM wiki for tag help", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Launch browser with wiki help for selected object", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "search"));
            this.putValue("AcceleratorKey", this.getKeyStroke());
        }

        public KeyStroke getKeyStroke() {
            return KeyStroke.getKeyStroke(112, 0);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = Main.pref.get("url.openstreetmap-wiki", "https://wiki.openstreetmap.org/wiki/");
                String string2 = LanguageInfo.getWikiLanguagePrefix();
                ArrayList<URI> arrayList = new ArrayList<URI>();
                if (PropertiesDialog.this.tagTable.getSelectedRowCount() == 1) {
                    int n = PropertiesDialog.this.tagTable.getSelectedRow();
                    String string3 = Utils.encodeUrl(PropertiesDialog.this.editHelper.getDataKey(n));
                    Map<String, Integer> map = PropertiesDialog.this.editHelper.getDataValues(n);
                    String string4 = Utils.encodeUrl(map.entrySet().iterator().next().getKey());
                    arrayList.add(new URI(String.format("%s%sTag:%s=%s", string, string2, string3, string4)));
                    arrayList.add(new URI(String.format("%sTag:%s=%s", string, string3, string4)));
                    arrayList.add(new URI(String.format("%s%sKey:%s", string, string2, string3)));
                    arrayList.add(new URI(String.format("%sKey:%s", string, string3)));
                    arrayList.add(new URI(String.format("%s%sMap_Features", string, string2)));
                    arrayList.add(new URI(String.format("%sMap_Features", string)));
                } else if (PropertiesDialog.this.membershipTable.getSelectedRowCount() == 1) {
                    int n = PropertiesDialog.this.membershipTable.getSelectedRow();
                    String string5 = ((Relation)PropertiesDialog.this.membershipData.getValueAt(n, 0)).get("type");
                    if (string5 != null) {
                        string5 = Utils.encodeUrl(string5);
                    }
                    if (string5 != null && !string5.isEmpty()) {
                        arrayList.add(new URI(String.format("%s%sRelation:%s", string, string2, string5)));
                        arrayList.add(new URI(String.format("%sRelation:%s", string, string5)));
                    }
                    arrayList.add(new URI(String.format("%s%sRelations", string, string2)));
                    arrayList.add(new URI(String.format("%sRelations", string)));
                } else {
                    arrayList.add(new URI(String.format("%s%sMap_Features", string, string2)));
                    arrayList.add(new URI(String.format("%sMap_Features", string)));
                }
                Main.worker.execute(() -> this.displayHelp(arrayList));
            }
            catch (URISyntaxException uRISyntaxException) {
                Main.error(uRISyntaxException);
            }
        }

        private void displayHelp(List<URI> list) {
            try {
                for (URI uRI : list) {
                    HttpClient.Response response = HttpClient.create(uRI.toURL(), "HEAD").connect();
                    if (response.getResponseCode() != 200) {
                        response.disconnect();
                        continue;
                    }
                    long l = response.getContentLength();
                    if (l > -1L) {
                        response.disconnect();
                        URI uRI2 = new URI(uRI.toString().replace("=", "%3D").replaceFirst("/wiki/", "/w/index.php?redirect=no&title="));
                        response = HttpClient.create(uRI2.toURL(), "HEAD").connect();
                    }
                    if (l > -1L && response.getContentLength() != -1L && Math.abs(response.getContentLength() - l) > 200L) {
                        Main.info("{0} is a mediawiki redirect", uRI);
                        response.disconnect();
                        continue;
                    }
                    response.disconnect();
                    OpenBrowser.displayUrl(uRI.toString());
                    break;
                }
            }
            catch (IOException | URISyntaxException exception) {
                Main.error(exception);
            }
        }
    }

    class EditAction
    extends JosmAction
    implements ListSelectionListener {
        EditAction() {
            super(I18n.tr("Edit", new Object[0]), "dialogs/edit", I18n.tr("Edit the value of the selected key for all objects", new Object[0]), Shortcut.registerShortcut("properties:edit", I18n.tr("Edit Tags", new Object[0]), 83, 5004), false);
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            if (PropertiesDialog.this.tagTable.getSelectedRowCount() == 1) {
                int n = PropertiesDialog.this.tagTable.getSelectedRow();
                PropertiesDialog.this.editHelper.editTag(n, false);
            } else if (PropertiesDialog.this.membershipTable.getSelectedRowCount() == 1) {
                int n = PropertiesDialog.this.membershipTable.getSelectedRow();
                PropertiesDialog.this.editMembership(n);
            }
        }

        @Override
        protected void updateEnabledState() {
            this.setEnabled((PropertiesDialog.this.tagTable != null && PropertiesDialog.this.tagTable.getSelectedRowCount() == 1) ^ (PropertiesDialog.this.membershipTable != null && PropertiesDialog.this.membershipTable.getSelectedRowCount() == 1));
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class AddAction
    extends JosmAction {
        AddAction() {
            super(I18n.tr("Add", new Object[0]), "dialogs/add", I18n.tr("Add a new key/value pair to all objects", new Object[0]), Shortcut.registerShortcut("properties:add", I18n.tr("Add Tag", new Object[0]), 65, 5004), false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PropertiesDialog.this.editHelper.addTag();
            PropertiesDialog.this.btnAdd.requestFocusInWindow();
        }
    }

    class DeleteAction
    extends JosmAction
    implements ListSelectionListener {
        private static final String DELETE_FROM_RELATION_PREF = "delete_from_relation";

        DeleteAction() {
            super(I18n.tr("Delete", new Object[0]), "dialogs/delete", I18n.tr("Delete the selected key in all objects", new Object[0]), Shortcut.registerShortcut("properties:delete", I18n.tr("Delete Tags", new Object[0]), 68, 5010), false);
            this.updateEnabledState();
        }

        /*
         * WARNING - void declaration
         */
        protected void deleteTags(int ... nArray) {
            void var4_7;
            HashMap<String, String> hashMap = new HashMap<String, String>(nArray.length);
            int n = nArray[0];
            for (int n2 : nArray) {
                String string = PropertiesDialog.this.editHelper.getDataKey(n2);
                if (n2 == n + 1) {
                    n = n2;
                }
                hashMap.put(string, null);
            }
            Object var4_5 = null;
            int n3 = PropertiesDialog.this.tagData.getRowCount();
            if (n3 > nArray.length) {
                n = n == nArray[nArray.length - 1] ? (n + 1 < n3 ? n + 1 : nArray[0] - 1) : ++n;
                String string = PropertiesDialog.this.editHelper.getDataKey(n);
            }
            Collection<OsmPrimitive> collection = Main.main.getInProgressSelection();
            Main.main.undoRedo.add(new ChangePropertyCommand(collection, hashMap));
            PropertiesDialog.this.membershipTable.clearSelection();
            if (var4_7 != null) {
                PropertiesDialog.this.tagTable.changeSelection(PropertiesDialog.findViewRow(PropertiesDialog.this.tagTable, PropertiesDialog.this.tagData, var4_7), 0, false, false);
            }
        }

        protected void deleteFromRelation(int n) {
            Relation relation = (Relation)PropertiesDialog.this.membershipData.getValueAt(n, 0);
            Relation relation2 = null;
            int n2 = PropertiesDialog.this.membershipTable.getRowCount();
            if (n2 > 1) {
                relation2 = (Relation)PropertiesDialog.this.membershipData.getValueAt(n + 1 < n2 ? n + 1 : n - 1, 0);
            }
            ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Change relation", new Object[0]), I18n.tr("Delete from relation", new Object[0]), I18n.tr("Cancel", new Object[0]));
            extendedDialog.setButtonIcons("dialogs/delete", "cancel");
            extendedDialog.setContent(I18n.tr("Really delete selection from relation {0}?", relation.getDisplayName(DefaultNameFormatter.getInstance())));
            extendedDialog.toggleEnable(DELETE_FROM_RELATION_PREF);
            extendedDialog.showDialog();
            if (extendedDialog.getValue() != 1) {
                return;
            }
            Relation relation3 = new Relation(relation);
            for (OsmPrimitive osmPrimitive : Main.main.getInProgressSelection()) {
                relation3.removeMembersFor(osmPrimitive);
            }
            Main.main.undoRedo.add(new ChangeCommand(relation, relation3));
            PropertiesDialog.this.tagTable.clearSelection();
            if (relation2 != null) {
                PropertiesDialog.this.membershipTable.changeSelection(PropertiesDialog.findViewRow(PropertiesDialog.this.membershipTable, PropertiesDialog.this.membershipData, relation2), 0, false, false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PropertiesDialog.this.tagTable.getSelectedRowCount() > 0) {
                int[] nArray = PropertiesDialog.this.tagTable.getSelectedRows();
                this.deleteTags(nArray);
            } else if (PropertiesDialog.this.membershipTable.getSelectedRowCount() > 0) {
                ConditionalOptionPaneUtil.startBulkOperation(DELETE_FROM_RELATION_PREF);
                int[] nArray = PropertiesDialog.this.membershipTable.getSelectedRows();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    this.deleteFromRelation(nArray[i]);
                }
                ConditionalOptionPaneUtil.endBulkOperation(DELETE_FROM_RELATION_PREF);
            }
        }

        @Override
        protected final void updateEnabledState() {
            this.setEnabled(PropertiesDialog.this.tagTable != null && PropertiesDialog.this.tagTable.getSelectedRowCount() >= 1 || PropertiesDialog.this.membershipTable != null && PropertiesDialog.this.membershipTable.getSelectedRowCount() > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    public static class ReadOnlyTableModel
    extends DefaultTableModel {
        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }
    }

    static class MemberInfo {
        private final List<RelationMember> role = new ArrayList<RelationMember>();
        private Set<OsmPrimitive> members = new HashSet<OsmPrimitive>();
        private List<Integer> position = new ArrayList<Integer>();
        private Collection<OsmPrimitive> selection;
        private String positionString;
        private String roleString;

        MemberInfo(Collection<OsmPrimitive> collection) {
            this.selection = collection;
        }

        void add(RelationMember relationMember, Integer n) {
            this.role.add(relationMember);
            this.members.add(relationMember.getMember());
            this.position.add(n);
        }

        String getPositionString() {
            if (this.positionString == null) {
                this.positionString = Utils.getPositionListString(this.position);
                if (this.selection.stream().anyMatch(osmPrimitive -> !this.members.contains(osmPrimitive))) {
                    this.positionString = this.positionString + ",\u2717";
                }
                this.members = null;
                this.position = null;
                this.selection = null;
            }
            return Utils.shortenString(this.positionString, 20);
        }

        String getRoleString() {
            if (this.roleString == null) {
                for (RelationMember relationMember : this.role) {
                    if (this.roleString == null) {
                        this.roleString = relationMember.getRole();
                        continue;
                    }
                    if (this.roleString.equals(relationMember.getRole())) continue;
                    this.roleString = I18n.tr("<different>", new Object[0]);
                    break;
                }
            }
            return this.roleString;
        }

        public String toString() {
            return "MemberInfo{roles='" + this.roleString + '\'' + ", positions='" + this.positionString + '\'' + '}';
        }
    }

    public class MouseClickWatch
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() < 2) {
                if (mouseEvent.getSource() == PropertiesDialog.this.tagTable) {
                    PropertiesDialog.this.membershipTable.clearSelection();
                } else if (mouseEvent.getSource() == PropertiesDialog.this.membershipTable) {
                    PropertiesDialog.this.tagTable.clearSelection();
                }
            } else if (mouseEvent.getSource() == PropertiesDialog.this.tagTable) {
                int n = PropertiesDialog.this.tagTable.rowAtPoint(mouseEvent.getPoint());
                if (n > -1) {
                    boolean bl = PropertiesDialog.this.tagTable.columnAtPoint(mouseEvent.getPoint()) == 0;
                    PropertiesDialog.this.editHelper.editTag(n, bl);
                } else {
                    PropertiesDialog.this.editHelper.addTag();
                    PropertiesDialog.this.btnAdd.requestFocusInWindow();
                }
            } else if (mouseEvent.getSource() == PropertiesDialog.this.membershipTable) {
                int n = PropertiesDialog.this.membershipTable.rowAtPoint(mouseEvent.getPoint());
                if (n > -1) {
                    PropertiesDialog.this.editMembership(n);
                }
            } else {
                PropertiesDialog.this.editHelper.addTag();
                PropertiesDialog.this.btnAdd.requestFocusInWindow();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == PropertiesDialog.this.tagTable) {
                PropertiesDialog.this.membershipTable.clearSelection();
            } else if (mouseEvent.getSource() == PropertiesDialog.this.membershipTable) {
                PropertiesDialog.this.tagTable.clearSelection();
            }
        }
    }

    static final class TaggingPresetCommandHandler
    implements TaggingPresetHandler {
        TaggingPresetCommandHandler() {
        }

        @Override
        public void updateTags(List<Tag> list) {
            Command command = TaggingPreset.createCommand(this.getSelection(), list);
            if (command != null) {
                Main.main.undoRedo.add(command);
            }
        }

        @Override
        public Collection<OsmPrimitive> getSelection() {
            return Main.main == null ? Collections.emptyList() : Main.main.getInProgressSelection();
        }
    }

    static final class BlankSpaceMenuLauncher
    extends PopupMenuLauncher {
        BlankSpaceMenuLauncher(JPopupMenu jPopupMenu) {
            super(jPopupMenu);
        }

        @Override
        protected boolean checkSelection(Component component, Point point) {
            if (component instanceof JTable) {
                return ((JTable)component).rowAtPoint(point) == -1;
            }
            return true;
        }
    }

    static final class PositionCellRenderer
    extends DefaultTableCellRenderer {
        PositionCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
            boolean bl3 = ((Relation)jTable.getValueAt(n, 0)).isDisabledAndHidden();
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                jLabel.setText(((MemberInfo)jTable.getValueAt(n, 1)).getPositionString());
                if (bl3) {
                    jLabel.setFont(jLabel.getFont().deriveFont(2));
                }
            }
            return component;
        }
    }

    static final class RoleCellRenderer
    extends DefaultTableCellRenderer {
        RoleCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return this;
            }
            Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
            boolean bl3 = ((Relation)jTable.getValueAt(n, 0)).isDisabledAndHidden();
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                jLabel.setText(((MemberInfo)object).getRoleString());
                if (bl3) {
                    jLabel.setFont(jLabel.getFont().deriveFont(2));
                }
            }
            return component;
        }
    }

    static final class MemberOfCellRenderer
    extends DefaultTableCellRenderer {
        MemberOfCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
            if (object == null) {
                return this;
            }
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                Relation relation = (Relation)object;
                jLabel.setText(relation.getDisplayName(DefaultNameFormatter.getInstance()));
                if (relation.isDisabledAndHidden()) {
                    jLabel.setFont(jLabel.getFont().deriveFont(2));
                }
            }
            return component;
        }
    }
}

