/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.progress;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapStatus;
import org.openstreetmap.josm.gui.PleaseWaitDialog;
import org.openstreetmap.josm.gui.progress.AbstractProgressMonitor;
import org.openstreetmap.josm.gui.progress.CancelHandler;
import org.openstreetmap.josm.gui.progress.ProgressException;
import org.openstreetmap.josm.gui.progress.ProgressTaskId;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public class PleaseWaitProgressMonitor
extends AbstractProgressMonitor {
    public static final int PROGRESS_BAR_MAX = 10000;
    private final Component dialogParent;
    private int currentProgressValue;
    private String customText;
    private String title;
    private boolean indeterminate;
    private boolean isInBackground;
    private PleaseWaitDialog dialog;
    private String windowTitle;
    protected ProgressTaskId taskId;
    private boolean cancelable;
    private final ActionListener cancelListener = actionEvent -> this.cancel();
    private final ActionListener inBackgroundListener = actionEvent -> {
        this.isInBackground = true;
        ProgressMonitorDialog progressMonitorDialog = this.getDialog();
        if (progressMonitorDialog != null) {
            this.reset();
            progressMonitorDialog.setVisible(true);
        }
    };
    private final WindowListener windowListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            PleaseWaitProgressMonitor.this.cancel();
        }
    };

    private void doInEDT(Runnable runnable) {
        SwingUtilities.invokeLater(() -> {
            try {
                runnable.run();
            }
            catch (RuntimeException runtimeException) {
                throw BugReport.intercept(runtimeException).put("monitor", this);
            }
        });
    }

    private void setDialogVisible(boolean bl) {
        if (this.dialog.isVisible() != bl) {
            this.dialog.setVisible(bl);
        }
    }

    private ProgressMonitorDialog getDialog() {
        MapStatus.BackgroundProgressMonitor backgroundProgressMonitor = null;
        MapFrame mapFrame = Main.map;
        if (mapFrame != null) {
            backgroundProgressMonitor = mapFrame.statusLine.progressMonitor;
        }
        if (backgroundProgressMonitor != null) {
            backgroundProgressMonitor.setVisible(this.isInBackground);
        }
        if (this.dialog != null) {
            this.setDialogVisible(!this.isInBackground || backgroundProgressMonitor == null);
        }
        if (this.isInBackground && backgroundProgressMonitor != null) {
            backgroundProgressMonitor.setVisible(true);
            if (this.dialog != null) {
                this.setDialogVisible(false);
            }
            return backgroundProgressMonitor;
        }
        if (backgroundProgressMonitor != null) {
            backgroundProgressMonitor.setVisible(false);
            if (this.dialog != null) {
                this.setDialogVisible(true);
            }
            return this.dialog;
        }
        if (this.dialog != null) {
            this.setDialogVisible(true);
            return this.dialog;
        }
        return null;
    }

    public PleaseWaitProgressMonitor() {
        this("");
    }

    public PleaseWaitProgressMonitor(String string) {
        this(Main.parent);
        this.windowTitle = string;
    }

    public PleaseWaitProgressMonitor(Component component) {
        super(new CancelHandler());
        this.dialogParent = GraphicsEnvironment.isHeadless() ? component : GuiHelper.getFrameForComponent(component);
        this.cancelable = true;
    }

    public PleaseWaitProgressMonitor(Component component, String string) {
        this(GuiHelper.getFrameForComponent(component));
        this.windowTitle = string;
    }

    public final boolean isCancelable() {
        return this.cancelable;
    }

    public final void setCancelable(boolean bl) {
        this.cancelable = bl;
    }

    @Override
    public void doBeginTask() {
        this.doInEDT(() -> {
            Main.currentProgressMonitor = this;
            if (GraphicsEnvironment.isHeadless()) {
                return;
            }
            if (this.dialogParent == null || this.dialog != null) {
                throw new ProgressException("PleaseWaitDialog parent must be set", new Object[0]);
            }
            this.dialog = new PleaseWaitDialog(this.dialogParent);
            if (this.windowTitle != null) {
                this.dialog.setTitle(this.windowTitle);
            }
            this.dialog.setCancelEnabled(this.cancelable);
            this.dialog.setCancelCallback(this.cancelListener);
            this.dialog.setInBackgroundCallback(this.inBackgroundListener);
            this.dialog.setCustomText("");
            this.dialog.addWindowListener(this.windowListener);
            this.dialog.progress.setMaximum(10000);
            this.dialog.setVisible(true);
        });
    }

    @Override
    public void doFinishTask() {
    }

    @Override
    protected void updateProgress(double d) {
        int n = (int)(d * 10000.0);
        if (n != this.currentProgressValue) {
            this.currentProgressValue = n;
            this.doInEDT(() -> {
                ProgressMonitorDialog progressMonitorDialog = this.getDialog();
                if (progressMonitorDialog != null) {
                    progressMonitorDialog.updateProgress(this.currentProgressValue);
                }
            });
        }
    }

    @Override
    protected void doSetCustomText(String string) {
        this.checkState(AbstractProgressMonitor.State.IN_TASK, AbstractProgressMonitor.State.IN_SUBTASK);
        this.customText = string;
        this.doInEDT(() -> {
            ProgressMonitorDialog progressMonitorDialog = this.getDialog();
            if (progressMonitorDialog != null) {
                progressMonitorDialog.setCustomText(string);
            }
        });
    }

    @Override
    protected void doSetTitle(String string) {
        this.checkState(AbstractProgressMonitor.State.IN_TASK, AbstractProgressMonitor.State.IN_SUBTASK);
        this.title = string;
        this.doInEDT(() -> {
            ProgressMonitorDialog progressMonitorDialog = this.getDialog();
            if (progressMonitorDialog != null) {
                progressMonitorDialog.setCurrentAction(string);
            }
        });
    }

    @Override
    protected void doSetIntermediate(boolean bl) {
        this.indeterminate = bl;
        this.doInEDT(() -> {
            ProgressMonitorDialog progressMonitorDialog = this.getDialog();
            if (progressMonitorDialog != null) {
                progressMonitorDialog.setIndeterminate(bl && this.currentProgressValue == 0);
            }
        });
    }

    @Override
    public void appendLogMessage(String string) {
        this.doInEDT(() -> {
            ProgressMonitorDialog progressMonitorDialog = this.getDialog();
            if (progressMonitorDialog != null) {
                progressMonitorDialog.appendLogMessage(string);
            }
        });
    }

    public void reset() {
        if (this.dialog != null) {
            this.dialog.setTitle(this.title);
            this.dialog.setCustomText(this.customText);
            this.dialog.updateProgress(this.currentProgressValue);
            this.dialog.setIndeterminate(this.indeterminate && this.currentProgressValue == 0);
        }
        MapStatus.BackgroundProgressMonitor backgroundProgressMonitor = null;
        MapFrame mapFrame = Main.map;
        if (mapFrame != null) {
            backgroundProgressMonitor = mapFrame.statusLine.progressMonitor;
        }
        if (backgroundProgressMonitor != null) {
            backgroundProgressMonitor.setCurrentAction(this.title);
            backgroundProgressMonitor.setCustomText(this.customText);
            backgroundProgressMonitor.updateProgress(this.currentProgressValue);
            backgroundProgressMonitor.setIndeterminate(this.indeterminate && this.currentProgressValue == 0);
        }
    }

    public void close() {
        this.doInEDT(() -> {
            if (this.dialog != null) {
                this.dialog.setVisible(false);
                this.dialog.setCancelCallback(null);
                this.dialog.setInBackgroundCallback(null);
                this.dialog.removeWindowListener(this.windowListener);
                this.dialog.dispose();
                this.dialog = null;
                Main.currentProgressMonitor = null;
                MapFrame mapFrame = Main.map;
                if (mapFrame != null) {
                    mapFrame.statusLine.progressMonitor.setVisible(false);
                }
            }
        });
    }

    public void showForegroundDialog() {
        this.isInBackground = false;
        this.doInEDT(() -> {
            if (this.dialog != null) {
                this.dialog.setInBackgroundPossible(this.taskId != null && Main.isDisplayingMapView());
                this.reset();
                this.getDialog();
            }
        });
    }

    @Override
    public void setProgressTaskId(ProgressTaskId progressTaskId) {
        this.taskId = progressTaskId;
        this.doInEDT(() -> {
            if (this.dialog != null) {
                this.dialog.setInBackgroundPossible(progressTaskId != null && Main.isDisplayingMapView());
            }
        });
    }

    @Override
    public ProgressTaskId getProgressTaskId() {
        return this.taskId;
    }

    @Override
    public Component getWindowParent() {
        PleaseWaitDialog pleaseWaitDialog = this.dialog;
        if (this.isInBackground || pleaseWaitDialog == null) {
            return Main.parent;
        }
        return pleaseWaitDialog;
    }

    public String toString() {
        return "PleaseWaitProgressMonitor [currentProgressValue=" + this.currentProgressValue + ", customText=" + this.customText + ", title=" + this.title + ", indeterminate=" + this.indeterminate + ", isInBackground=" + this.isInBackground + ", windowTitle=" + this.windowTitle + ", taskId=" + this.taskId + ", cancelable=" + this.cancelable + ", state=" + (Object)((Object)this.state) + "]";
    }

    public static interface ProgressMonitorDialog {
        public void setVisible(boolean var1);

        public void updateProgress(int var1);

        public void setCustomText(String var1);

        public void setCurrentAction(String var1);

        public void setIndeterminate(boolean var1);

        public void appendLogMessage(String var1);
    }
}

