/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public abstract class JosmTable
extends JTable {
    private int colEnd;
    protected SelectNextColumnCellAction selectNextColumnCellAction;
    protected SelectPreviousColumnCellAction selectPreviousColumnCellAction;

    protected JosmTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        this(tableModel, tableColumnModel, null);
    }

    protected JosmTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
    }

    protected void installCustomNavigation(int n) {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, false), "selectNextColumnCell");
        this.colEnd = n;
        this.selectNextColumnCellAction = new SelectNextColumnCellAction();
        this.selectPreviousColumnCellAction = new SelectPreviousColumnCellAction();
        this.getActionMap().put("selectNextColumnCell", this.selectNextColumnCellAction);
        this.getActionMap().put("selectPreviousColumnCell", this.selectPreviousColumnCellAction);
    }

    protected Dimension getPreferredFullWidthSize() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof JViewport); container = container.getParent()) {
        }
        if (container != null) {
            Dimension dimension = super.getPreferredSize();
            dimension.width = container.getSize().width;
            return dimension;
        }
        return super.getPreferredSize();
    }

    protected class SelectPreviousColumnCellAction
    extends AbstractAction {
        protected SelectPreviousColumnCellAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = JosmTable.this.getSelectedColumn();
            int n2 = JosmTable.this.getSelectedRow();
            if (JosmTable.this.getCellEditor() != null) {
                JosmTable.this.getCellEditor().stopCellEditing();
            }
            if ((n > 0 || n2 > 0) && n2 > 0) {
                n = JosmTable.this.colEnd;
                --n2;
            }
            JosmTable.this.changeSelection(n2, n, false, false);
            if (JosmTable.this.editCellAt(JosmTable.this.getSelectedRow(), JosmTable.this.getSelectedColumn())) {
                JosmTable.this.getEditorComponent().requestFocusInWindow();
            }
        }
    }

    protected class SelectNextColumnCellAction
    extends AbstractAction {
        protected SelectNextColumnCellAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = JosmTable.this.getSelectedColumn();
            int n2 = JosmTable.this.getSelectedRow();
            if (JosmTable.this.getCellEditor() != null) {
                JosmTable.this.getCellEditor().stopCellEditing();
            }
            if (n == JosmTable.this.colEnd && n2 < JosmTable.this.getRowCount() - 1) {
                ++n2;
            } else if (n2 < JosmTable.this.getRowCount() - 1) {
                n = JosmTable.this.colEnd;
                ++n2;
            } else {
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                keyboardFocusManager.focusNextComponent();
                return;
            }
            JosmTable.this.changeSelection(n2, n, false, false);
            if (JosmTable.this.editCellAt(JosmTable.this.getSelectedRow(), JosmTable.this.getSelectedColumn())) {
                JosmTable.this.getEditorComponent().requestFocusInWindow();
            }
        }
    }
}

