/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.imagery;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.Shape;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ImageryReader
implements Closeable {
    private final String source;
    private CachedFile cachedFile;
    private boolean fastFail;

    public ImageryReader(String string) {
        this.source = string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ImageryInfo> parse() throws SAXException, IOException {
        Parser parser = new Parser();
        try {
            this.cachedFile = new CachedFile(this.source);
            this.cachedFile.setFastFail(this.fastFail);
            try (BufferedReader bufferedReader = this.cachedFile.setMaxAge(CachedFile.DAYS).setCachingStrategy(CachedFile.CachingStrategy.IfModifiedSince).getContentReader();){
                InputSource inputSource = new InputSource(bufferedReader);
                Utils.parseSafeSAX(inputSource, parser);
                List list = parser.entries;
                return list;
            }
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Main.error(parserConfigurationException);
            throw new SAXException(parserConfigurationException);
        }
    }

    public void setFastFail(boolean bl) {
        this.fastFail = bl;
    }

    @Override
    public void close() throws IOException {
        Utils.close(this.cachedFile);
    }

    private static class Parser
    extends DefaultHandler {
        private StringBuilder accumulator = new StringBuilder();
        private Stack<State> states;
        private List<ImageryInfo> entries;
        private boolean skipEntry;
        private ImageryInfo entry;
        private ImageryInfo mirrorEntry;
        private ImageryInfo.ImageryBounds bounds;
        private Shape shape;
        private String lang;
        private List<String> projections;
        private MultiMap<String, String> noTileHeaders;
        private MultiMap<String, String> noTileChecksums;
        private Map<String, String> metadataHeaders;

        private Parser() {
        }

        @Override
        public void startDocument() {
            this.accumulator = new StringBuilder();
            this.skipEntry = false;
            this.states = new Stack();
            this.states.push(State.INIT);
            this.entries = new ArrayList<ImageryInfo>();
            this.entry = null;
            this.bounds = null;
            this.projections = null;
            this.noTileHeaders = null;
            this.noTileChecksums = null;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.accumulator.setLength(0);
            State state = null;
            switch (this.states.peek()) {
                case INIT: {
                    if (!"imagery".equals(string3)) break;
                    state = State.IMAGERY;
                    break;
                }
                case IMAGERY: {
                    if (!"entry".equals(string3)) break;
                    this.entry = new ImageryInfo();
                    this.skipEntry = false;
                    state = State.ENTRY;
                    this.noTileHeaders = new MultiMap();
                    this.noTileChecksums = new MultiMap();
                    this.metadataHeaders = new HashMap<String, String>();
                    break;
                }
                case MIRROR: {
                    if (Arrays.asList("type", "url", "min-zoom", "max-zoom", "tile-size").contains(string3)) {
                        state = State.MIRROR_ATTRIBUTE;
                        this.lang = attributes.getValue("lang");
                        break;
                    }
                    if (!"projections".equals(string3)) break;
                    this.projections = new ArrayList<String>();
                    state = State.MIRROR_PROJECTIONS;
                    break;
                }
                case ENTRY: {
                    if (Arrays.asList("name", "id", "type", "description", "default", "url", "eula", "min-zoom", "max-zoom", "attribution-text", "attribution-url", "logo-image", "logo-url", "terms-of-use-text", "terms-of-use-url", "country-code", "icon", "tile-size", "valid-georeference", "epsg4326to3857Supported").contains(string3)) {
                        state = State.ENTRY_ATTRIBUTE;
                        this.lang = attributes.getValue("lang");
                        break;
                    }
                    if ("bounds".equals(string3)) {
                        try {
                            this.bounds = new ImageryInfo.ImageryBounds(attributes.getValue("min-lat") + ',' + attributes.getValue("min-lon") + ',' + attributes.getValue("max-lat") + ',' + attributes.getValue("max-lon"), ",");
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            Main.trace(illegalArgumentException);
                            break;
                        }
                        state = State.BOUNDS;
                        break;
                    }
                    if ("projections".equals(string3)) {
                        this.projections = new ArrayList<String>();
                        state = State.PROJECTIONS;
                        break;
                    }
                    if ("mirror".equals(string3)) {
                        this.projections = new ArrayList<String>();
                        state = State.MIRROR;
                        this.mirrorEntry = new ImageryInfo();
                        break;
                    }
                    if ("no-tile-header".equals(string3)) {
                        this.noTileHeaders.put(attributes.getValue("name"), attributes.getValue("value"));
                        state = State.NO_TILE;
                        break;
                    }
                    if ("no-tile-checksum".equals(string3)) {
                        this.noTileChecksums.put(attributes.getValue("type"), attributes.getValue("value"));
                        state = State.NO_TILESUM;
                        break;
                    }
                    if (!"metadata-header".equals(string3)) break;
                    this.metadataHeaders.put(attributes.getValue("header-name"), attributes.getValue("metadata-key"));
                    state = State.METADATA;
                    break;
                }
                case BOUNDS: {
                    if (!"shape".equals(string3)) break;
                    this.shape = new Shape();
                    state = State.SHAPE;
                    break;
                }
                case SHAPE: {
                    if (!"point".equals(string3)) break;
                    try {
                        this.shape.addPoint(attributes.getValue("lat"), attributes.getValue("lon"));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Main.trace(illegalArgumentException);
                    }
                    break;
                }
                case PROJECTIONS: 
                case MIRROR_PROJECTIONS: {
                    if (!"code".equals(string3)) break;
                    state = State.CODE;
                    break;
                }
            }
            if (state == null) {
                state = State.UNKNOWN;
            }
            this.states.push(state);
            if (state == State.UNKNOWN && "true".equals(attributes.getValue("mandatory"))) {
                this.skipEntry = true;
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            this.accumulator.append(cArray, n, n2);
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            switch (this.states.pop()) {
                case INIT: {
                    throw new JosmRuntimeException("parsing error: more closing than opening elements");
                }
                case ENTRY: {
                    if (!"entry".equals(string2)) break;
                    this.entry.setNoTileHeaders(this.noTileHeaders);
                    this.noTileHeaders = null;
                    this.entry.setNoTileChecksums(this.noTileChecksums);
                    this.noTileChecksums = null;
                    this.entry.setMetadataHeaders(this.metadataHeaders);
                    this.metadataHeaders = null;
                    if (!this.skipEntry) {
                        this.entries.add(this.entry);
                    }
                    this.entry = null;
                    break;
                }
                case MIRROR: {
                    if (this.mirrorEntry == null || !"mirror".equals(string2)) break;
                    this.entry.addMirror(this.mirrorEntry);
                    this.mirrorEntry = null;
                    break;
                }
                case MIRROR_ATTRIBUTE: {
                    if (this.mirrorEntry == null) break;
                    switch (string2) {
                        case "type": {
                            boolean bl = false;
                            for (ImageryInfo.ImageryType imageryType : ImageryInfo.ImageryType.values()) {
                                if (!Objects.equals(this.accumulator.toString(), imageryType.getTypeString())) continue;
                                this.mirrorEntry.setImageryType(imageryType);
                                bl = true;
                                break;
                            }
                            if (bl) break;
                            this.mirrorEntry = null;
                            break;
                        }
                        case "url": {
                            this.mirrorEntry.setUrl(this.accumulator.toString());
                            break;
                        }
                        case "min-zoom": 
                        case "max-zoom": {
                            Integer n = null;
                            try {
                                n = Integer.valueOf(this.accumulator.toString());
                            }
                            catch (NumberFormatException numberFormatException) {
                                n = null;
                            }
                            if (n == null) {
                                this.mirrorEntry = null;
                                break;
                            }
                            if ("min-zoom".equals(string2)) {
                                this.mirrorEntry.setDefaultMinZoom(n);
                                break;
                            }
                            this.mirrorEntry.setDefaultMaxZoom(n);
                            break;
                        }
                        case "tile-size": {
                            Integer n = null;
                            try {
                                n = Integer.valueOf(this.accumulator.toString());
                            }
                            catch (NumberFormatException numberFormatException) {
                                n = null;
                            }
                            if (n == null) {
                                this.mirrorEntry = null;
                                break;
                            }
                            this.entry.setTileSize(n);
                            break;
                        }
                    }
                    break;
                }
                case ENTRY_ATTRIBUTE: {
                    block51 : switch (string2) {
                        case "name": {
                            this.entry.setName(this.lang == null ? LanguageInfo.getJOSMLocaleCode(null) : this.lang, this.accumulator.toString());
                            break;
                        }
                        case "description": {
                            this.entry.setDescription(this.lang, this.accumulator.toString());
                            break;
                        }
                        case "id": {
                            this.entry.setId(this.accumulator.toString());
                            break;
                        }
                        case "type": {
                            boolean bl = false;
                            for (ImageryInfo.ImageryType imageryType : ImageryInfo.ImageryType.values()) {
                                if (!Objects.equals(this.accumulator.toString(), imageryType.getTypeString())) continue;
                                this.entry.setImageryType(imageryType);
                                bl = true;
                                break;
                            }
                            if (bl) break;
                            this.skipEntry = true;
                            break;
                        }
                        case "default": {
                            switch (this.accumulator.toString()) {
                                case "true": {
                                    this.entry.setDefaultEntry(true);
                                    break block51;
                                }
                                case "false": {
                                    this.entry.setDefaultEntry(false);
                                    break block51;
                                }
                            }
                            this.skipEntry = true;
                            break;
                        }
                        case "url": {
                            this.entry.setUrl(this.accumulator.toString());
                            break;
                        }
                        case "eula": {
                            this.entry.setEulaAcceptanceRequired(this.accumulator.toString());
                            break;
                        }
                        case "min-zoom": 
                        case "max-zoom": {
                            Integer n = null;
                            try {
                                n = Integer.valueOf(this.accumulator.toString());
                            }
                            catch (NumberFormatException numberFormatException) {
                                n = null;
                            }
                            if (n == null) {
                                this.skipEntry = true;
                                break;
                            }
                            if ("min-zoom".equals(string2)) {
                                this.entry.setDefaultMinZoom(n);
                                break;
                            }
                            this.entry.setDefaultMaxZoom(n);
                            break;
                        }
                        case "attribution-text": {
                            this.entry.setAttributionText(this.accumulator.toString());
                            break;
                        }
                        case "attribution-url": {
                            this.entry.setAttributionLinkURL(this.accumulator.toString());
                            break;
                        }
                        case "logo-image": {
                            this.entry.setAttributionImage(this.accumulator.toString());
                            break;
                        }
                        case "logo-url": {
                            this.entry.setAttributionImageURL(this.accumulator.toString());
                            break;
                        }
                        case "terms-of-use-text": {
                            this.entry.setTermsOfUseText(this.accumulator.toString());
                            break;
                        }
                        case "terms-of-use-url": {
                            this.entry.setTermsOfUseURL(this.accumulator.toString());
                            break;
                        }
                        case "country-code": {
                            this.entry.setCountryCode(this.accumulator.toString());
                            break;
                        }
                        case "icon": {
                            this.entry.setIcon(this.accumulator.toString());
                            break;
                        }
                        case "tile-size": {
                            Integer n = null;
                            try {
                                n = Integer.valueOf(this.accumulator.toString());
                            }
                            catch (NumberFormatException numberFormatException) {
                                n = null;
                            }
                            if (n == null) {
                                this.skipEntry = true;
                                break;
                            }
                            this.entry.setTileSize(n);
                            break;
                        }
                        case "valid-georeference": {
                            this.entry.setGeoreferenceValid(Boolean.parseBoolean(this.accumulator.toString()));
                            break;
                        }
                        case "epsg4326to3857Supported": {
                            this.entry.setEpsg4326To3857Supported(Boolean.parseBoolean(this.accumulator.toString()));
                            break;
                        }
                    }
                    break;
                }
                case BOUNDS: {
                    this.entry.setBounds(this.bounds);
                    this.bounds = null;
                    break;
                }
                case SHAPE: {
                    this.bounds.addShape(this.shape);
                    this.shape = null;
                    break;
                }
                case CODE: {
                    this.projections.add(this.accumulator.toString());
                    break;
                }
                case PROJECTIONS: {
                    this.entry.setServerProjections(this.projections);
                    this.projections = null;
                    break;
                }
                case MIRROR_PROJECTIONS: {
                    this.mirrorEntry.setServerProjections(this.projections);
                    this.projections = null;
                    break;
                }
            }
        }
    }

    private static enum State {
        INIT,
        IMAGERY,
        ENTRY,
        ENTRY_ATTRIBUTE,
        PROJECTIONS,
        MIRROR,
        MIRROR_ATTRIBUTE,
        MIRROR_PROJECTIONS,
        CODE,
        BOUNDS,
        SHAPE,
        NO_TILE,
        NO_TILESUM,
        METADATA,
        UNKNOWN;

    }
}

