/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;

public final class AlphanumComparator
implements Comparator<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final AlphanumComparator INSTANCE = new AlphanumComparator();

    public static AlphanumComparator getInstance() {
        return INSTANCE;
    }

    private AlphanumComparator() {
    }

    private static String getChunk(String string, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        char c = string.charAt(n2);
        stringBuilder.append(c);
        ++n2;
        if (Character.isDigit(c)) {
            while (n2 < n && Character.isDigit(c = string.charAt(n2))) {
                stringBuilder.append(c);
                ++n2;
            }
        } else {
            while (n2 < n && !Character.isDigit(c = string.charAt(n2))) {
                stringBuilder.append(c);
                ++n2;
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public int compare(String string, String string2) {
        if (string == null && string2 == null) {
            return 0;
        }
        if (string == null) {
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        int n4 = string2.length();
        while (n < n3 && n2 < n4) {
            int n5;
            String string3 = AlphanumComparator.getChunk(string, n3, n);
            n += string3.length();
            String string4 = AlphanumComparator.getChunk(string2, n4, n2);
            n2 += string4.length();
            if (Character.isDigit(string3.charAt(0)) && Character.isDigit(string4.charAt(0))) {
                int n6 = string3.length();
                n5 = n6 - string4.length();
                if (n5 == 0) {
                    for (int i = 0; i < n6; ++i) {
                        n5 = string3.charAt(i) - string4.charAt(i);
                        if (n5 == 0) continue;
                        return n5;
                    }
                }
            } else {
                Collator collator = Collator.getInstance(Locale.getDefault());
                collator.setStrength(1);
                n5 = collator.compare(string3, string4);
            }
            if (n5 == 0) continue;
            return n5;
        }
        return n3 - n4;
    }
}

