/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.ForeignAccessArguments;
import com.oracle.truffle.api.interop.ObjectAccessNode;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;

final class CachedObjectAccessNode
extends ObjectAccessNode {
    @Node.Child
    private DirectCallNode callTarget;
    @Node.Child
    private ObjectAccessNode next;
    @Node.Child
    private DirectCallNode languageCheckAsNode;
    private final ForeignAccess languageCheck;
    @Node.Child
    private ForeignAccessArguments accessArguments = new ForeignAccessArguments();

    protected CachedObjectAccessNode(DirectCallNode callTarget, ObjectAccessNode next, ForeignAccess languageCheck, DirectCallNode languageCheckAsNode) {
        this.callTarget = callTarget;
        this.next = next;
        this.languageCheck = languageCheck;
        this.languageCheckAsNode = languageCheckAsNode;
        if (this.languageCheckAsNode != null) {
            this.languageCheckAsNode.forceInlining();
        }
        this.callTarget.forceInlining();
    }

    @Override
    public Object executeWith(VirtualFrame frame, TruffleObject receiver, Object[] arguments) {
        return this.doAccess(frame, receiver, arguments);
    }

    private Object doAccess(VirtualFrame frame, TruffleObject receiver, Object[] arguments) {
        if (this.accept(frame, receiver)) {
            return this.callTarget.call(frame, this.accessArguments.executeCreate(receiver, arguments));
        }
        return this.doNext(frame, receiver, arguments);
    }

    private boolean accept(VirtualFrame frame, TruffleObject receiver) {
        if (this.languageCheckAsNode != null && ((Boolean)this.languageCheckAsNode.call(frame, new Object[]{receiver})).booleanValue()) {
            return true;
        }
        return this.languageCheckAsNode == null && this.languageCheck.canHandle(receiver);
    }

    private Object doNext(VirtualFrame frame, TruffleObject receiver, Object[] arguments) {
        return this.next.executeWith(frame, receiver, arguments);
    }
}

