/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.language.RubyNode;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class)})
public abstract class ArrayGetTailNode
extends RubyNode {
    final int index;

    public ArrayGetTailNode(int index) {
        this.index = index;
    }

    @Specialization(guards={"strategy.matches(array)"}, limit="ARRAY_STRATEGIES")
    public DynamicObject getTail(DynamicObject array, @Cached(value="of(array)") ArrayStrategy strategy, @Cached(value="createBinaryProfile()") ConditionProfile indexLargerThanSize) {
        int size = strategy.getSize(array);
        if (indexLargerThanSize.profile(this.index >= size)) {
            return this.createArray(null, 0);
        }
        Object newStore = strategy.newMirror(array).extractRange(this.index, size).getArray();
        return this.createArray(newStore, size - this.index);
    }
}

