/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.read.bytes;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.read.SourceNode;
import org.jruby.truffle.core.rope.AsciiOnlyLeafRope;

@NodeChildren(value={@NodeChild(value="source", type=SourceNode.class)})
public abstract class ReadUUStringNode
extends FormatNode {
    @Specialization
    protected Object encode(VirtualFrame frame, byte[] source) {
        int position = this.getSourcePosition(frame);
        ByteBuffer encode = ByteBuffer.wrap(source, position, this.getSourceLength(frame) - position);
        int length = encode.remaining() * 3 / 4;
        byte[] lElem = new byte[length];
        int index = 0;
        int s = 0;
        int total = 0;
        if (length > 0) {
            s = encode.get();
        }
        while (encode.hasRemaining() && s > 32 && s < 97) {
            byte[] hunk = new byte[3];
            int len = s - 32 & 0x3F;
            s = ReadUUStringNode.safeGet(encode);
            if ((total += len) > length) {
                len -= total - length;
                total = length;
            }
            while (len > 0) {
                int d;
                int c;
                int b;
                int a;
                int mlen;
                int n = mlen = len > 3 ? 3 : len;
                if (encode.hasRemaining() && s >= 32) {
                    a = s - 32 & 0x3F;
                    s = ReadUUStringNode.safeGet(encode);
                } else {
                    a = 0;
                }
                if (encode.hasRemaining() && s >= 32) {
                    b = s - 32 & 0x3F;
                    s = ReadUUStringNode.safeGet(encode);
                } else {
                    b = 0;
                }
                if (encode.hasRemaining() && s >= 32) {
                    c = s - 32 & 0x3F;
                    s = ReadUUStringNode.safeGet(encode);
                } else {
                    c = 0;
                }
                if (encode.hasRemaining() && s >= 32) {
                    d = s - 32 & 0x3F;
                    s = ReadUUStringNode.safeGet(encode);
                } else {
                    d = 0;
                }
                hunk[0] = (byte)((a << 2 | b >> 4) & 0xFF);
                hunk[1] = (byte)((b << 4 | c >> 2) & 0xFF);
                hunk[2] = (byte)((c << 6 | d) & 0xFF);
                for (int i = 0; i < mlen; ++i) {
                    lElem[index++] = hunk[i];
                }
                len -= mlen;
            }
            if (s == 13) {
                s = ReadUUStringNode.safeGet(encode);
                continue;
            }
            if (s == 10) {
                s = ReadUUStringNode.safeGet(encode);
                continue;
            }
            if (!encode.hasRemaining()) continue;
            if (ReadUUStringNode.safeGet(encode) == 10) {
                ReadUUStringNode.safeGet(encode);
                continue;
            }
            if (!encode.hasRemaining()) continue;
            encode.position(encode.position() - 1);
        }
        this.setSourcePosition(frame, encode.position());
        return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), new AsciiOnlyLeafRope(Arrays.copyOfRange(lElem, 0, index), USASCIIEncoding.INSTANCE));
    }
}

