/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.options;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.jruby.truffle.Log;
import org.jruby.truffle.options.OptionDescription;
import org.jruby.truffle.options.Options;
import org.jruby.truffle.options.OptionsCatalog;
import org.jruby.truffle.options.UnknownOptionException;

public class OptionsBuilder {
    private static final String LEGACY_PREFIX = "jruby.truffle.";
    private final Map<OptionDescription, Object> options = new HashMap<OptionDescription, Object>();

    public void set(Properties properties) {
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            String name = (String)property.getKey();
            if (!name.startsWith(LEGACY_PREFIX)) continue;
            this.set(name.substring(LEGACY_PREFIX.length()), property.getValue());
        }
    }

    public void set(Map<String, Object> properties) {
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            this.set(property.getKey(), property.getValue());
        }
    }

    private void set(String name, Object value) {
        OptionDescription description = OptionsCatalog.fromName(name);
        if (description == null) {
            throw new UnknownOptionException(name);
        }
        this.options.put(description, description.checkValue(value));
    }

    public Options build() {
        Options options = new Options(this);
        if (options.OPTIONS_LOG && Log.LOGGER.isLoggable(Level.CONFIG)) {
            for (OptionDescription option : OptionsCatalog.allDescriptions()) {
                Log.LOGGER.config("option " + option.getName() + "=" + option.toString(options.fromDescription(option)));
            }
        }
        return options;
    }

    <T> T getOrDefault(OptionDescription description) {
        Object value = this.options.get(description);
        if (value == null) {
            return (T)description.getDefaultValue();
        }
        return (T)value;
    }

    <T> T getOrDefault(OptionDescription description, T defaultValue) {
        Object value = this.options.get(description);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    public static <T> T readSystemProperty(OptionDescription description) {
        String value = System.getProperty(LEGACY_PREFIX + description.getName());
        if (value == null) {
            return (T)description.getDefaultValue();
        }
        return (T)description.checkValue(value);
    }
}

