/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib.bigdecimal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.math.BigDecimal;
import java.math.MathContext;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.stdlib.bigdecimal.BigDecimalOpNode;
import org.jruby.truffle.stdlib.bigdecimal.BigDecimalType;

public abstract class AbstractAddNode
extends BigDecimalOpNode {
    private final ConditionProfile nanProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile posInfinityProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile negInfinityProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile aNormalProfile = ConditionProfile.createBinaryProfile();

    protected Object add(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
        return this.createBigDecimal(frame, this.addBigDecimal(a, b, new MathContext(precision, this.getRoundMode(frame))));
    }

    protected Object addSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
        BigDecimalType aType = Layouts.BIG_DECIMAL.getType(a);
        BigDecimalType bType = Layouts.BIG_DECIMAL.getType(b);
        if (this.nanProfile.profile(aType == BigDecimalType.NAN || bType == BigDecimalType.NAN || aType == BigDecimalType.POSITIVE_INFINITY && bType == BigDecimalType.NEGATIVE_INFINITY || aType == BigDecimalType.NEGATIVE_INFINITY && bType == BigDecimalType.POSITIVE_INFINITY)) {
            return this.createBigDecimal(frame, (Object)BigDecimalType.NAN);
        }
        if (this.posInfinityProfile.profile(aType == BigDecimalType.POSITIVE_INFINITY || bType == BigDecimalType.POSITIVE_INFINITY)) {
            return this.createBigDecimal(frame, (Object)BigDecimalType.POSITIVE_INFINITY);
        }
        if (this.negInfinityProfile.profile(aType == BigDecimalType.NEGATIVE_INFINITY || bType == BigDecimalType.NEGATIVE_INFINITY)) {
            return this.createBigDecimal(frame, (Object)BigDecimalType.NEGATIVE_INFINITY);
        }
        if (this.aNormalProfile.profile(AbstractAddNode.isNormal(a))) {
            return a;
        }
        return b;
    }

    @CompilerDirectives.TruffleBoundary
    private BigDecimal addBigDecimal(DynamicObject a, DynamicObject b, MathContext mathContext) {
        return Layouts.BIG_DECIMAL.getValue(a).add(Layouts.BIG_DECIMAL.getValue(b), mathContext);
    }
}

