/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.DoubleStream;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.DrawAction;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.draw.MapViewPath;
import org.openstreetmap.josm.gui.draw.SymbolShape;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.I18n;

class DrawSnapHelper {
    private final DrawAction drawAction;
    private static final String DRAW_ANGLESNAP_ANGLES = "draw.anglesnap.angles";
    private boolean snapOn;
    private boolean active;
    private boolean fixed;
    private boolean absoluteFix;
    EastNorth dir2;
    private EastNorth projected;
    private String labelText;
    private double lastAngle;
    private double customBaseHeading = -1.0;
    private EastNorth segmentPoint1;
    private EastNorth segmentPoint2;
    private EastNorth projectionSource;
    private double[] snapAngles;
    private double pe;
    private double pn;
    private double e0;
    private double n0;
    private final String fixFmt = "%d " + I18n.tr("FIX", new Object[0]);
    private JCheckBoxMenuItem checkBox;
    final MouseListener anglePopupListener;

    DrawSnapHelper(final DrawAction drawAction) {
        this.drawAction = drawAction;
        this.anglePopupListener = new PopupMenuLauncher(new AnglePopupMenu(this)){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
                if (mouseEvent.getButton() == 1) {
                    DrawSnapHelper.this.toggleSnapping();
                    drawAction.updateStatusLine();
                }
            }
        };
    }

    public void init() {
        this.snapOn = false;
        this.checkBox.setState(this.snapOn);
        this.fixed = false;
        this.absoluteFix = false;
        this.computeSnapAngles();
        Main.pref.addWeakKeyPreferenceChangeListener(DRAW_ANGLESNAP_ANGLES, preferenceChangeEvent -> this.computeSnapAngles());
    }

    private void computeSnapAngles() {
        this.snapAngles = Main.pref.getCollection(DRAW_ANGLESNAP_ANGLES, Arrays.asList("0", "30", "45", "60", "90", "120", "135", "150", "180")).stream().mapToDouble(DrawSnapHelper::parseSnapAngle).flatMap(d -> DoubleStream.of(d, 360.0 - d)).toArray();
    }

    private static double parseSnapAngle(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            Main.warn("Incorrect number in draw.anglesnap.angles preferences: {0}", string);
            return 0.0;
        }
    }

    public void saveAngles(String ... stringArray) {
        Main.pref.putCollection(DRAW_ANGLESNAP_ANGLES, Arrays.asList(stringArray));
    }

    public void setMenuCheckBox(JCheckBoxMenuItem jCheckBoxMenuItem) {
        this.checkBox = jCheckBoxMenuItem;
    }

    public void drawIfNeeded(Graphics2D graphics2D, MapViewState mapViewState) {
        MapViewPath mapViewPath;
        if (!this.snapOn || !this.active) {
            return;
        }
        MapViewState.MapViewPoint mapViewPoint = mapViewState.getPointFor(this.drawAction.getCurrentBaseNode());
        MapViewState.MapViewPoint mapViewPoint2 = mapViewState.getPointFor(this.dir2);
        MapViewState.MapViewPoint mapViewPoint3 = mapViewState.getPointFor(this.projected);
        if (DrawAction.DRAW_CONSTRUCTION_GEOMETRY.get().booleanValue()) {
            graphics2D.setColor(DrawAction.SNAP_HELPER_COLOR.get());
            graphics2D.setStroke(DrawAction.HELPER_STROKE.get());
            mapViewPath = new MapViewPath(mapViewState);
            mapViewPath.moveTo(mapViewPoint2);
            if (this.absoluteFix) {
                mapViewPath.lineTo(mapViewPoint2.interpolate(mapViewPoint, 2.0));
            } else {
                mapViewPath.lineTo(mapViewPoint3);
            }
            graphics2D.draw(mapViewPath);
        }
        if (this.projectionSource != null) {
            graphics2D.setColor(DrawAction.SNAP_HELPER_COLOR.get());
            graphics2D.setStroke(DrawAction.HELPER_STROKE.get());
            mapViewPath = new MapViewPath(mapViewState);
            mapViewPath.moveTo(mapViewPoint3);
            mapViewPath.lineTo(this.projectionSource);
            graphics2D.draw(mapViewPath);
        }
        if (this.customBaseHeading >= 0.0) {
            graphics2D.setColor(DrawAction.HIGHLIGHT_COLOR.get());
            graphics2D.setStroke(DrawAction.HIGHLIGHT_STROKE.get());
            mapViewPath = new MapViewPath(mapViewState);
            mapViewPath.moveTo(this.segmentPoint1);
            mapViewPath.lineTo(this.segmentPoint2);
            graphics2D.draw(mapViewPath);
        }
        graphics2D.setColor(DrawAction.RUBBER_LINE_COLOR.get());
        graphics2D.setStroke(DrawAction.RUBBER_LINE_STROKE.get());
        mapViewPath = new MapViewPath(mapViewState);
        mapViewPath.moveTo(mapViewPoint);
        mapViewPath.lineTo(mapViewPoint3);
        graphics2D.draw(mapViewPath);
        graphics2D.drawString(this.labelText, (int)mapViewPoint3.getInViewX() - 5, (int)mapViewPoint3.getInViewY() + 20);
        if (DrawAction.SHOW_PROJECTED_POINT.get().booleanValue()) {
            graphics2D.setStroke(DrawAction.RUBBER_LINE_STROKE.get());
            graphics2D.draw(new MapViewPath(mapViewState).shapeAround(mapViewPoint3, SymbolShape.CIRCLE, 10.0));
        }
        graphics2D.setColor(DrawAction.SNAP_HELPER_COLOR.get());
        graphics2D.setStroke(DrawAction.HELPER_STROKE.get());
    }

    public void checkAngleSnapping(EastNorth eastNorth, double d, double d2) {
        double d3;
        EastNorth eastNorth2 = this.drawAction.getCurrentBaseNode().getEastNorth();
        EastNorth eastNorth3 = eastNorth;
        double d4 = -1.0;
        double d5 = d3 = this.customBaseHeading >= 0.0 ? this.customBaseHeading : d;
        if (this.snapOn && d3 >= 0.0) {
            double d6;
            d4 = d2 - d3;
            if (d4 < 0.0) {
                d4 += 360.0;
            }
            if (d4 > 360.0) {
                d4 = 0.0;
            }
            if (this.fixed) {
                d6 = this.lastAngle;
                this.active = true;
            } else {
                d6 = this.getNearestAngle(d4);
                if (DrawSnapHelper.getAngleDelta(d6, d4) < DrawAction.SNAP_ANGLE_TOLERANCE.get()) {
                    this.active = this.customBaseHeading >= 0.0 || Math.abs(d6 - 180.0) > 0.001;
                    this.lastAngle = d6;
                } else {
                    this.active = false;
                }
            }
            if (this.active) {
                this.e0 = eastNorth2.east();
                this.n0 = eastNorth2.north();
                this.buildLabelText(d6 <= 180.0 ? d6 : d6 - 360.0);
                double d7 = (d6 + d3) * Math.PI / 180.0;
                this.pe = Math.sin(d7);
                this.pn = Math.cos(d7);
                double d8 = 20.0 * Main.map.mapView.getDist100Pixel();
                this.dir2 = new EastNorth(this.e0 + d8 * this.pe, this.n0 + d8 * this.pn);
                eastNorth3 = this.getSnapPoint(eastNorth);
            } else {
                this.noSnapNow();
            }
        }
        LatLon latLon = Main.map.mapView.getProjection().eastNorth2latlon(eastNorth3);
        double d9 = this.drawAction.getCurrentBaseNode().getCoor().greatCircleDistance(latLon);
        double d10 = Math.toDegrees(eastNorth2.heading(eastNorth3));
        if (d >= 0.0) {
            d4 = d10 - d;
            if (d4 < 0.0) {
                d4 += 360.0;
            }
            if (d4 > 360.0) {
                d4 = 0.0;
            }
        }
        DrawAction.showStatusInfo(d4, d10, d9, this.isSnapOn());
    }

    private void buildLabelText(double d) {
        this.labelText = DrawAction.SHOW_ANGLE.get().booleanValue() ? (this.fixed ? (this.absoluteFix ? "=" : String.format(this.fixFmt, (int)d)) : String.format("%d", (int)d)) : (this.fixed ? (this.absoluteFix ? "=" : String.format(I18n.tr("FIX", new Object[0]), 0)) : "");
    }

    public EastNorth getSnapPoint(EastNorth eastNorth) {
        DataSet dataSet;
        Collection<Way> collection;
        if (!this.active) {
            return eastNorth;
        }
        double d = eastNorth.east() - this.e0;
        double d2 = eastNorth.north() - this.n0;
        double d3 = d * this.pe + d2 * this.pn;
        double d4 = Main.map.mapView.getDist100Pixel() / 20.0;
        if (!this.absoluteFix && d3 < d4) {
            this.active = false;
            return eastNorth;
        }
        this.projectionSource = null;
        if (DrawAction.SNAP_TO_PROJECTIONS.get().booleanValue() && (collection = (dataSet = this.drawAction.getLayerManager().getEditDataSet()).getSelectedWays()).size() == 1) {
            Way way = collection.iterator().next();
            ArrayList<EastNorth> arrayList = new ArrayList<EastNorth>();
            if (way.getNodesCount() < 1000) {
                for (Node node : way.getNodes()) {
                    arrayList.add(node.getEastNorth());
                }
            }
            if (this.customBaseHeading >= 0.0) {
                arrayList.add(this.segmentPoint1);
                arrayList.add(this.segmentPoint2);
            }
            Object object = null;
            double d5 = 100000.0;
            for (EastNorth eastNorth2 : arrayList) {
                double d6 = (eastNorth2.east() - this.e0) * this.pe + (eastNorth2.north() - this.n0) * this.pn;
                double d7 = Math.abs(d6 - d3);
                if (!(d7 < d4) || !(d7 < d5)) continue;
                d3 = d6;
                object = eastNorth2;
                d5 = d7;
            }
            if (object != null) {
                this.projectionSource = object;
            }
        }
        this.projected = new EastNorth(this.e0 + d3 * this.pe, this.n0 + d3 * this.pn);
        return this.projected;
    }

    void noSnapNow() {
        this.active = false;
        this.dir2 = null;
        this.projected = null;
        this.labelText = null;
    }

    void setBaseSegment(WaySegment waySegment) {
        if (waySegment == null) {
            return;
        }
        this.segmentPoint1 = waySegment.getFirstNode().getEastNorth();
        this.segmentPoint2 = waySegment.getSecondNode().getEastNorth();
        double d = this.segmentPoint1.heading(this.segmentPoint2);
        if ((d = Math.toDegrees(d)) < 0.0) {
            d += 360.0;
        }
        if (d > 360.0) {
            d -= 360.0;
        }
        this.customBaseHeading = d;
    }

    void enableSnapping() {
        this.snapOn = true;
        this.checkBox.setState(this.snapOn);
        this.customBaseHeading = -1.0;
        this.unsetFixedMode();
    }

    void toggleSnapping() {
        this.snapOn = !this.snapOn;
        this.checkBox.setState(this.snapOn);
        this.customBaseHeading = -1.0;
        this.unsetFixedMode();
    }

    void setFixedMode() {
        if (this.active) {
            this.fixed = true;
        }
    }

    void unsetFixedMode() {
        this.fixed = false;
        this.absoluteFix = false;
        this.lastAngle = 0.0;
        this.active = false;
    }

    boolean isActive() {
        return this.active;
    }

    boolean isSnapOn() {
        return this.snapOn;
    }

    private double getNearestAngle(double d) {
        double d3 = DoubleStream.of(this.snapAngles).boxed().min(Comparator.comparing(d2 -> DrawSnapHelper.getAngleDelta(d, d2))).orElse(0.0);
        if (Math.abs(d3 - 360.0) < 0.001) {
            d3 = 0.0;
        }
        return d3;
    }

    private static double getAngleDelta(double d, double d2) {
        double d3 = Math.abs(d - d2);
        if (d3 > 180.0) {
            return 360.0 - d3;
        }
        return d3;
    }

    void unFixOrTurnOff() {
        if (this.absoluteFix) {
            this.unsetFixedMode();
        } else {
            this.toggleSnapping();
        }
    }

    private static final class AnglePopupMenu
    extends JPopupMenu {
        private final JCheckBoxMenuItem repeatedCb;
        private final JCheckBoxMenuItem helperCb;
        private final JCheckBoxMenuItem projectionCb;

        private AnglePopupMenu(DrawSnapHelper drawSnapHelper) {
            this.repeatedCb = new JCheckBoxMenuItem(new RepeatedAction(drawSnapHelper));
            this.helperCb = new JCheckBoxMenuItem(new HelperAction(drawSnapHelper));
            this.projectionCb = new JCheckBoxMenuItem(new ProjectionAction(drawSnapHelper));
            this.helperCb.setState(DrawAction.DRAW_CONSTRUCTION_GEOMETRY.get());
            this.projectionCb.setState(DrawAction.SNAP_TO_PROJECTIONS.get());
            this.repeatedCb.setState(DrawAction.USE_REPEATED_SHORTCUT.get());
            this.add(this.repeatedCb);
            this.add(this.helperCb);
            this.add(this.projectionCb);
            this.add(new DisableAction(drawSnapHelper));
            this.add(new Snap90DegreesAction(drawSnapHelper));
            this.add(new Snap45DegreesAction(drawSnapHelper));
            this.add(new Snap30DegreesAction(drawSnapHelper));
        }
    }

    private static final class Snap30DegreesAction
    extends AbstractAction {
        private final transient DrawSnapHelper snapHelper;

        Snap30DegreesAction(DrawSnapHelper drawSnapHelper) {
            super(I18n.tr("0,30,45,60,90,...", new Object[0]));
            this.snapHelper = drawSnapHelper;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.snapHelper.saveAngles("0", "30", "45", "60", "90", "120", "135", "150", "180");
            this.snapHelper.init();
            this.snapHelper.enableSnapping();
        }
    }

    private static final class Snap45DegreesAction
    extends AbstractAction {
        private final transient DrawSnapHelper snapHelper;

        Snap45DegreesAction(DrawSnapHelper drawSnapHelper) {
            super(I18n.tr("0,45,90,...", new Object[0]));
            this.snapHelper = drawSnapHelper;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.snapHelper.saveAngles("0", "45", "90", "135", "180");
            this.snapHelper.init();
            this.snapHelper.enableSnapping();
        }
    }

    private static final class Snap90DegreesAction
    extends AbstractAction {
        private final transient DrawSnapHelper snapHelper;

        Snap90DegreesAction(DrawSnapHelper drawSnapHelper) {
            super(I18n.tr("0,90,...", new Object[0]));
            this.snapHelper = drawSnapHelper;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.snapHelper.saveAngles("0", "90", "180");
            this.snapHelper.init();
            this.snapHelper.enableSnapping();
        }
    }

    private static final class DisableAction
    extends AbstractAction {
        private final transient DrawSnapHelper snapHelper;

        DisableAction(DrawSnapHelper drawSnapHelper) {
            super(I18n.tr("Disable", new Object[0]));
            this.snapHelper = drawSnapHelper;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.snapHelper.saveAngles("180");
            this.snapHelper.init();
            this.snapHelper.enableSnapping();
        }
    }

    private static final class ProjectionAction
    extends AbstractAction {
        private final transient DrawSnapHelper snapHelper;

        ProjectionAction(DrawSnapHelper drawSnapHelper) {
            super(I18n.tr("Snap to node projections", new Object[0]));
            this.snapHelper = drawSnapHelper;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = ((JCheckBoxMenuItem)actionEvent.getSource()).getState();
            DrawAction.SNAP_TO_PROJECTIONS.put(bl);
            this.snapHelper.enableSnapping();
        }
    }

    private static final class HelperAction
    extends AbstractAction {
        private final transient DrawSnapHelper snapHelper;

        HelperAction(DrawSnapHelper drawSnapHelper) {
            super(I18n.tr("Show helper geometry", new Object[0]));
            this.snapHelper = drawSnapHelper;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = ((JCheckBoxMenuItem)actionEvent.getSource()).getState();
            DrawAction.DRAW_CONSTRUCTION_GEOMETRY.put(bl);
            DrawAction.SHOW_PROJECTED_POINT.put(bl);
            DrawAction.SHOW_ANGLE.put(bl);
            this.snapHelper.enableSnapping();
        }
    }

    private static final class RepeatedAction
    extends AbstractAction {
        RepeatedAction(DrawSnapHelper drawSnapHelper) {
            super(I18n.tr("Toggle snapping by {0}", drawSnapHelper.drawAction.getShortcut().getKeyText()));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = ((JCheckBoxMenuItem)actionEvent.getSource()).getState();
            DrawAction.USE_REPEATED_SHORTCUT.put(bl);
        }
    }
}

