/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.create;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public class CreateIndexRequest
extends AcknowledgedRequest<CreateIndexRequest>
implements IndicesRequest {
    private String cause = "";
    private String index;
    private Settings settings = Settings.Builder.EMPTY_SETTINGS;
    private final Map<String, String> mappings = new HashMap<String, String>();
    private final Set<Alias> aliases = new HashSet<Alias>();
    private final Map<String, IndexMetaData.Custom> customs = new HashMap<String, IndexMetaData.Custom>();
    private boolean updateAllTypes = false;
    private ActiveShardCount waitForActiveShards = ActiveShardCount.DEFAULT;

    public CreateIndexRequest() {
    }

    public CreateIndexRequest(String index) {
        this(index, Settings.Builder.EMPTY_SETTINGS);
    }

    public CreateIndexRequest(String index, Settings settings) {
        this.index = index;
        this.settings = settings;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = ValidateActions.addValidationError("index is missing", validationException);
        }
        return validationException;
    }

    @Override
    public String[] indices() {
        return new String[]{this.index};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    }

    public String index() {
        return this.index;
    }

    public CreateIndexRequest index(String index) {
        this.index = index;
        return this;
    }

    public Settings settings() {
        return this.settings;
    }

    public String cause() {
        return this.cause;
    }

    public CreateIndexRequest settings(Object ... settings) {
        this.settings = Settings.builder().put(settings).build();
        return this;
    }

    public CreateIndexRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public CreateIndexRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public CreateIndexRequest settings(String source) {
        this.settings = Settings.builder().loadFromSource(source).build();
        return this;
    }

    public CreateIndexRequest settings(XContentBuilder builder) {
        try {
            this.settings(builder.string());
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate json settings from builder", e);
        }
        return this;
    }

    public CreateIndexRequest settings(Map source) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source);
            this.settings(builder.string());
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
        return this;
    }

    public CreateIndexRequest mapping(String type, String source) {
        if (this.mappings.containsKey(type)) {
            throw new IllegalStateException("mappings for type \"" + type + "\" were already defined");
        }
        this.mappings.put(type, source);
        return this;
    }

    public CreateIndexRequest cause(String cause) {
        this.cause = cause;
        return this;
    }

    public CreateIndexRequest mapping(String type, XContentBuilder source) {
        if (this.mappings.containsKey(type)) {
            throw new IllegalStateException("mappings for type \"" + type + "\" were already defined");
        }
        try {
            this.mappings.put(type, source.string());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to build json for mapping request", e);
        }
        return this;
    }

    public CreateIndexRequest mapping(String type, Map source) {
        if (this.mappings.containsKey(type)) {
            throw new IllegalStateException("mappings for type \"" + type + "\" were already defined");
        }
        if (source.size() != 1 || !source.containsKey(type)) {
            source = MapBuilder.newMapBuilder().put(type, source).map();
        }
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source);
            return this.mapping(type, builder.string());
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public CreateIndexRequest mapping(String type, Object ... source) {
        this.mapping(type, PutMappingRequest.buildFromSimplifiedDef(type, source));
        return this;
    }

    public CreateIndexRequest aliases(Map source) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.map(source);
            return this.aliases(builder.bytes());
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public CreateIndexRequest aliases(XContentBuilder source) {
        return this.aliases(source.bytes());
    }

    public CreateIndexRequest aliases(String source) {
        return this.aliases(new BytesArray(source));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CreateIndexRequest aliases(BytesReference source) {
        try (XContentParser parser = XContentHelper.createParser(NamedXContentRegistry.EMPTY, source);){
            parser.nextToken();
            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                this.alias(Alias.fromXContent(parser));
            }
            CreateIndexRequest createIndexRequest = this;
            return createIndexRequest;
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("Failed to parse aliases", (Throwable)e, new Object[0]);
        }
    }

    public CreateIndexRequest alias(Alias alias) {
        this.aliases.add(alias);
        return this;
    }

    public CreateIndexRequest source(String source) {
        return this.source(source.getBytes(StandardCharsets.UTF_8));
    }

    public CreateIndexRequest source(XContentBuilder source) {
        return this.source(source.bytes());
    }

    public CreateIndexRequest source(byte[] source) {
        return this.source(source, 0, source.length);
    }

    public CreateIndexRequest source(byte[] source, int offset, int length) {
        return this.source(new BytesArray(source, offset, length));
    }

    public CreateIndexRequest source(BytesReference source) {
        XContentType xContentType = XContentFactory.xContentType(source);
        if (xContentType != null) {
            this.source(XContentHelper.convertToMap(source, false).v2());
        } else {
            this.settings(source.utf8ToString());
        }
        return this;
    }

    public CreateIndexRequest source(Map<String, ?> source) {
        boolean found = false;
        for (Map.Entry<String, ?> entry : source.entrySet()) {
            String name = entry.getKey();
            if (name.equals("settings")) {
                found = true;
                this.settings((Map)entry.getValue());
                continue;
            }
            if (name.equals("mappings")) {
                found = true;
                Map mappings = (Map)entry.getValue();
                for (Map.Entry entry1 : mappings.entrySet()) {
                    this.mapping((String)entry1.getKey(), (Map)entry1.getValue());
                }
                continue;
            }
            if (name.equals("aliases")) {
                found = true;
                this.aliases((Map)entry.getValue());
                continue;
            }
            Object proto = IndexMetaData.lookupPrototype(name);
            if (proto == null) continue;
            found = true;
            try {
                this.customs.put(name, proto.fromMap((Map)entry.getValue()));
            }
            catch (IOException e) {
                throw new ElasticsearchParseException("failed to parse custom metadata for [{}]", name);
            }
        }
        if (!found) {
            this.settings(source);
        }
        return this;
    }

    public Map<String, String> mappings() {
        return this.mappings;
    }

    public Set<Alias> aliases() {
        return this.aliases;
    }

    public CreateIndexRequest custom(IndexMetaData.Custom custom) {
        this.customs.put(custom.type(), custom);
        return this;
    }

    public Map<String, IndexMetaData.Custom> customs() {
        return this.customs;
    }

    public boolean updateAllTypes() {
        return this.updateAllTypes;
    }

    public CreateIndexRequest updateAllTypes(boolean updateAllTypes) {
        this.updateAllTypes = updateAllTypes;
        return this;
    }

    public ActiveShardCount waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public CreateIndexRequest waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return this;
    }

    public CreateIndexRequest waitForActiveShards(int waitForActiveShards) {
        return this.waitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.cause = in.readString();
        this.index = in.readString();
        this.settings = Settings.readSettingsFromStream(in);
        this.readTimeout(in);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            this.mappings.put(in.readString(), in.readString());
        }
        int customSize = in.readVInt();
        for (int i = 0; i < customSize; ++i) {
            String type = in.readString();
            IndexMetaData.Custom customIndexMetaData = IndexMetaData.lookupPrototypeSafe(type).readFrom(in);
            this.customs.put(type, customIndexMetaData);
        }
        int aliasesSize = in.readVInt();
        for (int i = 0; i < aliasesSize; ++i) {
            this.aliases.add(Alias.read(in));
        }
        this.updateAllTypes = in.readBoolean();
        this.waitForActiveShards = ActiveShardCount.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.cause);
        out.writeString(this.index);
        Settings.writeSettingsToStream(this.settings, out);
        this.writeTimeout(out);
        out.writeVInt(this.mappings.size());
        for (Map.Entry<String, String> entry : this.mappings.entrySet()) {
            out.writeString(entry.getKey());
            out.writeString(entry.getValue());
        }
        out.writeVInt(this.customs.size());
        for (Map.Entry<String, Object> entry : this.customs.entrySet()) {
            out.writeString(entry.getKey());
            ((IndexMetaData.Custom)entry.getValue()).writeTo(out);
        }
        out.writeVInt(this.aliases.size());
        for (Alias alias : this.aliases) {
            alias.writeTo(out);
        }
        out.writeBoolean(this.updateAllTypes);
        this.waitForActiveShards.writeTo(out);
    }
}

