/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefMath {
    private static final MethodHandles.Lookup PRIV_LOOKUP = MethodHandles.lookup();
    private static final Map<Class<?>, Map<String, MethodHandle>> TYPE_OP_MAPPING = Collections.unmodifiableMap(Stream.of(Boolean.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Object.class).collect(Collectors.toMap(Function.identity(), type -> {
        try {
            HashMap<String, MethodHandle> map = new HashMap<String, MethodHandle>();
            MethodType unary = MethodType.methodType(type, type);
            MethodType binary = MethodType.methodType(type, type, type);
            MethodType comparison = MethodType.methodType(Boolean.TYPE, type, type);
            MethodType shift = MethodType.methodType(type, type, Long.TYPE);
            Class<?> clazz = PRIV_LOOKUP.lookupClass();
            map.put("not", PRIV_LOOKUP.findStatic(clazz, "not", unary));
            map.put("neg", PRIV_LOOKUP.findStatic(clazz, "neg", unary));
            map.put("plus", PRIV_LOOKUP.findStatic(clazz, "plus", unary));
            map.put("mul", PRIV_LOOKUP.findStatic(clazz, "mul", binary));
            map.put("div", PRIV_LOOKUP.findStatic(clazz, "div", binary));
            map.put("rem", PRIV_LOOKUP.findStatic(clazz, "rem", binary));
            map.put("add", PRIV_LOOKUP.findStatic(clazz, "add", binary));
            map.put("sub", PRIV_LOOKUP.findStatic(clazz, "sub", binary));
            map.put("and", PRIV_LOOKUP.findStatic(clazz, "and", binary));
            map.put("or", PRIV_LOOKUP.findStatic(clazz, "or", binary));
            map.put("xor", PRIV_LOOKUP.findStatic(clazz, "xor", binary));
            map.put("eq", PRIV_LOOKUP.findStatic(clazz, "eq", comparison));
            map.put("lt", PRIV_LOOKUP.findStatic(clazz, "lt", comparison));
            map.put("lte", PRIV_LOOKUP.findStatic(clazz, "lte", comparison));
            map.put("gt", PRIV_LOOKUP.findStatic(clazz, "gt", comparison));
            map.put("gte", PRIV_LOOKUP.findStatic(clazz, "gte", comparison));
            map.put("lsh", PRIV_LOOKUP.findStatic(clazz, "lsh", shift));
            map.put("rsh", PRIV_LOOKUP.findStatic(clazz, "rsh", shift));
            map.put("ush", PRIV_LOOKUP.findStatic(clazz, "ush", shift));
            return map;
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    })));
    private static final MethodHandle DYNAMIC_CAST;
    private static final MethodHandle DYNAMIC_RECEIVER_CAST;

    private static int not(int v) {
        return ~v;
    }

    private static long not(long v) {
        return v ^ 0xFFFFFFFFFFFFFFFFL;
    }

    private static float not(float v) {
        throw new ClassCastException("Cannot apply not [~] to type [float]");
    }

    private static double not(double v) {
        throw new ClassCastException("Cannot apply not [~] to type [double]");
    }

    private static boolean not(boolean v) {
        throw new ClassCastException("Cannot apply not [~] to type [boolean]");
    }

    private static Object not(Object unary) {
        if (unary instanceof Long) {
            return (Long)unary ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (unary instanceof Integer) {
            return ~((Integer)unary).intValue();
        }
        if (unary instanceof Short) {
            return (int)(~((Short)unary).shortValue());
        }
        if (unary instanceof Character) {
            return (int)(~((Character)unary).charValue());
        }
        if (unary instanceof Byte) {
            return (int)(~((Byte)unary).byteValue());
        }
        throw new ClassCastException("Cannot apply [~] operation to type [" + unary.getClass().getCanonicalName() + "].");
    }

    private static int neg(int v) {
        return -v;
    }

    private static long neg(long v) {
        return -v;
    }

    private static float neg(float v) {
        return -v;
    }

    private static double neg(double v) {
        return -v;
    }

    private static boolean neg(boolean v) {
        throw new ClassCastException("Cannot apply [-] operation to type [boolean]");
    }

    private static Object neg(Object unary) {
        if (unary instanceof Double) {
            return -((Double)unary).doubleValue();
        }
        if (unary instanceof Long) {
            return -((Long)unary).longValue();
        }
        if (unary instanceof Integer) {
            return -((Integer)unary).intValue();
        }
        if (unary instanceof Float) {
            return Float.valueOf(-((Float)unary).floatValue());
        }
        if (unary instanceof Short) {
            return (int)(-((Short)unary).shortValue());
        }
        if (unary instanceof Character) {
            return (int)(-((Character)unary).charValue());
        }
        if (unary instanceof Byte) {
            return (int)(-((Byte)unary).byteValue());
        }
        throw new ClassCastException("Cannot apply [-] operation to type [" + unary.getClass().getCanonicalName() + "].");
    }

    private static int plus(int v) {
        return v;
    }

    private static long plus(long v) {
        return v;
    }

    private static float plus(float v) {
        return v;
    }

    private static double plus(double v) {
        return v;
    }

    private static boolean plus(boolean v) {
        throw new ClassCastException("Cannot apply [+] operation to type [boolean]");
    }

    private static Object plus(Object unary) {
        if (unary instanceof Double) {
            return (double)((Double)unary);
        }
        if (unary instanceof Long) {
            return (long)((Long)unary);
        }
        if (unary instanceof Integer) {
            return (int)((Integer)unary);
        }
        if (unary instanceof Float) {
            return Float.valueOf(((Float)unary).floatValue());
        }
        if (unary instanceof Short) {
            return (int)((Short)unary).shortValue();
        }
        if (unary instanceof Character) {
            return (int)((Character)unary).charValue();
        }
        if (unary instanceof Byte) {
            return (int)((Byte)unary).byteValue();
        }
        throw new ClassCastException("Cannot apply [+] operation to type [" + unary.getClass().getCanonicalName() + "].");
    }

    private static int mul(int a, int b) {
        return a * b;
    }

    private static long mul(long a, long b) {
        return a * b;
    }

    private static float mul(float a, float b) {
        return a * b;
    }

    private static double mul(double a, double b) {
        return a * b;
    }

    private static boolean mul(boolean a, boolean b) {
        throw new ClassCastException("Cannot apply [*] operation to type [boolean]");
    }

    private static Object mul(Object left, Object right) {
        if (left instanceof Number) {
            if (right instanceof Number) {
                if (left instanceof Double || right instanceof Double) {
                    return ((Number)left).doubleValue() * ((Number)right).doubleValue();
                }
                if (left instanceof Float || right instanceof Float) {
                    return Float.valueOf(((Number)left).floatValue() * ((Number)right).floatValue());
                }
                if (left instanceof Long || right instanceof Long) {
                    return ((Number)left).longValue() * ((Number)right).longValue();
                }
                return ((Number)left).intValue() * ((Number)right).intValue();
            }
            if (right instanceof Character) {
                if (left instanceof Double) {
                    return ((Number)left).doubleValue() * (double)((Character)right).charValue();
                }
                if (left instanceof Long) {
                    return ((Number)left).longValue() * (long)((Character)right).charValue();
                }
                if (left instanceof Float) {
                    return Float.valueOf(((Number)left).floatValue() * (float)((Character)right).charValue());
                }
                return ((Number)left).intValue() * ((Character)right).charValue();
            }
        } else if (left instanceof Character) {
            if (right instanceof Number) {
                if (right instanceof Double) {
                    return (double)((Character)left).charValue() * ((Number)right).doubleValue();
                }
                if (right instanceof Long) {
                    return (long)((Character)left).charValue() * ((Number)right).longValue();
                }
                if (right instanceof Float) {
                    return Float.valueOf((float)((Character)left).charValue() * ((Number)right).floatValue());
                }
                return ((Character)left).charValue() * ((Number)right).intValue();
            }
            if (right instanceof Character) {
                return ((Character)left).charValue() * ((Character)right).charValue();
            }
        }
        throw new ClassCastException("Cannot apply [*] operation to types [" + left.getClass().getCanonicalName() + "] and [" + right.getClass().getCanonicalName() + "].");
    }

    private static int div(int a, int b) {
        return a / b;
    }

    private static long div(long a, long b) {
        return a / b;
    }

    private static float div(float a, float b) {
        return a / b;
    }

    private static double div(double a, double b) {
        return a / b;
    }

    private static boolean div(boolean a, boolean b) {
        throw new ClassCastException("Cannot apply [/] operation to type [boolean]");
    }

    private static Object div(Object left, Object right) {
        if (left instanceof Number) {
            if (right instanceof Number) {
                if (left instanceof Double || right instanceof Double) {
                    return ((Number)left).doubleValue() / ((Number)right).doubleValue();
                }
                if (left instanceof Float || right instanceof Float) {
                    return Float.valueOf(((Number)left).floatValue() / ((Number)right).floatValue());
                }
                if (left instanceof Long || right instanceof Long) {
                    return ((Number)left).longValue() / ((Number)right).longValue();
                }
                return ((Number)left).intValue() / ((Number)right).intValue();
            }
            if (right instanceof Character) {
                if (left instanceof Double) {
                    return ((Number)left).doubleValue() / (double)((Character)right).charValue();
                }
                if (left instanceof Long) {
                    return ((Number)left).longValue() / (long)((Character)right).charValue();
                }
                if (left instanceof Float) {
                    return Float.valueOf(((Number)left).floatValue() / (float)((Character)right).charValue());
                }
                return ((Number)left).intValue() / ((Character)right).charValue();
            }
        } else if (left instanceof Character) {
            if (right instanceof Number) {
                if (right instanceof Double) {
                    return (double)((Character)left).charValue() / ((Number)right).doubleValue();
                }
                if (right instanceof Long) {
                    return (long)((Character)left).charValue() / ((Number)right).longValue();
                }
                if (right instanceof Float) {
                    return Float.valueOf((float)((Character)left).charValue() / ((Number)right).floatValue());
                }
                return ((Character)left).charValue() / ((Number)right).intValue();
            }
            if (right instanceof Character) {
                return ((Character)left).charValue() / ((Character)right).charValue();
            }
        }
        throw new ClassCastException("Cannot apply [/] operation to types [" + left.getClass().getCanonicalName() + "] and [" + right.getClass().getCanonicalName() + "].");
    }

    private static int rem(int a, int b) {
        return a % b;
    }

    private static long rem(long a, long b) {
        return a % b;
    }

    private static float rem(float a, float b) {
        return a % b;
    }

    private static double rem(double a, double b) {
        return a % b;
    }

    private static boolean rem(boolean a, boolean b) {
        throw new ClassCastException("Cannot apply [%] operation to type [boolean]");
    }

    private static Object rem(Object left, Object right) {
        if (left instanceof Number) {
            if (right instanceof Number) {
                if (left instanceof Double || right instanceof Double) {
                    return ((Number)left).doubleValue() % ((Number)right).doubleValue();
                }
                if (left instanceof Float || right instanceof Float) {
                    return Float.valueOf(((Number)left).floatValue() % ((Number)right).floatValue());
                }
                if (left instanceof Long || right instanceof Long) {
                    return ((Number)left).longValue() % ((Number)right).longValue();
                }
                return ((Number)left).intValue() % ((Number)right).intValue();
            }
            if (right instanceof Character) {
                if (left instanceof Double) {
                    return ((Number)left).doubleValue() % (double)((Character)right).charValue();
                }
                if (left instanceof Long) {
                    return ((Number)left).longValue() % (long)((Character)right).charValue();
                }
                if (left instanceof Float) {
                    return Float.valueOf(((Number)left).floatValue() % (float)((Character)right).charValue());
                }
                return ((Number)left).intValue() % ((Character)right).charValue();
            }
        } else if (left instanceof Character) {
            if (right instanceof Number) {
                if (right instanceof Double) {
                    return (double)((Character)left).charValue() % ((Number)right).doubleValue();
                }
                if (right instanceof Long) {
                    return (long)((Character)left).charValue() % ((Number)right).longValue();
                }
                if (right instanceof Float) {
                    return Float.valueOf((float)((Character)left).charValue() % ((Number)right).floatValue());
                }
                return ((Character)left).charValue() % ((Number)right).intValue();
            }
            if (right instanceof Character) {
                return ((Character)left).charValue() % ((Character)right).charValue();
            }
        }
        throw new ClassCastException("Cannot apply [%] operation to types [" + left.getClass().getCanonicalName() + "] and [" + right.getClass().getCanonicalName() + "].");
    }

    private static int add(int a, int b) {
        return a + b;
    }

    private static long add(long a, long b) {
        return a + b;
    }

    private static float add(float a, float b) {
        return a + b;
    }

    private static double add(double a, double b) {
        return a + b;
    }

    private static boolean add(boolean a, boolean b) {
        throw new ClassCastException("Cannot apply [+] operation to type [boolean]");
    }

    private static Object add(Object left, Object right) {
        if (left instanceof String || right instanceof String) {
            return "" + left + right;
        }
        if (left instanceof Number) {
            if (right instanceof Number) {
                if (left instanceof Double || right instanceof Double) {
                    return ((Number)left).doubleValue() + ((Number)right).doubleValue();
                }
                if (left instanceof Float || right instanceof Float) {
                    return Float.valueOf(((Number)left).floatValue() + ((Number)right).floatValue());
                }
                if (left instanceof Long || right instanceof Long) {
                    return ((Number)left).longValue() + ((Number)right).longValue();
                }
                return ((Number)left).intValue() + ((Number)right).intValue();
            }
            if (right instanceof Character) {
                if (left instanceof Double) {
                    return ((Number)left).doubleValue() + (double)((Character)right).charValue();
                }
                if (left instanceof Long) {
                    return ((Number)left).longValue() + (long)((Character)right).charValue();
                }
                if (left instanceof Float) {
                    return Float.valueOf(((Number)left).floatValue() + (float)((Character)right).charValue());
                }
                return ((Number)left).intValue() + ((Character)right).charValue();
            }
        } else if (left instanceof Character) {
            if (right instanceof Number) {
                if (right instanceof Double) {
                    return (double)((Character)left).charValue() + ((Number)right).doubleValue();
                }
                if (right instanceof Long) {
                    return (long)((Character)left).charValue() + ((Number)right).longValue();
                }
                if (right instanceof Float) {
                    return Float.valueOf((float)((Character)left).charValue() + ((Number)right).floatValue());
                }
                return ((Character)left).charValue() + ((Number)right).intValue();
            }
            if (right instanceof Character) {
                return ((Character)left).charValue() + ((Character)right).charValue();
            }
        }
        throw new ClassCastException("Cannot apply [+] operation to types [" + left.getClass().getCanonicalName() + "] and [" + right.getClass().getCanonicalName() + "].");
    }

    private static int sub(int a, int b) {
        return a - b;
    }

    private static long sub(long a, long b) {
        return a - b;
    }

    private static float sub(float a, float b) {
        return a - b;
    }

    private static double sub(double a, double b) {
        return a - b;
    }

    private static boolean sub(boolean a, boolean b) {
        throw new ClassCastException("Cannot apply [-] operation to type [boolean]");
    }

    private static Object sub(Object left, Object right) {
        if (left instanceof Number) {
            if (right instanceof Number) {
                if (left instanceof Double || right instanceof Double) {
                    return ((Number)left).doubleValue() - ((Number)right).doubleValue();
                }
                if (left instanceof Float || right instanceof Float) {
                    return Float.valueOf(((Number)left).floatValue() - ((Number)right).floatValue());
                }
                if (left instanceof Long || right instanceof Long) {
                    return ((Number)left).longValue() - ((Number)right).longValue();
                }
                return ((Number)left).intValue() - ((Number)right).intValue();
            }
            if (right instanceof Character) {
                if (left instanceof Double) {
                    return ((Number)left).doubleValue() - (double)((Character)right).charValue();
                }
                if (left instanceof Long) {
                    return ((Number)left).longValue() - (long)((Character)right).charValue();
                }
                if (left instanceof Float) {
                    return Float.valueOf(((Number)left).floatValue() - (float)((Character)right).charValue());
                }
                return ((Number)left).intValue() - ((Character)right).charValue();
            }
        } else if (left instanceof Character) {
            if (right instanceof Number) {
                if (right instanceof Double) {
                    return (double)((Character)left).charValue() - ((Number)right).doubleValue();
                }
                if (right instanceof Long) {
                    return (long)((Character)left).charValue() - ((Number)right).longValue();
                }
                if (right instanceof Float) {
                    return Float.valueOf((float)((Character)left).charValue() - ((Number)right).floatValue());
                }
                return ((Character)left).charValue() - ((Number)right).intValue();
            }
            if (right instanceof Character) {
                return ((Character)left).charValue() - ((Character)right).charValue();
            }
        }
        throw new ClassCastException("Cannot apply [-] operation to types [" + left.getClass().getCanonicalName() + "] and [" + right.getClass().getCanonicalName() + "].");
    }

    private static boolean eq(int a, int b) {
        return a == b;
    }

    private static boolean eq(long a, long b) {
        return a == b;
    }

    private static boolean eq(float a, float b) {
        return a == b;
    }

    private static boolean eq(double a, double b) {
        return a == b;
    }

    private static boolean eq(boolean a, boolean b) {
        return a == b;
    }

    private static boolean eq(Object left, Object right) {
        if (left != null && right != null) {
            if (left instanceof Double) {
                if (right instanceof Number) {
                    return ((Double)left).doubleValue() == ((Number)right).doubleValue();
                }
                if (right instanceof Character) {
                    return (Double)left == (double)((Character)right).charValue();
                }
            } else if (right instanceof Double) {
                if (left instanceof Number) {
                    return ((Number)left).doubleValue() == ((Double)right).doubleValue();
                }
                if (left instanceof Character) {
                    return (double)((Character)left).charValue() == ((Number)right).doubleValue();
                }
            } else if (left instanceof Float) {
                if (right instanceof Number) {
                    return ((Float)left).floatValue() == ((Number)right).floatValue();
                }
                if (right instanceof Character) {
                    return ((Float)left).floatValue() == (float)((Character)right).charValue();
                }
            } else if (right instanceof Float) {
                if (left instanceof Number) {
                    return ((Number)left).floatValue() == ((Float)right).floatValue();
                }
                if (left instanceof Character) {
                    return (float)((Character)left).charValue() == ((Number)right).floatValue();
                }
            } else if (left instanceof Long) {
                if (right instanceof Number) {
                    return ((Long)left).longValue() == ((Number)right).longValue();
                }
                if (right instanceof Character) {
                    return (Long)left == (long)((Character)right).charValue();
                }
            } else if (right instanceof Long) {
                if (left instanceof Number) {
                    return ((Number)left).longValue() == ((Long)right).longValue();
                }
                if (left instanceof Character) {
                    return (long)((Character)left).charValue() == ((Number)right).longValue();
                }
            } else if (left instanceof Number) {
                if (right instanceof Number) {
                    return ((Number)left).intValue() == ((Number)right).intValue();
                }
                if (right instanceof Character) {
                    return ((Number)left).intValue() == ((Character)right).charValue();
                }
            } else {
                if (right instanceof Number && left instanceof Character) {
                    return ((Character)left).charValue() == ((Number)right).intValue();
                }
                if (left instanceof Character && right instanceof Character) {
                    return ((Character)left).charValue() == ((Character)right).charValue();
                }
            }
            return left.equals(right);
        }
        return left == null && right == null;
    }

    private static boolean lt(int a, int b) {
        return a < b;
    }

    private static boolean lt(long a, long b) {
        return a < b;
    }

    private static boolean lt(float a, float b) {
        return a < b;
    }

    private static boolean lt(double a, double b) {
        return a < b;
    }

    private static boolean lt(boolean a, boolean b) {
        throw new ClassCastException("Cannot apply [<] operation to type [boolean]");
    }

    private static boolean lt(Object left, Object right) {
        if (left instanceof Number) {
            if (right instanceof Number) {
                if (left instanceof Double || right instanceof Double) {
                    return ((Number)left).doubleValue() < ((Number)right).doubleValue();
                }
                if (left instanceof Float || right instanceof Float) {
                    return ((Number)left).floatValue() < ((Number)right).floatValue();
                }
                if (left instanceof Long || right instanceof Long) {
                    return ((Number)left).longValue() < ((Number)right).longValue();
                }
                return ((Number)left).intValue() < ((Number)right).intValue();
            }
            if (right instanceof Character) {
                if (left instanceof Double) {
                    return ((Number)left).doubleValue() < (double)((Character)right).charValue();
                }
                if (left instanceof Long) {
                    return ((Number)left).longValue() < (long)((Character)right).charValue();
                }
                if (left instanceof Float) {
                    return ((Number)left).floatValue() < (float)((Character)right).charValue();
                }
                return ((Number)left).intValue() < ((Character)right).charValue();
            }
        } else if (left instanceof Character) {
            if (right instanceof Number) {
                if (right instanceof Double) {
                    return (double)((Character)left).charValue() < ((Number)right).doubleValue();
                }
                if (right instanceof Long) {
                    return (long)((Character)left).charValue() < ((Number)right).longValue();
                }
                if (right instanceof Float) {
                    return (float)((Character)left).charValue() < ((Number)right).floatValue();
                }
                return ((Character)left).charValue() < ((Number)right).intValue();
            }
            if (right instanceof Character) {
                return ((Character)left).charValue() < ((Character)right).charValue();
            }
        }
        throw new ClassCastException("Cannot apply [<] operation to types [" + left.getClass().getCanonicalName() + "] and [" + right.getClass().getCanonicalName() + "].");
    }

    private static boolean lte(int a, int b) {
        return a <= b;
    }

    private static boolean lte(long a, long b) {
        return a <= b;
    }

    private static boolean lte(float a, float b) {
        return a <= b;
    }

    private static boolean lte(double a, double b) {
        return a <= b;
    }

    private static boolean lte(boolean a, boolean b) {
        throw new ClassCastException("Cannot apply [<=] operation to type [boolean]");
    }

    private static boolean lte(Object left, Object right) {
        if (left instanceof Number) {
            if (right instanceof Number) {
                if (left instanceof Double || right instanceof Double) {
                    return ((Number)left).doubleValue() <= ((Number)right).doubleValue();
                }
                if (left instanceof Float || right instanceof Float) {
                    return ((Number)left).floatValue() <= ((Number)right).floatValue();
                }
                if (left instanceof Long || right instanceof Long) {
                    return ((Number)left).longValue() <= ((Number)right).longValue();
                }
                return ((Number)left).intValue() <= ((Number)right).intValue();
            }
            if (right instanceof Character) {
                if (left instanceof Double) {
                    return ((Number)left).doubleValue() <= (double)((Character)right).charValue();
                }
                if (left instanceof Long) {
                    return ((Number)left).longValue() <= (long)((Character)right).charValue();
                }
                if (left instanceof Float) {
                    return ((Number)left).floatValue() <= (float)((Character)right).charValue();
                }
                return ((Number)left).intValue() <= ((Character)right).charValue();
            }
        } else if (left instanceof Character) {
            if (right instanceof Number) {
                if (right instanceof Double) {
                    return (double)((Character)left).charValue() <= ((Number)right).doubleValue();
                }
                if (right instanceof Long) {
                    return (long)((Character)left).charValue() <= ((Number)right).longValue();
                }
                if (right instanceof Float) {
                    return (float)((Character)left).charValue() <= ((Number)right).floatValue();
                }
                return ((Character)left).charValue() <= ((Number)right).intValue();
            }
            if (right instanceof Character) {
                return ((Character)left).charValue() <= ((Character)right).charValue();
            }
        }
        throw new ClassCastException("Cannot apply [<=] operation to types [" + left.getClass().getCanonicalName() + "] and [" + right.getClass().getCanonicalName() + "].");
    }

    private static boolean gt(int a, int b) {
        return a > b;
    }

    private static boolean gt(long a, long b) {
        return a > b;
    }

    private static boolean gt(float a, float b) {
        return a > b;
    }

    private static boolean gt(double a, double b) {
        return a > b;
    }

    private static boolean gt(boolean a, boolean b) {
        throw new ClassCastException("Cannot apply [>] operation to type [boolean]");
    }

    private static boolean gt(Object left, Object right) {
        if (left instanceof Number) {
            if (right instanceof Number) {
                if (left instanceof Double || right instanceof Double) {
                    return ((Number)left).doubleValue() > ((Number)right).doubleValue();
                }
                if (left instanceof Float || right instanceof Float) {
                    return ((Number)left).floatValue() > ((Number)right).floatValue();
                }
                if (left instanceof Long || right instanceof Long) {
                    return ((Number)left).longValue() > ((Number)right).longValue();
                }
                return ((Number)left).intValue() > ((Number)right).intValue();
            }
            if (right instanceof Character) {
                if (left instanceof Double) {
                    return ((Number)left).doubleValue() > (double)((Character)right).charValue();
                }
                if (left instanceof Long) {
                    return ((Number)left).longValue() > (long)((Character)right).charValue();
                }
                if (left instanceof Float) {
                    return ((Number)left).floatValue() > (float)((Character)right).charValue();
                }
                return ((Number)left).intValue() > ((Character)right).charValue();
            }
        } else if (left instanceof Character) {
            if (right instanceof Number) {
                if (right instanceof Double) {
                    return (double)((Character)left).charValue() > ((Number)right).doubleValue();
                }
                if (right instanceof Long) {
                    return (long)((Character)left).charValue() > ((Number)right).longValue();
                }
                if (right instanceof Float) {
                    return (float)((Character)left).charValue() > ((Number)right).floatValue();
                }
                return ((Character)left).charValue() > ((Number)right).intValue();
            }
            if (right instanceof Character) {
                return ((Character)left).charValue() > ((Character)right).charValue();
            }
        }
        throw new ClassCastException("Cannot apply [>] operation to types [" + left.getClass().getCanonicalName() + "] and [" + right.getClass().getCanonicalName() + "].");
    }

    private static boolean gte(int a, int b) {
        return a >= b;
    }

    private static boolean gte(long a, long b) {
        return a >= b;
    }

    private static boolean gte(float a, float b) {
        return a >= b;
    }

    private static boolean gte(double a, double b) {
        return a >= b;
    }

    private static boolean gte(boolean a, boolean b) {
        throw new ClassCastException("Cannot apply [>=] operation to type [boolean]");
    }

    private static boolean gte(Object left, Object right) {
        if (left instanceof Number) {
            if (right instanceof Number) {
                if (left instanceof Double || right instanceof Double) {
                    return ((Number)left).doubleValue() >= ((Number)right).doubleValue();
                }
                if (left instanceof Float || right instanceof Float) {
                    return ((Number)left).floatValue() >= ((Number)right).floatValue();
                }
                if (left instanceof Long || right instanceof Long) {
                    return ((Number)left).longValue() >= ((Number)right).longValue();
                }
                return ((Number)left).intValue() >= ((Number)right).intValue();
            }
            if (right instanceof Character) {
                if (left instanceof Double) {
                    return ((Number)left).doubleValue() >= (double)((Character)right).charValue();
                }
                if (left instanceof Long) {
                    return ((Number)left).longValue() >= (long)((Character)right).charValue();
                }
                if (left instanceof Float) {
                    return ((Number)left).floatValue() >= (float)((Character)right).charValue();
                }
                return ((Number)left).intValue() >= ((Character)right).charValue();
            }
        } else if (left instanceof Character) {
            if (right instanceof Number) {
                if (right instanceof Double) {
                    return (double)((Character)left).charValue() >= ((Number)right).doubleValue();
                }
                if (right instanceof Long) {
                    return (long)((Character)left).charValue() >= ((Number)right).longValue();
                }
                if (right instanceof Float) {
                    return (float)((Character)left).charValue() >= ((Number)right).floatValue();
                }
                return ((Character)left).charValue() >= ((Number)right).intValue();
            }
            if (right instanceof Character) {
                return ((Character)left).charValue() >= ((Character)right).charValue();
            }
        }
        throw new ClassCastException("Cannot apply [>] operation to types [" + left.getClass().getCanonicalName() + "] and [" + right.getClass().getCanonicalName() + "].");
    }

    private static long longIntegralValue(Object o) {
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Integer || o instanceof Short || o instanceof Byte) {
            return ((Number)o).longValue();
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        throw new ClassCastException("Cannot convert [" + o.getClass().getCanonicalName() + "] to an integral value.");
    }

    private static int intIntegralValue(Object o) {
        if (o instanceof Integer || o instanceof Short || o instanceof Byte) {
            return ((Number)o).intValue();
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        throw new ClassCastException("Cannot convert [" + o.getClass().getCanonicalName() + "] to an integral value.");
    }

    private static int and(int a, int b) {
        return a & b;
    }

    private static long and(long a, long b) {
        return a & b;
    }

    private static float and(float a, float b) {
        throw new ClassCastException("Cannot apply [&] operation to type [float]");
    }

    private static double and(double a, double b) {
        throw new ClassCastException("Cannot apply [&] operation to type [float]");
    }

    private static boolean and(boolean a, boolean b) {
        return a & b;
    }

    private static Object and(Object left, Object right) {
        if (left instanceof Boolean && right instanceof Boolean) {
            return (Boolean)left & (Boolean)right;
        }
        if (left instanceof Long || right instanceof Long) {
            return DefMath.longIntegralValue(left) & DefMath.longIntegralValue(right);
        }
        return DefMath.intIntegralValue(left) & DefMath.intIntegralValue(right);
    }

    private static int xor(int a, int b) {
        return a ^ b;
    }

    private static long xor(long a, long b) {
        return a ^ b;
    }

    private static float xor(float a, float b) {
        throw new ClassCastException("Cannot apply [^] operation to type [float]");
    }

    private static double xor(double a, double b) {
        throw new ClassCastException("Cannot apply [^] operation to type [float]");
    }

    private static boolean xor(boolean a, boolean b) {
        return a ^ b;
    }

    private static Object xor(Object left, Object right) {
        if (left instanceof Boolean && right instanceof Boolean) {
            return (Boolean)left ^ (Boolean)right;
        }
        if (left instanceof Long || right instanceof Long) {
            return DefMath.longIntegralValue(left) ^ DefMath.longIntegralValue(right);
        }
        return DefMath.intIntegralValue(left) ^ DefMath.intIntegralValue(right);
    }

    private static int or(int a, int b) {
        return a | b;
    }

    private static long or(long a, long b) {
        return a | b;
    }

    private static float or(float a, float b) {
        throw new ClassCastException("Cannot apply [|] operation to type [float]");
    }

    private static double or(double a, double b) {
        throw new ClassCastException("Cannot apply [|] operation to type [float]");
    }

    private static boolean or(boolean a, boolean b) {
        return a | b;
    }

    private static Object or(Object left, Object right) {
        if (left instanceof Boolean && right instanceof Boolean) {
            return (Boolean)left | (Boolean)right;
        }
        if (left instanceof Long || right instanceof Long) {
            return DefMath.longIntegralValue(left) | DefMath.longIntegralValue(right);
        }
        return DefMath.intIntegralValue(left) | DefMath.intIntegralValue(right);
    }

    private static int lsh(int a, long b) {
        return a << (int)b;
    }

    private static long lsh(long a, long b) {
        return a << (int)b;
    }

    private static float lsh(float a, long b) {
        throw new ClassCastException("Cannot apply [<<] operation to type [float]");
    }

    private static double lsh(double a, long b) {
        throw new ClassCastException("Cannot apply [<<] operation to type [double]");
    }

    private static boolean lsh(boolean a, long b) {
        throw new ClassCastException("Cannot apply [<<] operation to type [boolean]");
    }

    public static Object lsh(Object left, long right) {
        if (left instanceof Long) {
            return (Long)left << (int)right;
        }
        return DefMath.intIntegralValue(left) << (int)right;
    }

    private static int rsh(int a, long b) {
        return a >> (int)b;
    }

    private static long rsh(long a, long b) {
        return a >> (int)b;
    }

    private static float rsh(float a, long b) {
        throw new ClassCastException("Cannot apply [>>] operation to type [float]");
    }

    private static double rsh(double a, long b) {
        throw new ClassCastException("Cannot apply [>>] operation to type [double]");
    }

    private static boolean rsh(boolean a, long b) {
        throw new ClassCastException("Cannot apply [>>] operation to type [boolean]");
    }

    public static Object rsh(Object left, long right) {
        if (left instanceof Long) {
            return (Long)left >> (int)right;
        }
        return DefMath.intIntegralValue(left) >> (int)right;
    }

    private static int ush(int a, long b) {
        return a >>> (int)b;
    }

    private static long ush(long a, long b) {
        return a >>> (int)b;
    }

    private static float ush(float a, long b) {
        throw new ClassCastException("Cannot apply [>>>] operation to type [float]");
    }

    private static double ush(double a, long b) {
        throw new ClassCastException("Cannot apply [>>>] operation to type [double]");
    }

    private static boolean ush(boolean a, long b) {
        throw new ClassCastException("Cannot apply [>>>] operation to type [boolean]");
    }

    public static Object ush(Object left, long right) {
        if (left instanceof Long) {
            return (Long)left >>> (int)right;
        }
        return DefMath.intIntegralValue(left) >>> (int)right;
    }

    private static Class<?> unbox(Class<?> clazz) {
        return MethodType.methodType(clazz).unwrap().returnType();
    }

    private static Class<?> promote(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return Object.class;
        }
        if (clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Character.TYPE || clazz == Integer.TYPE) {
            return Integer.TYPE;
        }
        return clazz;
    }

    private static Class<?> promote(Class<?> a, Class<?> b) {
        if (!a.isPrimitive() || !b.isPrimitive()) {
            return Object.class;
        }
        if (a == Boolean.TYPE && b == Boolean.TYPE) {
            return Boolean.TYPE;
        }
        if (a == Double.TYPE || b == Double.TYPE) {
            return Double.TYPE;
        }
        if (a == Float.TYPE || b == Float.TYPE) {
            return Float.TYPE;
        }
        if (a == Long.TYPE || b == Long.TYPE) {
            return Long.TYPE;
        }
        return Integer.TYPE;
    }

    public static MethodHandle lookupUnary(Class<?> receiverClass, String name) {
        MethodHandle handle = TYPE_OP_MAPPING.get(DefMath.promote(DefMath.unbox(receiverClass))).get(name);
        if (handle == null) {
            throw new ClassCastException("Cannot apply operator [" + name + "] to type [" + receiverClass + "]");
        }
        return handle;
    }

    public static MethodHandle lookupBinary(Class<?> classA, Class<?> classB, String name) {
        MethodHandle handle = TYPE_OP_MAPPING.get(DefMath.promote(DefMath.promote(DefMath.unbox(classA)), DefMath.promote(DefMath.unbox(classB)))).get(name);
        if (handle == null) {
            throw new ClassCastException("Cannot apply operator [" + name + "] to types [" + classA + "] and [" + classB + "]");
        }
        return handle;
    }

    public static MethodHandle lookupGeneric(String name) {
        return TYPE_OP_MAPPING.get(Object.class).get(name);
    }

    static Object dynamicReceiverCast(Object returnValue, Object lhs) {
        if (lhs != null) {
            return DefMath.dynamicCast(lhs.getClass(), returnValue);
        }
        return returnValue;
    }

    static Object dynamicCast(Class<?> clazz, Object value) {
        if (value != null) {
            if (clazz == value.getClass()) {
                return value;
            }
            if (clazz == Integer.class) {
                return DefMath.getNumber(value).intValue();
            }
            if (clazz == Long.class) {
                return DefMath.getNumber(value).longValue();
            }
            if (clazz == Double.class) {
                return DefMath.getNumber(value).doubleValue();
            }
            if (clazz == Float.class) {
                return Float.valueOf(DefMath.getNumber(value).floatValue());
            }
            if (clazz == Short.class) {
                return DefMath.getNumber(value).shortValue();
            }
            if (clazz == Byte.class) {
                return DefMath.getNumber(value).byteValue();
            }
            if (clazz == Character.class) {
                return Character.valueOf((char)DefMath.getNumber(value).intValue());
            }
            return clazz.cast(value);
        }
        return value;
    }

    static Number getNumber(Object o) {
        if (o instanceof Number) {
            return (Number)o;
        }
        if (o instanceof Character) {
            return (int)((Character)o).charValue();
        }
        throw new ClassCastException("Cannot convert [" + o.getClass() + "] to a Number");
    }

    public static MethodHandle dynamicCast(MethodHandle target) {
        MethodHandle cast = DYNAMIC_RECEIVER_CAST.asType(MethodType.methodType(target.type().returnType(), target.type().returnType(), new Class[]{target.type().parameterType(0)}));
        cast = MethodHandles.dropArguments(cast, 2, new Class[]{target.type().parameterType(1)});
        return MethodHandles.foldArguments(cast, target);
    }

    public static MethodHandle dynamicCast(MethodHandle target, Class<?> desired) {
        desired = MethodType.methodType(desired).wrap().returnType();
        MethodHandle cast = DYNAMIC_CAST.bindTo(desired);
        return MethodHandles.filterReturnValue(target, cast);
    }

    public static MethodHandle cast(Class<?> classA, MethodHandle target) {
        MethodType newType = MethodType.methodType(classA).unwrap();
        MethodType targetType = MethodType.methodType(target.type().returnType()).unwrap();
        if (newType.returnType() == targetType.returnType()) {
            return target;
        }
        if (newType.returnType() == Boolean.TYPE || targetType.returnType() == Boolean.TYPE) {
            throw new ClassCastException("Cannot cast " + targetType.returnType() + " to " + newType.returnType());
        }
        return MethodHandles.explicitCastArguments(target, target.type().changeReturnType((Class<?>)newType.returnType()));
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            DYNAMIC_CAST = lookup.findStatic(lookup.lookupClass(), "dynamicCast", MethodType.methodType(Object.class, Class.class, Object.class));
            DYNAMIC_RECEIVER_CAST = lookup.findStatic(lookup.lookupClass(), "dynamicReceiverCast", MethodType.methodType(Object.class, Object.class, Object.class));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

