/************************************************************************
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the                        *
 * Free Software Foundation, Inc.,                                      *
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.             *
 ************************************************************************/

#ifndef __FCITX_MODULE_FCITX_DBUS_API_H
#define __FCITX_MODULE_FCITX_DBUS_API_H

#include <stdint.h>
#include <stdarg.h>
#include <fcitx-utils/utils.h>
#include <fcitx/instance.h>
#include <fcitx/addon.h>
#include <fcitx/module.h>
#include "dbusstuff.h"

#ifdef __cplusplus
extern "C" {
#endif

DEFINE_GET_ADDON("fcitx-dbus", DBus)

DEFINE_GET_AND_INVOKE_FUNC(DBus, GetConnection, 0)
static inline DBusConnection*
FcitxDBusGetConnection(FcitxInstance *instance)
{
    void *result = NULL;
    FCITX_DEF_MODULE_ARGS(args);
    result = FcitxDBusInvokeGetConnection(instance, args);
    FCITX_RETURN_FROM_PTR(DBusConnection*, result);
}

DEFINE_GET_AND_INVOKE_FUNC(DBus, GetPrivConnection, 1)
static inline DBusConnection*
FcitxDBusGetPrivConnection(FcitxInstance *instance)
{
    void *result = NULL;
    FCITX_DEF_MODULE_ARGS(args);
    result = FcitxDBusInvokeGetPrivConnection(instance, args);
    FCITX_RETURN_FROM_PTR(DBusConnection*, result);
}

DEFINE_GET_AND_INVOKE_FUNC(DBus, WatchName, 2)
static inline int
FcitxDBusWatchName(FcitxInstance *instance, const char* _arg0, void* _arg1, FcitxDBusWatchNameCallback _arg2, void* _arg3, FcitxDestroyNotify _arg4)
{
    void *result = NULL;
    FCITX_DEF_CAST_TO_PTR(arg0, const char*, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, void*, _arg1);
    FCITX_DEF_CAST_TO_PTR(arg2, FcitxDBusWatchNameCallback, _arg2);
    FCITX_DEF_CAST_TO_PTR(arg3, void*, _arg3);
    FCITX_DEF_CAST_TO_PTR(arg4, FcitxDestroyNotify, _arg4);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1, arg2, arg3, arg4);
    result = FcitxDBusInvokeWatchName(instance, args);
    FCITX_RETURN_FROM_PTR(int, result);
}

DEFINE_GET_AND_INVOKE_FUNC(DBus, UnwatchName, 3)
static inline void
FcitxDBusUnwatchName(FcitxInstance *instance, int _arg0)
{
    FCITX_DEF_CAST_TO_PTR(arg0, int, _arg0);
    FCITX_DEF_MODULE_ARGS(args, arg0);
    FcitxDBusInvokeUnwatchName(instance, args);
}


#ifdef __cplusplus
}
#endif

#endif
