/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.klass.ClassNodes;
import org.jruby.truffle.language.RubyConstant;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.objects.LookupForExistingModuleNode;
import org.jruby.truffle.language.objects.LookupForExistingModuleNodeGen;

public class DefineClassNode
extends RubyNode {
    protected final String name;
    @Node.Child
    private RubyNode superClassNode;
    @Node.Child
    private RubyNode lexicalParentModule;
    @Node.Child
    private LookupForExistingModuleNode lookupForExistingModuleNode;
    @Node.Child
    private CallDispatchHeadNode inheritedNode;
    private final ConditionProfile needToDefineProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile noSuperClassSupplied = ConditionProfile.createBinaryProfile();
    private final BranchProfile errorProfile = BranchProfile.create();

    public DefineClassNode(String name, RubyNode lexicalParent, RubyNode superClass) {
        this.name = name;
        this.lexicalParentModule = lexicalParent;
        this.superClassNode = superClass;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        DynamicObject definedClass;
        Object lexicalParentObject = this.lexicalParentModule.execute(frame);
        if (!RubyGuards.isRubyModule(lexicalParentObject)) {
            this.errorProfile.enter();
            throw new RaiseException(this.coreExceptions().typeErrorIsNotA(lexicalParentObject, "module", (Node)this));
        }
        DynamicObject lexicalParentModule = (DynamicObject)lexicalParentObject;
        DynamicObject suppliedSuperClass = this.executeSuperClass(frame);
        RubyConstant constant = this.lookupForExistingModule(frame, this.name, lexicalParentModule);
        if (this.needToDefineProfile.profile(constant == null)) {
            DynamicObject superClass = this.noSuperClassSupplied.profile(suppliedSuperClass == null) ? this.getContext().getCoreLibrary().getObjectClass() : suppliedSuperClass;
            definedClass = ClassNodes.createInitializedRubyClass(this.getContext(), lexicalParentModule, superClass, this.name);
            this.callInherited(frame, superClass, definedClass);
        } else {
            if (!RubyGuards.isRubyClass(constant.getValue())) {
                this.errorProfile.enter();
                throw new RaiseException(this.coreExceptions().typeErrorIsNotA(constant.getValue(), "class", (Node)this));
            }
            definedClass = (DynamicObject)constant.getValue();
            DynamicObject currentSuperClass = ClassNodes.getSuperClass(definedClass);
            if (suppliedSuperClass != null && currentSuperClass != suppliedSuperClass) {
                this.errorProfile.enter();
                throw new RaiseException(this.coreExceptions().superclassMismatch(Layouts.MODULE.getFields(definedClass).getName(), this));
            }
        }
        return definedClass;
    }

    private DynamicObject executeSuperClass(VirtualFrame frame) {
        if (this.superClassNode == null) {
            return null;
        }
        Object superClassObject = this.superClassNode.execute(frame);
        if (!RubyGuards.isRubyClass(superClassObject)) {
            this.errorProfile.enter();
            throw new RaiseException(this.coreExceptions().typeError("superclass must be a Class", this));
        }
        DynamicObject superClass = (DynamicObject)superClassObject;
        if (Layouts.CLASS.getIsSingleton(superClass)) {
            this.errorProfile.enter();
            throw new RaiseException(this.coreExceptions().typeError("can't make subclass of virtual class", this));
        }
        return superClass;
    }

    private void callInherited(VirtualFrame frame, DynamicObject superClass, DynamicObject childClass) {
        if (this.inheritedNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.inheritedNode = this.insert(DispatchHeadNodeFactory.createMethodCallOnSelf());
        }
        this.inheritedNode.call(frame, superClass, "inherited", childClass);
    }

    private RubyConstant lookupForExistingModule(VirtualFrame frame, String name, DynamicObject lexicalParent) {
        if (this.lookupForExistingModuleNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.lookupForExistingModuleNode = this.insert(LookupForExistingModuleNodeGen.create(null, null));
        }
        return this.lookupForExistingModuleNode.executeLookupForExistingModule(frame, name, lexicalParent);
    }
}

