/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib.digest;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.ByteList;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.control.JavaException;
import org.jruby.truffle.stdlib.digest.DigestAlgorithm;

@CoreClass(value="Truffle::Digest")
public abstract class DigestNodes {
    @CompilerDirectives.TruffleBoundary
    private static MessageDigest getMessageDigestInstance(String name) {
        try {
            return MessageDigest.getInstance(name);
        }
        catch (NoSuchAlgorithmException e) {
            throw new JavaException(e);
        }
    }

    private static DynamicObject createDigest(RubyContext context, DigestAlgorithm algorithm) {
        return Layouts.DIGEST.createDigest(context.getCoreLibrary().getDigestFactory(), algorithm, DigestNodes.getMessageDigestInstance(algorithm.getName()));
    }

    @CoreMethod(names={"bubblebabble"}, onSingleton=true, required=1)
    public static abstract class BubbleBabbleNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(message)"})
        public DynamicObject bubblebabble(DynamicObject message) {
            Rope rope = StringOperations.rope(message);
            return this.createString(BubbleBabbleNode.bubblebabble(rope.getBytes(), 0, rope.byteLength()));
        }

        public static ByteList bubblebabble(byte[] message, int begin, int length) {
            char[] vowels = new char[]{'a', 'e', 'i', 'o', 'u', 'y'};
            char[] consonants = new char[]{'b', 'c', 'd', 'f', 'g', 'h', 'k', 'l', 'm', 'n', 'p', 'r', 's', 't', 'v', 'z', 'x'};
            long seed = 1L;
            ByteList retval = new ByteList();
            int rounds = length / 2 + 1;
            retval.append(120);
            for (int i = 0; i < rounds; ++i) {
                int idx2;
                int idx1;
                int idx0;
                if (i + 1 < rounds || length % 2 != 0) {
                    long b = message[begin + 2 * i] & 0xFF;
                    idx0 = (int)(((b >> 6 & 3L) + seed) % 6L) & 0xFFFFFFFF;
                    idx1 = (int)(b >> 2 & 0xFL) & 0xFFFFFFFF;
                    idx2 = (int)(((b & 3L) + seed / 6L) % 6L) & 0xFFFFFFFF;
                    retval.append(vowels[idx0]);
                    retval.append(consonants[idx1]);
                    retval.append(vowels[idx2]);
                    if (i + 1 >= rounds) continue;
                    long b2 = message[begin + 2 * i + 1] & 0xFF;
                    int idx3 = (int)(b2 >> 4 & 0xFL) & 0xFFFFFFFF;
                    int idx4 = (int)(b2 & 0xFL) & 0xFFFFFFFF;
                    retval.append(consonants[idx3]);
                    retval.append(45);
                    retval.append(consonants[idx4]);
                    seed = (seed * 5L + (b * 7L + b2)) % 36L;
                    continue;
                }
                idx0 = (int)(seed % 6L) & 0xFFFFFFFF;
                idx1 = 16;
                idx2 = (int)(seed / 6L) & 0xFFFFFFFF;
                retval.append(vowels[idx0]);
                retval.append(consonants[idx1]);
                retval.append(vowels[idx2]);
            }
            retval.append(120);
            return retval;
        }
    }

    @CoreMethod(names={"digest_length"}, onSingleton=true, required=1)
    public static abstract class DigestLengthNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int digestLength(DynamicObject digestObject) {
            return Layouts.DIGEST.getAlgorithm(digestObject).getLength();
        }
    }

    @CoreMethod(names={"digest"}, onSingleton=true, required=1)
    public static abstract class DigestNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject digest(DynamicObject digestObject) {
            MessageDigest digest = Layouts.DIGEST.getDigest(digestObject);
            return this.createString(RopeOperations.create(DigestNode.cloneAndDigest(digest), ASCIIEncoding.INSTANCE, CodeRange.CR_VALID));
        }

        @CompilerDirectives.TruffleBoundary
        private static byte[] cloneAndDigest(MessageDigest digest) {
            MessageDigest clonedDigest;
            try {
                clonedDigest = (MessageDigest)digest.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new JavaException(e);
            }
            return clonedDigest.digest();
        }
    }

    @CoreMethod(names={"reset"}, onSingleton=true, required=1)
    public static abstract class ResetNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject reset(DynamicObject digestObject) {
            Layouts.DIGEST.getDigest(digestObject).reset();
            return digestObject;
        }
    }

    @CoreMethod(names={"update"}, onSingleton=true, required=2)
    public static abstract class UpdateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubyString(message)"})
        public DynamicObject update(DynamicObject digestObject, DynamicObject message) {
            MessageDigest digest = Layouts.DIGEST.getDigest(digestObject);
            RopeOperations.visitBytes(StringOperations.rope(message), (bytes, offset, length) -> digest.update(bytes, offset, length));
            return digestObject;
        }
    }

    @CoreMethod(names={"sha512"}, onSingleton=true)
    public static abstract class SHA512Node
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject sha512() {
            return DigestNodes.createDigest(this.getContext(), DigestAlgorithm.SHA512);
        }
    }

    @CoreMethod(names={"sha384"}, onSingleton=true)
    public static abstract class SHA384Node
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject sha384() {
            return DigestNodes.createDigest(this.getContext(), DigestAlgorithm.SHA384);
        }
    }

    @CoreMethod(names={"sha256"}, onSingleton=true)
    public static abstract class SHA256Node
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject sha256() {
            return DigestNodes.createDigest(this.getContext(), DigestAlgorithm.SHA256);
        }
    }

    @CoreMethod(names={"sha1"}, onSingleton=true)
    public static abstract class SHA1Node
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject sha1() {
            return DigestNodes.createDigest(this.getContext(), DigestAlgorithm.SHA1);
        }
    }

    @CoreMethod(names={"md5"}, onSingleton=true)
    public static abstract class MD5Node
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject md5() {
            return DigestNodes.createDigest(this.getContext(), DigestAlgorithm.MD5);
        }
    }
}

