#ifndef EFL_INPUT_INTERFACE_EO_HH
#define EFL_INPUT_INTERFACE_EO_HH
#include <Eo.h>

extern "C" {
#include "efl_event_hold.eo.h"
#include "efl_event_key.eo.h"
#include "efl_event_pointer.eo.h"
#include "efl_input_interface.eo.h"
}
#include <Eina.hh>
#include <Eo.hh>
#include "efl_event_hold.eo.hh"
#include "efl_event_key.eo.hh"
#include "efl_event_pointer.eo.hh"
namespace efl { namespace input { 
struct Interface;
} } 
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::input::Interface> : ::std::true_type {}; } }

namespace eo_cxx {
namespace efl { namespace input { 
struct Interface {
   static Eo_Class const* _eo_class()
   {
      return EFL_INPUT_INTERFACE_INTERFACE;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   operator ::efl::input::Interface() const;
   operator ::efl::input::Interface&();
   operator ::efl::input::Interface const&() const;
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Interface> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Interface const > operator&() const { return {this}; }
   /// @endcond
};
} } 
}
namespace efl { namespace input { 
struct Interface : ::efl::eo::concrete
{
   explicit Interface( ::Eo* eo)
      : ::efl::eo::concrete(eo) {}
   explicit Interface(std::nullptr_t)
      : ::efl::eo::concrete(nullptr) {}
   Interface(Interface const& other) = default;
   Interface(Interface&& other) = default;
   Interface& operator=(Interface const& other) = default;
   Interface& operator=(Interface&& other) = default;
   Interface()
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class());
   }
   Interface( ::efl::eo::concrete parent)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, parent, _eo_class());
   }
   template <typename F> Interface(F f, typename ::std::enable_if< ::efl::eolian::is_callable<F>::value>::type* = 0)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class(), f);
   }
   static Eo_Class const* _eo_class()
   {
      return EFL_INPUT_INTERFACE_INTERFACE;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   static struct pointer_move_event
   {
      static Eo_Event_Description const* description()
      { return EFL_EVENT_POINTER_MOVE; }
      typedef  ::efl::event::Pointer parameter_type;
   } const pointer_move_event;
   static struct pointer_down_event
   {
      static Eo_Event_Description const* description()
      { return EFL_EVENT_POINTER_DOWN; }
      typedef  ::efl::event::Pointer parameter_type;
   } const pointer_down_event;
   static struct pointer_up_event
   {
      static Eo_Event_Description const* description()
      { return EFL_EVENT_POINTER_UP; }
      typedef  ::efl::event::Pointer parameter_type;
   } const pointer_up_event;
   static struct pointer_cancel_event
   {
      static Eo_Event_Description const* description()
      { return EFL_EVENT_POINTER_CANCEL; }
      typedef  ::efl::event::Pointer parameter_type;
   } const pointer_cancel_event;
   static struct pointer_in_event
   {
      static Eo_Event_Description const* description()
      { return EFL_EVENT_POINTER_IN; }
      typedef  ::efl::event::Pointer parameter_type;
   } const pointer_in_event;
   static struct pointer_out_event
   {
      static Eo_Event_Description const* description()
      { return EFL_EVENT_POINTER_OUT; }
      typedef  ::efl::event::Pointer parameter_type;
   } const pointer_out_event;
   static struct pointer_wheel_event
   {
      static Eo_Event_Description const* description()
      { return EFL_EVENT_POINTER_WHEEL; }
      typedef  ::efl::event::Pointer parameter_type;
   } const pointer_wheel_event;
   static struct key_down_event
   {
      static Eo_Event_Description const* description()
      { return EFL_EVENT_KEY_DOWN; }
      typedef  ::efl::event::Key parameter_type;
   } const key_down_event;
   static struct key_up_event
   {
      static Eo_Event_Description const* description()
      { return EFL_EVENT_KEY_UP; }
      typedef  ::efl::event::Key parameter_type;
   } const key_up_event;
   static struct hold_event
   {
      static Eo_Event_Description const* description()
      { return EFL_EVENT_HOLD; }
      typedef  ::efl::event::Hold parameter_type;
   } const hold_event;
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Interface> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Interface const > operator&() const { return {this}; }
   /// @endcond
};
static_assert(sizeof(Interface) == sizeof(Eo*), "");
static_assert(std::is_standard_layout<Interface>::value, "");
} } 
#include "efl_input_interface.eo.impl.hh"
#endif
