#ifndef _EFL_CANVAS_FILTER_INTERNAL_EO_H_
#define _EFL_CANVAS_FILTER_INTERNAL_EO_H_

#ifndef _EFL_CANVAS_FILTER_INTERNAL_EO_CLASS_TYPE
#define _EFL_CANVAS_FILTER_INTERNAL_EO_CLASS_TYPE

typedef Eo Efl_Canvas_Filter_Internal;

#endif

#ifndef _EFL_CANVAS_FILTER_INTERNAL_EO_TYPES
#define _EFL_CANVAS_FILTER_INTERNAL_EO_TYPES


#endif
/** Evas internal implementation of filters.
 *
 * @ingroup Efl_Canvas_Filter_Internal
 */
#define EFL_CANVAS_FILTER_INTERNAL_MIXIN efl_canvas_filter_internal_mixin_get()

EWAPI const Eo_Class *efl_canvas_filter_internal_mixin_get(void);

#ifdef EFL_CANVAS_FILTER_INTERNAL_PROTECTED
/**
 * @brief Marks this filter as changed.
 *
 * @param[in] val
 *
 * @ingroup Efl_Canvas_Filter_Internal
 */
EOAPI void evas_filter_changed_set(Eo *obj, Eina_Bool val);
#endif

#ifdef EFL_CANVAS_FILTER_INTERNAL_PROTECTED
/**
 * @brief Marks this filter as invalid.
 *
 * @param[in] val
 *
 * @ingroup Efl_Canvas_Filter_Internal
 */
EOAPI void evas_filter_invalid_set(Eo *obj, Eina_Bool val);
#endif

#ifdef EFL_CANVAS_FILTER_INTERNAL_PROTECTED
/**
 * @brief Retrieve cached output buffer, if any.
 *
 * Does not increment the reference count.
 *
 * @ingroup Efl_Canvas_Filter_Internal
 */
EOAPI void *evas_filter_output_buffer_get(const Eo *obj);
#endif

#ifdef EFL_CANVAS_FILTER_INTERNAL_PROTECTED
/** Called by Efl.Canvas.Filter.Internal to determine whether the input is
 * alpha or rgba.
 *
 * @ingroup Efl_Canvas_Filter_Internal
 */
EOAPI Eina_Bool evas_filter_input_alpha(Eo *obj);
#endif

#ifdef EFL_CANVAS_FILTER_INTERNAL_PROTECTED
/**
 * @brief Called by Efl.Canvas.Filter.Internal when the parent class must
 * render the input. ;
 *
 * @param[in] filter Evas_Filter_Context
 * @param[in] drawctx
 * @param[in] l
 * @param[in] r
 * @param[in] t
 * @param[in] b
 * @param[in] do_async
 *
 * @return Indicates success from the object render function.
 *
 * @ingroup Efl_Canvas_Filter_Internal
 */
EOAPI Eina_Bool evas_filter_input_render(Eo *obj, void *filter, void *drawctx, int l, int r, int t, int b, Eina_Bool do_async);
#endif

#ifdef EFL_CANVAS_FILTER_INTERNAL_PROTECTED
/**
 * @brief Called when the filter changes must trigger a redraw of the object.
 *
 * Virtual, to be implemented in the parent class.
 *
 * @ingroup Efl_Canvas_Filter_Internal
 */
EOAPI void evas_filter_dirty(Eo *obj);
#endif


#endif
