#ifndef EFL_GENERATED_ELM_WIDGET_HH
#define EFL_GENERATED_ELM_WIDGET_HH

extern "C"
{
#include <Efl.h>
}
#include <Eo.hh>

#include <eo_cxx_interop.hh>

extern "C"
{
#include "elm_widget.eo.h"
}

#include "evas_object_smart.eo.hh"
#include "elm_interface_atspi_accessible.eo.hh"
#include "elm_interface_atspi_component.eo.hh"
#include <Edje.h>
#include <eina-cxx/eina_list.hh>
#include <eo_base.eo.hh>
#include <evas_object.eo.hh>
#include <string>

namespace elm {

struct widget;

}

/// @cond EO_CXX_ABSTRACT
namespace eo_cxx {

namespace elm {

struct widget
{
   /// @param[out] newest_focus_order 
   /// @param can_focus_only 
   ///
   ::evas::object newest_focus_order_get(unsigned int* newest_focus_order_, bool can_focus_only_) const;

   void scroll_hold_push() const;

   /// @param cur 
   ///
   void cursor_add(Elm_Cursor * cur_) const;

   /// @param next 
   /// @param dir 
   ///
   void focus_next_object_set(::evas::object next_, Elm_Focus_Direction dir_) const;

   /// @param dir 
   ///
   ::evas::object focus_next_object_get(Elm_Focus_Direction dir_) const;

   /// @param next_item 
   /// @param dir 
   ///
   void focus_next_item_set(Elm_Object_Item * next_item_, Elm_Focus_Direction dir_) const;

   /// @param dir 
   ///
   Elm_Object_Item * focus_next_item_get(Elm_Focus_Direction dir_) const;

   void focus_tree_unfocusable_handle() const;

   /// @param child 
   /// @param relative_child 
   ///
   void focus_custom_chain_prepend(::evas::object child_, ::evas::object relative_child_) const;

   /// @param part 
   /// @param text 
   ///
   ::efl::eina::string_view part_text_translate(::efl::eina::string_view part_, ::efl::eina::string_view text_) const;

   /// @param x 
   /// @param y 
   /// @param w 
   /// @param h 
   ///
   void focus_highlight_geometry_get(Evas_Coord * x_, Evas_Coord * y_, Evas_Coord * w_, Evas_Coord * h_) const;

   /// @param act 
   ///
   bool activate(Elm_Activate act_) const;

   /// @param sobj 
   ///
   bool sub_object_add(::evas::object sobj_) const;

   bool focus_direction_manager_is() const;

   /// @param source 
   /// @param type 
   /// @param event_info 
   ///
   bool event(::evas::object source_, Evas_Callback_Type type_, void * event_info_) const;

   /// @param func 
   /// @param data 
   ///
   void event_callback_add(Elm_Event_Cb func_, const void * data_) const;

   /// @param acs 
   ///
   void access(bool acs_) const;

   /// @param cur 
   ///
   void cursor_del(Elm_Cursor * cur_) const;

   /// @param func 
   /// @param data 
   ///
   void * event_callback_del(Elm_Event_Cb func_, const void * data_) const;

   /// @param item 
   ///
   bool on_focus(Elm_Object_Item * item_) const;

   /// @param[out] x 
   /// @param[out] y 
   /// @param[out] w 
   /// @param[out] h 
   ///
   bool on_focus_region(Evas_Coord* x_, Evas_Coord* y_, Evas_Coord* w_, Evas_Coord* h_) const;

   /// @param dir 
   ///
   void focus_cycle(Elm_Focus_Direction dir_) const;

   /// @param base 
   /// @param degree 
   /// @param[out] direction 
   /// @param[out] direction_item 
   /// @param[out] weight 
   ///
   bool focus_direction(::evas::object base_, double degree_, ::evas::object* direction_, Elm_Object_Item ** direction_item_, double* weight_) const;

   /// @param type 
   /// @param event_info 
   /// @param event_flags 
   ///
   bool event_propagate(Evas_Callback_Type type_, void * event_info_, Evas_Event_Flags * event_flags_) const;

   /// @param emission 
   /// @param source 
   /// @param func 
   /// @param data 
   ///
   template <typename F_func_>
   void signal_callback_add(::efl::eina::string_view emission_, ::efl::eina::string_view source_, F_func_ && func_) const;

   bool focus_next_manager_is() const;

   /// @param name 
   /// @param recurse 
   ///
   ::evas::object name_find(::efl::eina::string_view name_, int recurse_) const;

   /// @param base 
   /// @param items 
   /// @param list_data_get 
   /// @param degree 
   /// @param[out] direction 
   /// @param[out] direction_item 
   /// @param[out] weight 
   ///
   bool focus_list_direction_get(::evas::object base_, ::efl::eina::crange_list< ::eo::base > items_, list_data_get_func_type list_data_get_, double degree_, ::evas::object* direction_, Elm_Object_Item ** direction_item_, double* weight_) const;

   void focused_object_clear() const;

   /// @param degree 
   ///
   bool focus_direction_go(double degree_) const;

   /// @param x 
   /// @param y 
   /// @param w 
   /// @param h 
   /// @param forceshow 
   ///
   void show_region_set(Evas_Coord x_, Evas_Coord y_, Evas_Coord w_, Evas_Coord h_, bool forceshow_) const;

   /// @param[out] x 
   /// @param[out] y 
   /// @param[out] w 
   /// @param[out] h 
   ///
   void show_region_get(Evas_Coord* x_, Evas_Coord* y_, Evas_Coord* w_, Evas_Coord* h_) const;

   void scroll_freeze_pop() const;

   /// @param tt 
   ///
   void tooltip_del(Elm_Tooltip * tt_) const;

   /// @param dir 
   /// @param[out] next 
   /// @param[out] next_item 
   ///
   bool focus_next_get(Elm_Focus_Direction dir_, ::evas::object* next_, Elm_Object_Item ** next_item_) const;

   /// @param part 
   ///
   ::efl::eina::string_view translatable_part_text_get(::efl::eina::string_view part_) const;

   void focus_restore() const;

   void scroll_hold_pop() const;

   bool translate() const;

   void scroll_freeze_push() const;

   void focus_custom_chain_unset() const;

   /// @param item 
   ///
   void focus_steal(Elm_Object_Item * item_) const;

   void focus_hide_handle() const;

   /// @param dir 
   /// @param[out] next 
   /// @param[out] next_item 
   ///
   bool focus_next(Elm_Focus_Direction dir_, ::evas::object* next_, Elm_Object_Item ** next_item_) const;

   /// @param items 
   /// @param list_data_get 
   /// @param dir 
   /// @param[out] next 
   /// @param[out] next_item 
   ///
   bool focus_list_next_get(::efl::eina::crange_list< ::eo::base > items_, list_data_get_func_type list_data_get_, Elm_Focus_Direction dir_, ::evas::object* next_, Elm_Object_Item ** next_item_) const;

   void focus_mouse_up_handle() const;

   bool theme_apply() const;

   /// @param base 
   /// @param degree 
   /// @param[out] direction 
   /// @param[out] direction_item 
   /// @param[out] weight 
   ///
   bool focus_direction_get(::evas::object base_, double degree_, ::evas::object* direction_, Elm_Object_Item ** direction_item_, double* weight_) const;

   /// @param emission 
   /// @param source 
   /// @param func 
   ///
   void * signal_callback_del(::efl::eina::string_view emission_, ::efl::eina::string_view source_, Edje_Signal_Cb func_) const;

   /// @param emission 
   /// @param source 
   ///
   void signal_emit(::efl::eina::string_view emission_, ::efl::eina::string_view source_) const;

   bool disable() const;

   /// @param sobj 
   ///
   bool sub_object_del(::evas::object sobj_) const;

   /// @param tt 
   ///
   void tooltip_add(Elm_Tooltip * tt_) const;

   void focus_region_show() const;

   void focus_disabled_handle() const;

   /// @param child 
   /// @param relative_child 
   ///
   void focus_custom_chain_append(::evas::object child_, ::evas::object relative_child_) const;

   bool focus_get() const;

   void focus_set(bool focus_) const;

   bool drag_lock_y_get() const;

   void drag_lock_y_set(bool lock_) const;

   ::efl::eina::string_view focus_highlight_style_get() const;

   bool focus_highlight_style_set(::efl::eina::string_view style_) const;

   bool tree_unfocusable_get() const;

   void tree_unfocusable_set(bool tree_unfocusable_) const;

   bool mirrored_get() const;

   void mirrored_set(bool mirrored_) const;

   Elm_Theme * theme_get() const;

   void theme_set(Elm_Theme * th_) const;

   bool disabled_get() const;

   void disabled_set(bool disabled_) const;

   bool highlight_ignore_get() const;

   void highlight_ignore_set(bool ignore_) const;

   bool mirrored_automatic_get() const;

   void mirrored_automatic_set(bool automatic_) const;

   bool orientation_mode_disabled_get() const;

   void orientation_mode_disabled_set(bool disabled_) const;

   ::efl::eina::string_view style_get() const;

   bool style_set(::efl::eina::string_view style_) const;

   double scale_get() const;

   void scale_set(double scale_) const;

   ::efl::eina::crange_list< ::evas::object > focus_custom_chain_get() const;

   void focus_custom_chain_set(::efl::eina::range_list< ::evas::object > objs_) const;

   bool can_focus_get() const;

   void can_focus_set(bool can_focus_) const;

   bool highlight_in_theme_get() const;

   void highlight_in_theme_set(bool highlight_) const;

   ::evas::object parent_get() const;

   void parent_set(::evas::object parent_) const;

   ::efl::eina::optional< ::efl::eina::string_view > access_info_get() const;

   void access_info_set(::efl::eina::optional< ::efl::eina::string_view > txt_) const;

   bool drag_lock_x_get() const;

   void drag_lock_x_set(bool lock_) const;

   bool access_highlight_in_theme_get() const;

   void access_highlight_in_theme_set(bool highlight_) const;

   Elm_Focus_Region_Show_Mode focus_region_show_mode_get() const;

   void focus_region_show_mode_set(Elm_Focus_Region_Show_Mode mode_) const;

   void parent_highlight_set(bool highlighted_) const;

   bool theme_object_set(::evas::object edj_, ::efl::eina::string_view wname_, ::efl::eina::string_view welement_, ::efl::eina::string_view wstyle_) const;

   void hover_object_set(::evas::object sobj_) const;

   void display_mode_set(Evas_Display_Mode dispmode_) const;

   void on_show_region_hook_set(region_hook_func_type func_, void * data_) const;

   void domain_part_text_translatable_set(::efl::eina::string_view part_, ::efl::eina::string_view domain_, bool translatable_) const;

   void orientation_set(int rotation_) const;

   void resize_object_set(::evas::object sobj_, bool sub_obj_) const;

   void domain_translatable_part_text_set(::efl::eina::string_view part_, ::efl::eina::string_view domain_, ::efl::eina::string_view label_) const;

   ::efl::eina::list< ::evas::object > scrollable_children_get() const;

   int scroll_hold_get() const;

   int drag_child_locked_y_get() const;

   bool item_loop_enabled_get() const;

   void item_loop_enabled_set(bool enable_) const;

   bool child_can_focus_get() const;

   int scroll_freeze_get() const;

   bool focus_region_get(Evas_Coord* x_, Evas_Coord* y_, Evas_Coord* w_, Evas_Coord* h_) const;

   ::evas::object top_get() const;

   unsigned int focus_order_get() const;

   int drag_child_locked_x_get() const;

   ::efl::eina::list< ::evas::object > can_focus_child_list_get() const;

   ::elm::widget_item focused_item_get() const;

   void parents_bounce_get(Eina_Bool* horiz_, Eina_Bool* vert_) const;

   ::evas::object parent_widget_get() const;

   bool highlight_get() const;

   ::evas::object focused_object_get() const;

   ::evas::object parent2_get() const;

   void parent2_set(::evas::object parent_) const;

   ::efl::eina::string_view part_text_get(::efl::eina::string_view part_) const;

   void part_text_set(::efl::eina::string_view part_, ::efl::eina::string_view label_) const;

   Elm_Focus_Move_Policy focus_move_policy_get() const;

   void focus_move_policy_set(Elm_Focus_Move_Policy policy_) const;

   template <typename F>
   ::efl::eo::signal_connection
   callback_moved_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIDGET_EVENT_MOVED, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         ELM_WIDGET_EVENT_MOVED );
   }

   template <typename T>
   void
   callback_moved_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIDGET_EVENT_MOVED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_focused_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIDGET_EVENT_FOCUSED, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         ELM_WIDGET_EVENT_FOCUSED );
   }

   template <typename T>
   void
   callback_focused_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIDGET_EVENT_FOCUSED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_unfocused_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIDGET_EVENT_UNFOCUSED, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         ELM_WIDGET_EVENT_UNFOCUSED );
   }

   template <typename T>
   void
   callback_unfocused_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIDGET_EVENT_UNFOCUSED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_language_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIDGET_EVENT_LANGUAGE_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         ELM_WIDGET_EVENT_LANGUAGE_CHANGED );
   }

   template <typename T>
   void
   callback_language_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIDGET_EVENT_LANGUAGE_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_access_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIDGET_EVENT_ACCESS_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         ELM_WIDGET_EVENT_ACCESS_CHANGED );
   }

   template <typename T>
   void
   callback_access_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIDGET_EVENT_ACCESS_CHANGED, info));
   }



   static Eo_Class const* _eo_class()
   {
      return(ELM_WIDGET_CLASS);
   }

   operator ::elm::widget() const;
   operator ::elm::widget&();
   operator ::elm::widget const&() const;

   /// @cond LOCAL
   template <typename D>
   struct address_of
   {
      operator ::elm::widget*() const { return static_cast<::elm::widget*>(static_cast<D const*>(this)->p); }
      operator ::elm::widget const*() const { return static_cast<::elm::widget const*>(static_cast<D const*>(this)->p); }
   };

   template <typename D>
   struct address_const_of
   {
      operator ::elm::widget const*() const { return static_cast<::elm::widget const*>(static_cast<D const*>(this)->p); }
   };
   /// @endcond

private:

   /// @internal
   Eo* _concrete_eo_ptr() const
   {
      return static_cast<::efl::eo::concrete const*>(static_cast<void const*>(this))->_eo_ptr();
   }

};

}

}
/// @endcond

namespace elm {

/// @brief Class widget
struct widget
      : ::efl::eo::concrete
      , EO_CXX_INHERIT(efl::gfx::base)
      , EO_CXX_INHERIT(efl::gfx::stack)
      , EO_CXX_INHERIT(elm_interface_atspi_accessible)
      , EO_CXX_INHERIT(elm_interface_atspi_component)
      , EO_CXX_INHERIT(eo::base)
      , EO_CXX_INHERIT(evas::common_interface)
      , EO_CXX_INHERIT(evas::object)
      , EO_CXX_INHERIT(evas::object_smart)
      , EO_CXX_INHERIT(evas::signal_interface)
{
   //@{
   /**
      @brief Constructs a new elm::widget object.

      Constructs a new elm::widget object. If you want this object to be a child
      of another Eo object, use an @ref efl::eo::parent expression, like the example.

      Example:
      @code
      elm::widget my_widget(efl::eo::parent = parent_object);
      @endcode

      @see widget(Eo* eo)
   */
   explicit widget(::efl::eo::parent_type _p)
      : widget(_ctors_call(_p))
   {}

   explicit widget()
      : widget(_ctors_call(::efl::eo::parent = nullptr))
   {}
   //@}

   /// @brief Eo Constructor.
   ///
   /// Constructs the object from an Eo* pointer stealing its ownership.
   ///
   /// @param eo The Eo object pointer.
   ///
   explicit widget(Eo* eo)
      : ::efl::eo::concrete(eo)
   {}

   /// @brief nullptr_t Constructor.
   ///
   /// Constructs an empty (null) object.
   ///
   explicit widget(std::nullptr_t)
      : ::efl::eo::concrete(nullptr)
   {}

   /// @brief Copy Constructor.
   ///
   widget(widget const& other)
      : widget(eo_ref(other._eo_ptr()))
   {}

   ~widget() {}

   /// @param[out] newest_focus_order 
   /// @param can_focus_only 
   ///
   ::evas::object newest_focus_order_get(unsigned int* newest_focus_order_, bool can_focus_only_) const;

   void scroll_hold_push() const;

   /// @param cur 
   ///
   void cursor_add(Elm_Cursor * cur_) const;

   /// @param next 
   /// @param dir 
   ///
   void focus_next_object_set(::evas::object next_, Elm_Focus_Direction dir_) const;

   /// @param dir 
   ///
   ::evas::object focus_next_object_get(Elm_Focus_Direction dir_) const;

   /// @param next_item 
   /// @param dir 
   ///
   void focus_next_item_set(Elm_Object_Item * next_item_, Elm_Focus_Direction dir_) const;

   /// @param dir 
   ///
   Elm_Object_Item * focus_next_item_get(Elm_Focus_Direction dir_) const;

   void focus_tree_unfocusable_handle() const;

   /// @param child 
   /// @param relative_child 
   ///
   void focus_custom_chain_prepend(::evas::object child_, ::evas::object relative_child_) const;

   /// @param part 
   /// @param text 
   ///
   ::efl::eina::string_view part_text_translate(::efl::eina::string_view part_, ::efl::eina::string_view text_) const;

   /// @param x 
   /// @param y 
   /// @param w 
   /// @param h 
   ///
   void focus_highlight_geometry_get(Evas_Coord * x_, Evas_Coord * y_, Evas_Coord * w_, Evas_Coord * h_) const;

   /// @param act 
   ///
   bool activate(Elm_Activate act_) const;

   /// @param sobj 
   ///
   bool sub_object_add(::evas::object sobj_) const;

   bool focus_direction_manager_is() const;

   /// @param source 
   /// @param type 
   /// @param event_info 
   ///
   bool event(::evas::object source_, Evas_Callback_Type type_, void * event_info_) const;

   /// @param func 
   /// @param data 
   ///
   void event_callback_add(Elm_Event_Cb func_, const void * data_) const;

   /// @param acs 
   ///
   void access(bool acs_) const;

   /// @param cur 
   ///
   void cursor_del(Elm_Cursor * cur_) const;

   /// @param func 
   /// @param data 
   ///
   void * event_callback_del(Elm_Event_Cb func_, const void * data_) const;

   /// @param item 
   ///
   bool on_focus(Elm_Object_Item * item_) const;

   /// @param[out] x 
   /// @param[out] y 
   /// @param[out] w 
   /// @param[out] h 
   ///
   bool on_focus_region(Evas_Coord* x_, Evas_Coord* y_, Evas_Coord* w_, Evas_Coord* h_) const;

   /// @param dir 
   ///
   void focus_cycle(Elm_Focus_Direction dir_) const;

   /// @param base 
   /// @param degree 
   /// @param[out] direction 
   /// @param[out] direction_item 
   /// @param[out] weight 
   ///
   bool focus_direction(::evas::object base_, double degree_, ::evas::object* direction_, Elm_Object_Item ** direction_item_, double* weight_) const;

   /// @param type 
   /// @param event_info 
   /// @param event_flags 
   ///
   bool event_propagate(Evas_Callback_Type type_, void * event_info_, Evas_Event_Flags * event_flags_) const;

   /// @param emission 
   /// @param source 
   /// @param func 
   /// @param data 
   ///
   template <typename F_func_>
   void signal_callback_add(::efl::eina::string_view emission_, ::efl::eina::string_view source_, F_func_ && func_) const;

   bool focus_next_manager_is() const;

   /// @param name 
   /// @param recurse 
   ///
   ::evas::object name_find(::efl::eina::string_view name_, int recurse_) const;

   /// @param base 
   /// @param items 
   /// @param list_data_get 
   /// @param degree 
   /// @param[out] direction 
   /// @param[out] direction_item 
   /// @param[out] weight 
   ///
   bool focus_list_direction_get(::evas::object base_, ::efl::eina::crange_list< ::eo::base > items_, list_data_get_func_type list_data_get_, double degree_, ::evas::object* direction_, Elm_Object_Item ** direction_item_, double* weight_) const;

   void focused_object_clear() const;

   /// @param degree 
   ///
   bool focus_direction_go(double degree_) const;

   /// @param x 
   /// @param y 
   /// @param w 
   /// @param h 
   /// @param forceshow 
   ///
   void show_region_set(Evas_Coord x_, Evas_Coord y_, Evas_Coord w_, Evas_Coord h_, bool forceshow_) const;

   /// @param[out] x 
   /// @param[out] y 
   /// @param[out] w 
   /// @param[out] h 
   ///
   void show_region_get(Evas_Coord* x_, Evas_Coord* y_, Evas_Coord* w_, Evas_Coord* h_) const;

   void scroll_freeze_pop() const;

   /// @param tt 
   ///
   void tooltip_del(Elm_Tooltip * tt_) const;

   /// @param dir 
   /// @param[out] next 
   /// @param[out] next_item 
   ///
   bool focus_next_get(Elm_Focus_Direction dir_, ::evas::object* next_, Elm_Object_Item ** next_item_) const;

   /// @param part 
   ///
   ::efl::eina::string_view translatable_part_text_get(::efl::eina::string_view part_) const;

   void focus_restore() const;

   void scroll_hold_pop() const;

   bool translate() const;

   void scroll_freeze_push() const;

   void focus_custom_chain_unset() const;

   /// @param item 
   ///
   void focus_steal(Elm_Object_Item * item_) const;

   void focus_hide_handle() const;

   /// @param dir 
   /// @param[out] next 
   /// @param[out] next_item 
   ///
   bool focus_next(Elm_Focus_Direction dir_, ::evas::object* next_, Elm_Object_Item ** next_item_) const;

   /// @param items 
   /// @param list_data_get 
   /// @param dir 
   /// @param[out] next 
   /// @param[out] next_item 
   ///
   bool focus_list_next_get(::efl::eina::crange_list< ::eo::base > items_, list_data_get_func_type list_data_get_, Elm_Focus_Direction dir_, ::evas::object* next_, Elm_Object_Item ** next_item_) const;

   void focus_mouse_up_handle() const;

   bool theme_apply() const;

   /// @param base 
   /// @param degree 
   /// @param[out] direction 
   /// @param[out] direction_item 
   /// @param[out] weight 
   ///
   bool focus_direction_get(::evas::object base_, double degree_, ::evas::object* direction_, Elm_Object_Item ** direction_item_, double* weight_) const;

   /// @param emission 
   /// @param source 
   /// @param func 
   ///
   void * signal_callback_del(::efl::eina::string_view emission_, ::efl::eina::string_view source_, Edje_Signal_Cb func_) const;

   /// @param emission 
   /// @param source 
   ///
   void signal_emit(::efl::eina::string_view emission_, ::efl::eina::string_view source_) const;

   bool disable() const;

   /// @param sobj 
   ///
   bool sub_object_del(::evas::object sobj_) const;

   /// @param tt 
   ///
   void tooltip_add(Elm_Tooltip * tt_) const;

   void focus_region_show() const;

   void focus_disabled_handle() const;

   /// @param child 
   /// @param relative_child 
   ///
   void focus_custom_chain_append(::evas::object child_, ::evas::object relative_child_) const;

   bool focus_get() const;

   void focus_set(bool focus_) const;

   bool drag_lock_y_get() const;

   void drag_lock_y_set(bool lock_) const;

   ::efl::eina::string_view focus_highlight_style_get() const;

   bool focus_highlight_style_set(::efl::eina::string_view style_) const;

   bool tree_unfocusable_get() const;

   void tree_unfocusable_set(bool tree_unfocusable_) const;

   bool mirrored_get() const;

   void mirrored_set(bool mirrored_) const;

   Elm_Theme * theme_get() const;

   void theme_set(Elm_Theme * th_) const;

   bool disabled_get() const;

   void disabled_set(bool disabled_) const;

   bool highlight_ignore_get() const;

   void highlight_ignore_set(bool ignore_) const;

   bool mirrored_automatic_get() const;

   void mirrored_automatic_set(bool automatic_) const;

   bool orientation_mode_disabled_get() const;

   void orientation_mode_disabled_set(bool disabled_) const;

   ::efl::eina::string_view style_get() const;

   bool style_set(::efl::eina::string_view style_) const;

   double scale_get() const;

   void scale_set(double scale_) const;

   ::efl::eina::crange_list< ::evas::object > focus_custom_chain_get() const;

   void focus_custom_chain_set(::efl::eina::range_list< ::evas::object > objs_) const;

   bool can_focus_get() const;

   void can_focus_set(bool can_focus_) const;

   bool highlight_in_theme_get() const;

   void highlight_in_theme_set(bool highlight_) const;

   ::evas::object parent_get() const;

   void parent_set(::evas::object parent_) const;

   ::efl::eina::optional< ::efl::eina::string_view > access_info_get() const;

   void access_info_set(::efl::eina::optional< ::efl::eina::string_view > txt_) const;

   bool drag_lock_x_get() const;

   void drag_lock_x_set(bool lock_) const;

   bool access_highlight_in_theme_get() const;

   void access_highlight_in_theme_set(bool highlight_) const;

   Elm_Focus_Region_Show_Mode focus_region_show_mode_get() const;

   void focus_region_show_mode_set(Elm_Focus_Region_Show_Mode mode_) const;

   void parent_highlight_set(bool highlighted_) const;

   bool theme_object_set(::evas::object edj_, ::efl::eina::string_view wname_, ::efl::eina::string_view welement_, ::efl::eina::string_view wstyle_) const;

   void hover_object_set(::evas::object sobj_) const;

   void display_mode_set(Evas_Display_Mode dispmode_) const;

   void on_show_region_hook_set(region_hook_func_type func_, void * data_) const;

   void domain_part_text_translatable_set(::efl::eina::string_view part_, ::efl::eina::string_view domain_, bool translatable_) const;

   void orientation_set(int rotation_) const;

   void resize_object_set(::evas::object sobj_, bool sub_obj_) const;

   void domain_translatable_part_text_set(::efl::eina::string_view part_, ::efl::eina::string_view domain_, ::efl::eina::string_view label_) const;

   ::efl::eina::list< ::evas::object > scrollable_children_get() const;

   int scroll_hold_get() const;

   int drag_child_locked_y_get() const;

   bool item_loop_enabled_get() const;

   void item_loop_enabled_set(bool enable_) const;

   bool child_can_focus_get() const;

   int scroll_freeze_get() const;

   bool focus_region_get(Evas_Coord* x_, Evas_Coord* y_, Evas_Coord* w_, Evas_Coord* h_) const;

   ::evas::object top_get() const;

   unsigned int focus_order_get() const;

   int drag_child_locked_x_get() const;

   ::efl::eina::list< ::evas::object > can_focus_child_list_get() const;

   ::elm::widget_item focused_item_get() const;

   void parents_bounce_get(Eina_Bool* horiz_, Eina_Bool* vert_) const;

   ::evas::object parent_widget_get() const;

   bool highlight_get() const;

   ::evas::object focused_object_get() const;

   ::evas::object parent2_get() const;

   void parent2_set(::evas::object parent_) const;

   ::efl::eina::string_view part_text_get(::efl::eina::string_view part_) const;

   void part_text_set(::efl::eina::string_view part_, ::efl::eina::string_view label_) const;

   Elm_Focus_Move_Policy focus_move_policy_get() const;

   void focus_move_policy_set(Elm_Focus_Move_Policy policy_) const;

   template <typename F>
   ::efl::eo::signal_connection
   callback_access_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIDGET_EVENT_ACCESS_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         ELM_WIDGET_EVENT_ACCESS_CHANGED );
   }

   template <typename T>
   void
   callback_access_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIDGET_EVENT_ACCESS_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_active_descendant_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_ACTIVE_DESCENDANT_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_ACTIVE_DESCENDANT_CHANGED );
   }

   template <typename T>
   void
   callback_active_descendant_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_ACTIVE_DESCENDANT_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_added_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_ADDED, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_ADDED );
   }

   template <typename T>
   void
   callback_added_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_ADDED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_callback_add_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EO_BASE_EVENT_CALLBACK_ADD, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         EO_BASE_EVENT_CALLBACK_ADD );
   }

   template <typename T>
   void
   callback_callback_add_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EO_BASE_EVENT_CALLBACK_ADD, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_callback_del_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EO_BASE_EVENT_CALLBACK_DEL, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         EO_BASE_EVENT_CALLBACK_DEL );
   }

   template <typename T>
   void
   callback_callback_del_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EO_BASE_EVENT_CALLBACK_DEL, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_changed_size_hints_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_CHANGED_SIZE_HINTS, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         EVAS_OBJECT_EVENT_CHANGED_SIZE_HINTS );
   }

   template <typename T>
   void
   callback_changed_size_hints_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_CHANGED_SIZE_HINTS, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_children_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_CHILDREN_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_CHILDREN_CHANGED );
   }

   template <typename T>
   void
   callback_children_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_CHILDREN_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_focus_in_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_FOCUS_IN, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         EVAS_OBJECT_EVENT_FOCUS_IN );
   }

   template <typename T>
   void
   callback_focus_in_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_FOCUS_IN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_focus_out_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_FOCUS_OUT, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         EVAS_OBJECT_EVENT_FOCUS_OUT );
   }

   template <typename T>
   void
   callback_focus_out_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_FOCUS_OUT, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_focused_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIDGET_EVENT_FOCUSED, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         ELM_WIDGET_EVENT_FOCUSED );
   }

   template <typename T>
   void
   callback_focused_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIDGET_EVENT_FOCUSED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_free_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_FREE, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         EVAS_OBJECT_EVENT_FREE );
   }

   template <typename T>
   void
   callback_free_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_FREE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_hide_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_HIDE, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         EVAS_OBJECT_EVENT_HIDE );
   }

   template <typename T>
   void
   callback_hide_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_HIDE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_hold_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_HOLD, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         EVAS_OBJECT_EVENT_HOLD );
   }

   template <typename T>
   void
   callback_hold_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_HOLD, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_image_preloaded_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_IMAGE_PRELOADED, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         EVAS_OBJECT_EVENT_IMAGE_PRELOADED );
   }

   template <typename T>
   void
   callback_image_preloaded_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_IMAGE_PRELOADED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_image_resize_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_IMAGE_RESIZE, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         EVAS_OBJECT_EVENT_IMAGE_RESIZE );
   }

   template <typename T>
   void
   callback_image_resize_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_IMAGE_RESIZE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_image_unloaded_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_IMAGE_UNLOADED, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         EVAS_OBJECT_EVENT_IMAGE_UNLOADED );
   }

   template <typename T>
   void
   callback_image_unloaded_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_IMAGE_UNLOADED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_key_down_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_KEY_DOWN, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         EVAS_OBJECT_EVENT_KEY_DOWN );
   }

   template <typename T>
   void
   callback_key_down_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_KEY_DOWN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_key_up_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_KEY_UP, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         EVAS_OBJECT_EVENT_KEY_UP );
   }

   template <typename T>
   void
   callback_key_up_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_KEY_UP, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_language_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIDGET_EVENT_LANGUAGE_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         ELM_WIDGET_EVENT_LANGUAGE_CHANGED );
   }

   template <typename T>
   void
   callback_language_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIDGET_EVENT_LANGUAGE_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_mouse_down_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOUSE_DOWN, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         EVAS_OBJECT_EVENT_MOUSE_DOWN );
   }

   template <typename T>
   void
   callback_mouse_down_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOUSE_DOWN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_mouse_in_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOUSE_IN, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         EVAS_OBJECT_EVENT_MOUSE_IN );
   }

   template <typename T>
   void
   callback_mouse_in_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOUSE_IN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_mouse_move_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOUSE_MOVE, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         EVAS_OBJECT_EVENT_MOUSE_MOVE );
   }

   template <typename T>
   void
   callback_mouse_move_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOUSE_MOVE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_mouse_out_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOUSE_OUT, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         EVAS_OBJECT_EVENT_MOUSE_OUT );
   }

   template <typename T>
   void
   callback_mouse_out_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOUSE_OUT, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_mouse_up_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOUSE_UP, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         EVAS_OBJECT_EVENT_MOUSE_UP );
   }

   template <typename T>
   void
   callback_mouse_up_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOUSE_UP, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_mouse_wheel_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOUSE_WHEEL, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         EVAS_OBJECT_EVENT_MOUSE_WHEEL );
   }

   template <typename T>
   void
   callback_mouse_wheel_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOUSE_WHEEL, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_move_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOVE, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         EVAS_OBJECT_EVENT_MOVE );
   }

   template <typename T>
   void
   callback_move_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOVE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_moved_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIDGET_EVENT_MOVED, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         ELM_WIDGET_EVENT_MOVED );
   }

   template <typename T>
   void
   callback_moved_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIDGET_EVENT_MOVED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_multi_down_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MULTI_DOWN, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         EVAS_OBJECT_EVENT_MULTI_DOWN );
   }

   template <typename T>
   void
   callback_multi_down_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MULTI_DOWN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_multi_move_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MULTI_MOVE, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         EVAS_OBJECT_EVENT_MULTI_MOVE );
   }

   template <typename T>
   void
   callback_multi_move_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MULTI_MOVE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_multi_up_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MULTI_UP, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         EVAS_OBJECT_EVENT_MULTI_UP );
   }

   template <typename T>
   void
   callback_multi_up_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MULTI_UP, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_property_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_PROPERTY_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_PROPERTY_CHANGED );
   }

   template <typename T>
   void
   callback_property_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_PROPERTY_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_removed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_REMOVED, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_REMOVED );
   }

   template <typename T>
   void
   callback_removed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_REMOVED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_resize_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_RESIZE, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         EVAS_OBJECT_EVENT_RESIZE );
   }

   template <typename T>
   void
   callback_resize_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_RESIZE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_restack_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_RESTACK, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         EVAS_OBJECT_EVENT_RESTACK );
   }

   template <typename T>
   void
   callback_restack_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_RESTACK, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_show_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_SHOW, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         EVAS_OBJECT_EVENT_SHOW );
   }

   template <typename T>
   void
   callback_show_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_SHOW, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_state_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_STATE_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_STATE_CHANGED );
   }

   template <typename T>
   void
   callback_state_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_STATE_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_unfocused_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIDGET_EVENT_UNFOCUSED, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         ELM_WIDGET_EVENT_UNFOCUSED );
   }

   template <typename T>
   void
   callback_unfocused_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIDGET_EVENT_UNFOCUSED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_visible_data_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_VISIBLE_DATA_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::widget, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::widget, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_VISIBLE_DATA_CHANGED );
   }

   template <typename T>
   void
   callback_visible_data_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_VISIBLE_DATA_CHANGED, info));
   }



   static Eo_Class const* _eo_class()
   {
      return(ELM_WIDGET_CLASS);
   }

   /// @cond LOCAL
   struct address_of
      : ::eo_cxx::elm::widget::address_of<address_of>
      , ::eo_cxx::efl::gfx::base::address_of<address_of>
      , ::eo_cxx::efl::gfx::stack::address_of<address_of>
      , ::eo_cxx::elm_interface_atspi_accessible::address_of<address_of>
      , ::eo_cxx::elm_interface_atspi_component::address_of<address_of>
      , ::eo_cxx::eo::base::address_of<address_of>
      , ::eo_cxx::evas::common_interface::address_of<address_of>
      , ::eo_cxx::evas::object::address_of<address_of>
      , ::eo_cxx::evas::object_smart::address_of<address_of>
      , ::eo_cxx::evas::signal_interface::address_of<address_of>
      , ::efl::eo::detail::concrete_address_of
   {
      explicit address_of(::elm::widget* p)
         : ::efl::eo::detail::concrete_address_of(p)
      {}
   };
   address_of operator&() { return address_of(this); }

   struct address_const_of
      : ::eo_cxx::elm::widget::address_const_of<address_const_of>
      , ::eo_cxx::efl::gfx::base::address_const_of<address_const_of>
      , ::eo_cxx::efl::gfx::stack::address_const_of<address_const_of>
      , ::eo_cxx::elm_interface_atspi_accessible::address_const_of<address_const_of>
      , ::eo_cxx::elm_interface_atspi_component::address_const_of<address_const_of>
      , ::eo_cxx::eo::base::address_const_of<address_const_of>
      , ::eo_cxx::evas::common_interface::address_const_of<address_const_of>
      , ::eo_cxx::evas::object::address_const_of<address_const_of>
      , ::eo_cxx::evas::object_smart::address_const_of<address_const_of>
      , ::eo_cxx::evas::signal_interface::address_const_of<address_const_of>
      , ::efl::eo::detail::concrete_address_const_of
   {
      explicit address_const_of(::elm::widget const* p)
         : ::efl::eo::detail::concrete_address_const_of(p)
      {}
   };
   address_const_of operator&() const { return address_const_of(this); }

   /// @endcond

private:

   /// @internal
   static Eo* _ctors_call(::efl::eo::parent_type _p)
   {
      Eo* _ret_eo = eo_add_ref(ELM_WIDGET_CLASS, _p._eo_raw);

      return _ret_eo;
   }

   /// @internal
   Eo* _concrete_eo_ptr() const { return _eo_ptr(); }
};

static_assert(sizeof(::elm::widget) == sizeof(Eo*), "");
static_assert(std::is_standard_layout<::elm::widget>::value, "");

}


#include "elm_widget.eo.impl.hh"

#endif // EFL_GENERATED_ELM_WIDGET_HH

