/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.UIManager;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.OptionsDefinitions;
import net.sourceforge.jnlp.ParserSettings;
import net.sourceforge.jnlp.PropertyDesc;
import net.sourceforge.jnlp.about.AboutDialog;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.HtmlBoot;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.JnlpBoot;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.viewer.CertificateViewer;
import net.sourceforge.jnlp.services.ServiceUtil;
import net.sourceforge.jnlp.util.docprovider.IcedTeaWebTextsProvider;
import net.sourceforge.jnlp.util.docprovider.JavaWsTextsProvider;
import net.sourceforge.jnlp.util.docprovider.formatters.formatters.PlainTextFormatter;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.jnlp.util.optionparser.InvalidArgumentException;
import net.sourceforge.jnlp.util.optionparser.OptionParser;
import net.sourceforge.jnlp.util.optionparser.UnevenParameterException;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

public final class Boot
implements PrivilegedAction<Void> {
    public static final String name = Boot.class.getPackage().getImplementationTitle();
    public static final String version = Boot.class.getPackage().getImplementationVersion();
    private static final String nameAndVersion = name + " " + version;
    private static final String miniLicense = "\n   netx - an open-source JNLP client.\n   Copyright (C) 2001-2003 Jon A. Maxwell (JAM)\n\n   // This library is free software; you can redistribute it and/or\n   modify it under the terms of the GNU Lesser General Public\n   License as published by the Free Software Foundation; either\n   version 2.1 of the License, or (at your option) any later version.\n\n   This library is distributed in the hope that it will be useful,\n   but WITHOUT ANY WARRANTY; without even the implied warranty of\n   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n   Lesser General Public License for more details.\n\n   You should have received a copy of the GNU Lesser General Public\n   License along with this library; if not, write to the Free Software\n   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.\n\n";
    private static OptionParser optionParser;

    public static void main(String[] argsIn) throws UnevenParameterException {
        List<String> properties;
        optionParser = new OptionParser(argsIn, OptionsDefinitions.getJavaWsOptions());
        if (optionParser.hasOption(OptionsDefinitions.OPTIONS.VERBOSE)) {
            JNLPRuntime.setDebug(true);
        }
        if (AppContext.getAppContext() == null) {
            SunToolkit.createNewAppContext();
        }
        if (optionParser.hasOption(OptionsDefinitions.OPTIONS.HEADLESS)) {
            JNLPRuntime.setHeadless(true);
        }
        DeploymentConfiguration.move14AndOlderFilesTo15StructureCatched();
        if (optionParser.hasOption(OptionsDefinitions.OPTIONS.VIEWER)) {
            try {
                CertificateViewer.main(null);
                JNLPRuntime.exit(0);
            }
            catch (Exception e) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
            }
        }
        if (optionParser.hasOption(OptionsDefinitions.OPTIONS.VERSION)) {
            OutputController.getLogger().printOutLn(nameAndVersion);
            JNLPRuntime.exit(0);
        }
        if (optionParser.hasOption(OptionsDefinitions.OPTIONS.LICENSE)) {
            OutputController.getLogger().printOutLn(miniLicense);
            JNLPRuntime.exit(0);
        }
        if (optionParser.hasOption(OptionsDefinitions.OPTIONS.HELP1)) {
            Boot.handleMessage();
            JNLPRuntime.exit(0);
        }
        if ((properties = optionParser.getParams(OptionsDefinitions.OPTIONS.PROPERTY)) != null) {
            for (String prop : properties) {
                try {
                    PropertyDesc propDesc = PropertyDesc.fromString(prop);
                    JNLPRuntime.getConfiguration().setProperty(propDesc.getKey(), propDesc.getValue());
                }
                catch (LaunchException ex) {
                    OutputController.getLogger().log(ex);
                }
            }
        }
        if (optionParser.hasOption(OptionsDefinitions.OPTIONS.ABOUT)) {
            Boot.handleAbout();
            if (optionParser.hasOption(OptionsDefinitions.OPTIONS.HEADLESS)) {
                JNLPRuntime.exit(0);
            } else {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    OutputController.getLogger().log("Unable to set system look and feel");
                }
                OutputController.getLogger().printOutLn(Translator.R("BLaunchAbout"));
                AboutDialog.display("javaws");
                return;
            }
        }
        if (optionParser.hasOption(OptionsDefinitions.OPTIONS.UPDATE)) {
            int value = Integer.parseInt(optionParser.getParam(OptionsDefinitions.OPTIONS.UPDATE));
            JNLPRuntime.setDefaultUpdatePolicy(new UpdatePolicy((long)value * 1000L));
        }
        if (optionParser.hasOption(OptionsDefinitions.OPTIONS.NOUPDATE)) {
            JNLPRuntime.setDefaultUpdatePolicy(UpdatePolicy.NEVER);
        }
        if (optionParser.hasOption(OptionsDefinitions.OPTIONS.NOFORK)) {
            JNLPRuntime.setForksAllowed(false);
        }
        if (optionParser.hasOption(OptionsDefinitions.OPTIONS.TRUSTALL)) {
            JNLPRuntime.setTrustAll(true);
        }
        if (optionParser.hasOption(OptionsDefinitions.OPTIONS.HTML)) {
            JNLPRuntime.setHtml(true);
        }
        if (optionParser.hasOption(OptionsDefinitions.OPTIONS.TRUSTNONE)) {
            JNLPRuntime.setTrustNone(true);
        }
        if (optionParser.hasOption(OptionsDefinitions.OPTIONS.NOHEADERS)) {
            JNLPRuntime.setIgnoreHeaders(true);
        }
        if (optionParser.hasOption(OptionsDefinitions.OPTIONS.REDIRECT)) {
            JNLPRuntime.setAllowRedirect(true);
        }
        JNLPRuntime.setInitialArgments(Arrays.asList(argsIn));
        AccessController.doPrivileged(new Boot());
    }

    private static void handleMessage() {
        JavaWsTextsProvider helpMessagesProvider = new JavaWsTextsProvider("utf-8", new PlainTextFormatter(), true, true);
        String helpMessage = "\n";
        helpMessage = JNLPRuntime.isDebug() ? helpMessage + helpMessagesProvider.writeToString() : helpMessage + helpMessagesProvider.prepare().getSynopsis() + helpMessagesProvider.getFormatter().getNewLine() + helpMessagesProvider.prepare().getOptions() + helpMessagesProvider.getFormatter().getNewLine();
        OutputController.getLogger().printOut(helpMessage);
    }

    private static void handleAbout() {
        IcedTeaWebTextsProvider aboutMessagesProvider = new IcedTeaWebTextsProvider("utf-8", new PlainTextFormatter(), false, true);
        String itwInfoMessage = "" + nameAndVersion + "\n\n";
        itwInfoMessage = JNLPRuntime.isDebug() ? itwInfoMessage + aboutMessagesProvider.writeToString() : itwInfoMessage + aboutMessagesProvider.prepare().getIntroduction();
        OutputController.getLogger().printOut(itwInfoMessage);
    }

    @Override
    public Void run() {
        boolean run;
        HashMap<String, List<String>> extra = new HashMap<String, List<String>>();
        if (optionParser.hasOption(OptionsDefinitions.OPTIONS.HTML) ? !(run = new HtmlBoot(optionParser).run(extra)) : !(run = new JnlpBoot(optionParser).run(extra))) {
            return null;
        }
        return null;
    }

    static void fatalError(String message) {
        OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "netx: " + message);
        JNLPRuntime.exit(1);
    }

    static URL getFileLocation() {
        String location = null;
        try {
            location = Boot.getMainFile();
        }
        catch (InvalidArgumentException e) {
            OutputController.getLogger().log(e);
            Boot.fatalError("Invalid argument: " + e);
        }
        if (location == null) {
            Boot.handleMessage();
            JNLPRuntime.exit(1);
        }
        OutputController.getLogger().log(Translator.R("BFileLoc") + ": " + location);
        URL url = null;
        try {
            if (new File(location).exists()) {
                url = new File(location).toURL();
            } else if (ServiceUtil.getBasicService() != null) {
                OutputController.getLogger().log("Warning, null basicService");
                url = new URL(ServiceUtil.getBasicService().getCodeBase(), location);
            } else {
                url = new URL(location);
            }
        }
        catch (Exception e) {
            OutputController.getLogger().log(e);
            Boot.fatalError("Invalid jnlp file " + location);
        }
        return url;
    }

    private static String getMainFile() throws InvalidArgumentException {
        if (optionParser.getMainArgs().size() > 1 || optionParser.mainArgExists() && optionParser.hasOption(OptionsDefinitions.OPTIONS.JNLP) || optionParser.mainArgExists() && optionParser.hasOption(OptionsDefinitions.OPTIONS.HTML) || optionParser.hasOption(OptionsDefinitions.OPTIONS.JNLP) && optionParser.hasOption(OptionsDefinitions.OPTIONS.HTML)) {
            throw new InvalidArgumentException(optionParser.getMainArgs().toString());
        }
        if (optionParser.hasOption(OptionsDefinitions.OPTIONS.JNLP)) {
            return optionParser.getParam(OptionsDefinitions.OPTIONS.JNLP);
        }
        if (optionParser.hasOption(OptionsDefinitions.OPTIONS.HTML)) {
            return optionParser.getParam(OptionsDefinitions.OPTIONS.HTML);
        }
        if (optionParser.mainArgExists()) {
            return optionParser.getMainArg();
        }
        Boot.handleMessage();
        JNLPRuntime.exit(0);
        return null;
    }

    static ParserSettings init(Map<String, List<String>> extra) {
        JNLPRuntime.setSecurityEnabled(!optionParser.hasOption(OptionsDefinitions.OPTIONS.NOSEC));
        JNLPRuntime.setOfflineForced(optionParser.hasOption(OptionsDefinitions.OPTIONS.OFFLINE));
        JNLPRuntime.initialize(true);
        if (optionParser.hasOption(OptionsDefinitions.OPTIONS.CLEARCACHE)) {
            CacheUtil.clearCache();
            return null;
        }
        extra.put("arguments", optionParser.getParams(OptionsDefinitions.OPTIONS.ARG));
        extra.put("parameters", optionParser.getParams(OptionsDefinitions.OPTIONS.PARAM));
        extra.put("properties", optionParser.getParams(OptionsDefinitions.OPTIONS.PROPERTY));
        return ParserSettings.setGlobalParserSettingsFromOptionParser(optionParser);
    }
}

