/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.XAtom;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XLayerProtocol;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XProtocol;
import sun.awt.X11.XStateProtocol;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibWrapper;
import sun.util.logging.PlatformLogger;

class XWINProtocol
extends XProtocol
implements XStateProtocol,
XLayerProtocol {
    static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11.XWINProtocol");
    XAtom XA_WIN_SUPPORTING_WM_CHECK = XAtom.get("_WIN_SUPPORTING_WM_CHECK");
    XAtom XA_WIN_PROTOCOLS = XAtom.get("_WIN_PROTOCOLS");
    XAtom XA_WIN_STATE = XAtom.get("_WIN_STATE");
    XAtom XA_WIN_LAYER = XAtom.get("_WIN_LAYER");
    static final int WIN_STATE_STICKY = 1;
    static final int WIN_STATE_MINIMIZED = 2;
    static final int WIN_STATE_MAXIMIZED_VERT = 4;
    static final int WIN_STATE_MAXIMIZED_HORIZ = 8;
    static final int WIN_STATE_HIDDEN = 16;
    static final int WIN_STATE_SHADED = 32;
    static final int WIN_LAYER_ONTOP = 6;
    static final int WIN_LAYER_NORMAL = 4;
    long WinWindow = 0L;
    boolean supportChecked = false;

    XWINProtocol() {
    }

    @Override
    public boolean supportsState(int state) {
        return this.doStateProtocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setState(XWindowPeer window, int state) {
        if (window.isShowing()) {
            long win_state = 0L;
            if ((state & 4) != 0) {
                win_state |= 4L;
            }
            if ((state & 2) != 0) {
                win_state |= 8L;
            }
            XClientMessageEvent req = new XClientMessageEvent();
            req.set_type(33);
            req.set_window(window.getWindow());
            req.set_message_type(this.XA_WIN_STATE.getAtom());
            req.set_format(32);
            req.set_data(0, 12L);
            req.set_data(1, win_state);
            if (log.isLoggable(500)) {
                log.fine("Sending WIN_STATE to root to change the state to " + win_state);
            }
            try {
                XToolkit.awtLock();
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), XlibWrapper.RootWindow(XToolkit.getDisplay(), window.getScreenNumber()), false, 0x180000L, req.pData);
            }
            finally {
                XToolkit.awtUnlock();
            }
            req.dispose();
        } else {
            long win_state;
            long old_win_state = win_state = this.XA_WIN_STATE.getCard32Property(window);
            win_state = (state & 1) != 0 ? (win_state |= 2L) : (win_state &= 0xFFFFFFFFFFFFFFFDL);
            win_state = (state & 4) != 0 ? (win_state |= 4L) : (win_state &= 0xFFFFFFFFFFFFFFFBL);
            win_state = (state & 2) != 0 ? (win_state |= 8L) : (win_state &= 0xFFFFFFFFFFFFFFF7L);
            if ((old_win_state ^ win_state) != 0L) {
                if (log.isLoggable(500)) {
                    log.fine("Setting WIN_STATE on " + window + " to change the state to " + win_state);
                }
                this.XA_WIN_STATE.setCard32Property(window, win_state);
            }
        }
    }

    @Override
    public int getState(XWindowPeer window) {
        long win_state = this.XA_WIN_STATE.getCard32Property(window);
        int java_state = 0;
        if ((win_state & 4L) != 0L) {
            java_state |= 4;
        }
        if ((win_state & 8L) != 0L) {
            java_state |= 2;
        }
        return java_state;
    }

    @Override
    public boolean isStateChange(XPropertyEvent e) {
        return this.doStateProtocol() && e.get_atom() == this.XA_WIN_STATE.getAtom();
    }

    @Override
    public void unshadeKludge(XWindowPeer window) {
        long win_state = this.XA_WIN_STATE.getCard32Property(window);
        if ((win_state & 0x20L) == 0L) {
            return;
        }
        this.XA_WIN_STATE.setCard32Property(window, win_state &= 0xFFFFFFFFFFFFFFDFL);
    }

    @Override
    public boolean supportsLayer(int layer) {
        return (layer == 1 || layer == 0) && this.doLayerProtocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLayer(XWindowPeer window, int layer) {
        if (window.isShowing()) {
            XClientMessageEvent req = new XClientMessageEvent();
            req.set_type(33);
            req.set_window(window.getWindow());
            req.set_message_type(this.XA_WIN_LAYER.getAtom());
            req.set_format(32);
            req.set_data(0, layer == 0 ? 4L : 6L);
            req.set_data(1, 0L);
            req.set_data(2, 0L);
            if (log.isLoggable(500)) {
                log.fine("Setting layer " + layer + " by root message : " + req);
            }
            XToolkit.awtLock();
            try {
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), XlibWrapper.RootWindow(XToolkit.getDisplay(), window.getScreenNumber()), false, 524288L, req.pData);
            }
            finally {
                XToolkit.awtUnlock();
            }
            req.dispose();
        } else {
            if (log.isLoggable(500)) {
                log.fine("Setting layer property to " + layer);
            }
            this.XA_WIN_LAYER.setCard32Property(window, layer == 0 ? 4L : 6L);
        }
    }

    void detect() {
        if (this.supportChecked) {
            return;
        }
        this.WinWindow = this.checkAnchor(this.XA_WIN_SUPPORTING_WM_CHECK, 6L);
        this.supportChecked = true;
        if (log.isLoggable(500)) {
            log.fine("### " + this + " is active: " + (this.WinWindow != 0L));
        }
    }

    boolean active() {
        this.detect();
        return this.WinWindow != 0L;
    }

    boolean doStateProtocol() {
        boolean res;
        boolean bl = res = this.active() && this.checkProtocol(this.XA_WIN_PROTOCOLS, this.XA_WIN_STATE);
        if (log.isLoggable(500)) {
            log.fine("### " + this + " supports state: " + res);
        }
        return res;
    }

    boolean doLayerProtocol() {
        boolean res;
        boolean bl = res = this.active() && this.checkProtocol(this.XA_WIN_PROTOCOLS, this.XA_WIN_LAYER);
        if (log.isLoggable(500)) {
            log.fine("### " + this + " supports layer: " + res);
        }
        return res;
    }
}

