/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.util.Vector;

class CbColorWindow
extends FixedFrame
implements CbButtonCallback {
    CbColorWindowCallback callback;
    Color col;
    Vector pal;
    static Vector defpal = new Vector();
    Image[] palimg = new Image[12];
    CbButton[] palbut = new CbButton[12];
    int curpal = -1;
    CbButton ok;
    CbButton cancel;
    CbColorWindowCube ccube;

    CbColorWindow(Color color, CbColorWindowCallback cbColorWindowCallback) {
        int n;
        int n2;
        this.col = color;
        this.callback = cbColorWindowCallback;
        this.pal = this.callback.palette(this);
        if (this.pal == null) {
            this.pal = defpal;
        } else if (this.pal.size() == 0) {
            for (n2 = 0; n2 < 12; ++n2) {
                this.pal.addElement(defpal.elementAt(n2));
            }
        }
        for (n2 = 0; n2 < 12; ++n2) {
            this.palimg[n2] = Util.createImage(16, 16);
            this.updatePal(n2);
        }
        this.setLayout(new BorderLayout());
        GrayPanel grayPanel = new GrayPanel();
        grayPanel.setLayout(new FlowLayout(2));
        this.ok = new CbButton("Ok", (CbButtonCallback)this);
        grayPanel.add(this.ok);
        this.cancel = new CbButton("Cancel", (CbButtonCallback)this);
        grayPanel.add(this.cancel);
        this.add("South", grayPanel);
        BorderPanel borderPanel = new BorderPanel(1);
        borderPanel.setLayout(new BorderLayout());
        GrayPanel grayPanel2 = new GrayPanel();
        grayPanel2.setLayout(new GridLayout(2, 6, 4, 4));
        CbButtonGroup cbButtonGroup = new CbButtonGroup();
        for (n = 0; n < 12; ++n) {
            this.palbut[n] = new CbButton(this.palimg[n], (CbButtonCallback)this);
            grayPanel2.add(this.palbut[n]);
            this.palbut[n].setGroup(cbButtonGroup);
        }
        for (n = 0; n < 12; ++n) {
            if (!color.equals(this.pal.elementAt(n))) continue;
            this.curpal = n;
            this.palbut[n].select();
            break;
        }
        borderPanel.add("South", grayPanel2);
        this.ccube = new CbColorWindowCube(this);
        borderPanel.add("North", this.ccube);
        this.add("Center", borderPanel);
        this.pack();
        this.show();
        this.setTitle("Choose Color...");
    }

    void updatePal(int n) {
        Graphics graphics = this.palimg[n].getGraphics();
        graphics.setColor((Color)this.pal.elementAt(n));
        graphics.fillRect(0, 0, 16, 16);
        if (this.palbut[n] != null) {
            this.palbut[n].repaint();
        }
    }

    public void click(CbButton cbButton) {
        if (cbButton == this.ok) {
            this.callback.chosen(this, this.col);
            super.dispose();
        } else if (cbButton == this.cancel) {
            this.dispose();
        } else {
            for (int i = 0; i < 12; ++i) {
                if (cbButton != this.palbut[i]) continue;
                this.curpal = i;
                this.col = (Color)this.pal.elementAt(i);
                this.ccube.red.setPosition(this.col.getRed());
                this.ccube.blue.setPosition(this.col.getBlue());
                this.ccube.green.setPosition(this.col.getGreen());
                this.ccube.swatch.setColor(this.col);
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.callback.chosen(this, null);
    }

    public boolean isResizable() {
        return false;
    }

    static {
        defpal.addElement(Color.black);
        defpal.addElement(Color.blue);
        defpal.addElement(Color.cyan);
        defpal.addElement(Color.gray);
        defpal.addElement(Color.green);
        defpal.addElement(Color.darkGray);
        defpal.addElement(Color.magenta);
        defpal.addElement(Color.orange);
        defpal.addElement(Color.pink);
        defpal.addElement(Color.red);
        defpal.addElement(Color.white);
        defpal.addElement(Color.yellow);
    }
}

