/*
 * Decompiled with CFR 0.152.
 */
import java.util.StringTokenizer;

class RemoteFile {
    static final int DIR = 0;
    static final int TEXT = 1;
    static final int IMAGE = 2;
    static final int BINARY = 3;
    static final int UNKNOWN = 4;
    static final int SYMLINK = 5;
    static final int DEVICE = 6;
    static final int PIPE = 7;
    static final String[] tmap = new String[]{"dir.gif", "text.gif", "image.gif", "binary.gif", "unknown.gif", "symlink.gif", "device.gif", "pipe.gif"};
    FileManager parent;
    String path;
    String name;
    int type;
    String user;
    String group;
    long size;
    int perms;
    long modified;
    String linkto;
    RemoteFile[] list;
    RemoteFile directory;

    RemoteFile(FileManager fileManager, String string, RemoteFile remoteFile) {
        this.parent = fileManager;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        if (stringTokenizer.countTokens() < 7) {
            String string2 = "Invalid file line : " + string;
            new ErrorWindow(string2);
            throw new Error(string2);
        }
        this.path = stringTokenizer.nextToken();
        this.path = FileManager.replace_str(this.path, "\\t", "\t");
        this.path = FileManager.replace_str(this.path, "\\\\", "\\");
        this.type = Integer.parseInt(stringTokenizer.nextToken());
        this.user = stringTokenizer.nextToken();
        this.group = stringTokenizer.nextToken();
        this.size = Long.parseLong(stringTokenizer.nextToken());
        this.perms = Integer.parseInt(stringTokenizer.nextToken());
        this.modified = Long.parseLong(stringTokenizer.nextToken()) * 1000L;
        if (this.type == 5) {
            this.linkto = stringTokenizer.nextToken();
        }
        this.directory = remoteFile;
        this.name = this.path.equals("/") ? "/" : this.path.substring(this.path.lastIndexOf(47) + 1);
    }

    RemoteFile() {
    }

    RemoteFile[] list() {
        if (this.list == null) {
            String[] stringArray = this.parent.get_text("list.cgi?dir=" + FileManager.urlize(this.path));
            if (stringArray[0].length() > 0) {
                new ErrorWindow(this.parent.text("list_edir", this.path, stringArray[0]));
                this.list = null;
            } else {
                this.list = new RemoteFile[stringArray.length - 3];
                for (int i = 3; i < stringArray.length; ++i) {
                    this.list[i - 3] = new RemoteFile(this.parent, stringArray[i], this);
                }
            }
        }
        return this.list;
    }

    RemoteFile find(String string) {
        RemoteFile[] remoteFileArray = this.list();
        if (remoteFileArray != null) {
            for (int i = 0; i < remoteFileArray.length; ++i) {
                if (!remoteFileArray[i].name.equals(string)) continue;
                return remoteFileArray[i];
            }
        }
        return null;
    }

    void add(RemoteFile remoteFile) {
        RemoteFile[] remoteFileArray = new RemoteFile[this.list.length + 1];
        int n = 0;
        for (int i = 0; i < this.list.length; ++i) {
            if (this.list[i].name.compareTo(remoteFile.name) > 0 && n == 0) {
                remoteFileArray[i] = remoteFile;
                ++n;
            }
            remoteFileArray[i + n] = this.list[i];
        }
        if (n == 0) {
            remoteFileArray[this.list.length] = remoteFile;
        }
        this.list = remoteFileArray;
    }

    void delete(RemoteFile remoteFile) {
        RemoteFile[] remoteFileArray = new RemoteFile[this.list.length - 1];
        int n = 0;
        for (int i = 0; i < this.list.length; ++i) {
            if (this.list[i] == remoteFile) continue;
            remoteFileArray[n++] = this.list[i];
        }
        this.list = remoteFileArray;
    }

    boolean shared() {
        return this.type == 0 && (this.parent.stab.get(this.path) != null || this.parent.ntab.get(this.path) != null);
    }

    boolean mountpoint() {
        return this.type == 0 && this.fs() != null;
    }

    boolean mounted() {
        FileSystem fileSystem = this.fs();
        return this.type == 0 && fileSystem != null && fileSystem.mtab;
    }

    FileSystem fs() {
        return (FileSystem)this.parent.mounts.get(this.path);
    }
}

