/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.application.views.overview;

import com.sun.tools.visualvm.application.views.overview.ApplicationOverviewModel;
import com.sun.tools.visualvm.application.views.overview.OverviewViewSupport;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.ui.DataSourceView;
import com.sun.tools.visualvm.core.ui.components.DataViewComponent;
import javax.swing.ImageIcon;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class ApplicationOverviewView
extends DataSourceView {
    private static final String IMAGE_PATH = "com/sun/tools/visualvm/application/views/resources/overview.png";
    private ApplicationOverviewModel model;
    private OverviewViewSupport.SnapshotsViewSupport snapshotsView;

    public ApplicationOverviewView(DataSource dataSource, ApplicationOverviewModel model) {
        super(dataSource, NbBundle.getMessage(ApplicationOverviewView.class, (String)"LBL_Overview"), new ImageIcon(ImageUtilities.loadImage((String)IMAGE_PATH, (boolean)true)).getImage(), 10, false);
        this.model = model;
    }

    protected void willBeAdded() {
        this.model.initialize();
    }

    protected void removed() {
        this.snapshotsView.removed();
    }

    ApplicationOverviewModel getModel() {
        return this.model;
    }

    protected DataViewComponent createComponent() {
        DataViewComponent dvc = new DataViewComponent(new OverviewViewSupport.MasterViewSupport(this.model).getMasterView(), new DataViewComponent.MasterViewConfiguration(false));
        dvc.configureDetailsView(new DataViewComponent.DetailsViewConfiguration(0.25, 0.0, -1.0, -1.0, -1.0, -1.0));
        this.snapshotsView = new OverviewViewSupport.SnapshotsViewSupport(this.model.getSource());
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(ApplicationOverviewView.class, (String)"LBL_Saved_data"), true), 1);
        dvc.addDetailsView(this.snapshotsView.getDetailsView(), 1);
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(ApplicationOverviewView.class, (String)"LBL_Details"), true), 2);
        dvc.addDetailsView(new OverviewViewSupport.JVMArgumentsViewSupport(this.model.getJvmArgs()).getDetailsView(), 2);
        dvc.addDetailsView(new OverviewViewSupport.SystemPropertiesViewSupport(this.model.getSystemProperties()).getDetailsView(), 2);
        return dvc;
    }
}

