/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.actions.Bundle;
import org.netbeans.modules.profiler.actions.ProfilingAwareAction;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;

public final class GetCmdLineArgumentsAction
extends ProfilingAwareAction {
    private static final int[] enabledStates = new int[]{4};

    public GetCmdLineArgumentsAction() {
        this.putValue("Name", Bundle.LBL_GetCmdLineArgumentsAction());
        this.putValue("ShortDescription", Bundle.HINT_GetCmdLineArgumentsAction());
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public void performAction() {
        try {
            String string;
            String string2;
            TargetAppRunner targetAppRunner = Profiler.getDefault().getTargetAppRunner();
            ProfilerClient profilerClient = targetAppRunner.getProfilerClient();
            ProfilingSessionStatus profilingSessionStatus = targetAppRunner.getProfilingSessionStatus();
            ProfilerEngineSettings profilerEngineSettings = targetAppRunner.getProfilerEngineSettings();
            if (!profilerClient.targetJVMIsAlive()) {
                throw new ClientUtils.TargetAppOrVMTerminated(1, Bundle.GetCmdLineArgumentsAction_TargetJvmInactiveMsg());
            }
            if (profilingSessionStatus.runningInAttachedMode) {
                string2 = profilingSessionStatus.jvmArguments;
                string = profilingSessionStatus.javaCommand;
            } else {
                string2 = profilerEngineSettings.getJVMArgsAsSingleString();
                string = profilerEngineSettings.getMainClassName() + " " + profilerEngineSettings.getMainArgsAsSingleString();
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<b>");
            stringBuffer.append(Bundle.GetCmdLineArgumentsAction_JvmArgumentsString());
            stringBuffer.append("</b><br>");
            stringBuffer.append(string2);
            stringBuffer.append("<br><br>");
            stringBuffer.append("<b>");
            stringBuffer.append(Bundle.GetCmdLineArgumentsAction_MainClassAndArgsString());
            stringBuffer.append("</b><br>");
            stringBuffer.append(string);
            HTMLTextArea hTMLTextArea = new HTMLTextArea(stringBuffer.toString());
            hTMLTextArea.getAccessibleContext().setAccessibleName(Bundle.CAPTION_JVMandMainClassCommandLineArguments());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            jPanel.add((Component)new JScrollPane((Component)hTMLTextArea), "Center");
            jPanel.setPreferredSize(new Dimension(600, 200));
            DialogDisplayer.getDefault().createDialog(new DialogDescriptor((Object)jPanel, Bundle.CAPTION_JVMandMainClassCommandLineArguments(), true, new Object[]{DialogDescriptor.CLOSED_OPTION}, DialogDescriptor.CLOSED_OPTION, 0, null, null)).setVisible(true);
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            ProfilerDialogs.displayWarning((String)Bundle.MSG_NotAvailableNow(targetAppOrVMTerminated.getMessage()));
            ProfilerLogger.log((String)targetAppOrVMTerminated.getMessage());
        }
    }

    @Override
    protected int[] enabledStates() {
        return enabledStates;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public String getName() {
        return Bundle.LBL_GetCmdLineArgumentsAction();
    }
}

