/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.panels;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ProjectSelectorPanel
extends JPanel
implements HelpCtx.Provider {
    private static final String HELP_CTX_KEY = "ProjectSelectorPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ProjectSelectorPanel.HelpCtx");
    private List<Lookup.Provider> pool = new ArrayList<Lookup.Provider>();
    private List<Lookup.Provider> selection = new ArrayList<Lookup.Provider>();
    private AbstractListModel selectionModel = new AbstractListModel(){

        @Override
        public int getSize() {
            return ProjectSelectorPanel.this.selection.size();
        }

        @Override
        public Object getElementAt(int n) {
            return ProjectSelectorPanel.this.selection.get(n);
        }
    };
    private AbstractListModel poolModel = new AbstractListModel(){

        @Override
        public int getSize() {
            return ProjectSelectorPanel.this.pool.size();
        }

        @Override
        public Object getElementAt(int n) {
            return ProjectSelectorPanel.this.pool.get(n);
        }
    };
    private final Action selectProjectAction = new AbstractAction("selectProject"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ProjectSelectorPanel.this.projectList.getModel().getSize() == 0) {
                return;
            }
            Object[] objectArray = ProjectSelectorPanel.this.projectList.getSelectedValues();
            Lookup.Provider[] providerArray = new Lookup.Provider[objectArray.length];
            System.arraycopy(objectArray, 0, providerArray, 0, objectArray.length);
            ProjectSelectorPanel.this.selectProjects(providerArray);
        }
    };
    private final Action unselectProjectAction = new AbstractAction("unselectProject"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ProjectSelectorPanel.this.selectionList.getModel().getSize() == 0) {
                return;
            }
            Object[] objectArray = ProjectSelectorPanel.this.selectionList.getSelectedValues();
            Lookup.Provider[] providerArray = new Lookup.Provider[objectArray.length];
            System.arraycopy(objectArray, 0, providerArray, 0, objectArray.length);
            ProjectSelectorPanel.this.unselectProjects(providerArray);
        }
    };
    private JButton addButton;
    private JLabel jLabel1;
    private JLabel lblAvailable;
    private JLabel lblSelected;
    private JList projectList;
    private JButton removeButton;
    private JScrollPane scroller;
    private JScrollPane scroller1;
    private JList selectionList;

    public ProjectSelectorPanel() {
        this.initComponents();
        this.postInit();
        this.loadPool();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    private void initComponents() {
        this.lblAvailable = new JLabel();
        this.scroller = new JScrollPane();
        this.projectList = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.lblSelected = new JLabel();
        this.scroller1 = new JScrollPane();
        this.selectionList = new JList();
        this.jLabel1 = new JLabel();
        this.lblAvailable.setDisplayedMnemonic('A');
        this.lblAvailable.setLabelFor(this.scroller);
        this.lblAvailable.setText(NbBundle.getMessage(ProjectSelectorPanel.class, (String)"ProjectSelectorPanel.lblAvailable.text"));
        this.projectList.setModel(this.poolModel);
        this.projectList.setVisibleRowCount(13);
        this.projectList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ProjectSelectorPanel.this.projectListMouseClicked(mouseEvent);
            }
        });
        this.scroller.setViewportView(this.projectList);
        this.addButton.setAction(this.selectProjectAction);
        this.addButton.setText(NbBundle.getMessage(ProjectSelectorPanel.class, (String)"ProjectSelectorPanel.addButton.text"));
        this.addButton.setToolTipText(NbBundle.getMessage(ProjectSelectorPanel.class, (String)"ProjectSelectorPanel.addButton.toolTipText"));
        this.addButton.setMargin(new Insets(2, 8, 2, 8));
        this.removeButton.setAction(this.unselectProjectAction);
        this.removeButton.setText(NbBundle.getMessage(ProjectSelectorPanel.class, (String)"ProjectSelectorPanel.removeButton.text"));
        this.removeButton.setToolTipText(NbBundle.getMessage(ProjectSelectorPanel.class, (String)"ProjectSelectorPanel.removeButton.toolTipText"));
        this.removeButton.setActionCommand(NbBundle.getMessage(ProjectSelectorPanel.class, (String)"ProjectSelectorPanel.removeButton.actionCommand"));
        this.removeButton.setMargin(new Insets(2, 8, 2, 8));
        this.lblSelected.setDisplayedMnemonic('S');
        this.lblSelected.setLabelFor(this.scroller1);
        this.lblSelected.setText(NbBundle.getMessage(ProjectSelectorPanel.class, (String)"ProjectSelectorPanel.lblSelected.text"));
        this.selectionList.setModel(this.selectionModel);
        this.selectionList.setVisibleRowCount(13);
        this.selectionList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ProjectSelectorPanel.this.selectionListMouseClicked(mouseEvent);
            }
        });
        this.scroller1.setViewportView(this.selectionList);
        this.jLabel1.setForeground(UIManager.getDefaults().getColor("Button.shadow"));
        this.jLabel1.setText(NbBundle.getMessage(ProjectSelectorPanel.class, (String)"ProjectSelectorPanel.jLabel1.text"));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.scroller, -1, 190, Short.MAX_VALUE).addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addButton).addComponent(this.removeButton)).addGap(6, 6, 6)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.lblAvailable).addGap(125, 125, 125))).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.lblSelected).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addComponent(this.scroller1, -1, 190, Short.MAX_VALUE).addGap(13, 13, 13)))).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblAvailable).addComponent(this.lblSelected)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.addButton, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton, -1, -1, Short.MAX_VALUE)).addComponent(this.scroller).addComponent(this.scroller1)).addGap(10, 10, 10).addComponent(this.jLabel1).addContainerGap()));
    }

    private void projectListMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
            this.selectProjectAction.actionPerformed(new ActionEvent(mouseEvent.getSource(), 1001, "selectProject"));
        }
    }

    private void selectionListMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
            this.unselectProjectAction.actionPerformed(new ActionEvent(mouseEvent.getSource(), 1001, "unselectProject"));
        }
    }

    private void loadPool() {
        Lookup.Provider[] providerArray = ProjectUtilities.getOpenedProjects();
        Lookup.Provider provider = this.getCurrentProject();
        if (provider != null && providerArray != null) {
            Lookup.Provider[] providerArray2 = new Lookup.Provider[providerArray.length - 1];
            int n = 0;
            for (int i = 0; i < providerArray.length; ++i) {
                if (providerArray[i].equals(provider)) continue;
                providerArray2[n++] = providerArray[i];
            }
            providerArray = providerArray2;
        }
        this.pool.addAll(Arrays.asList(providerArray));
    }

    private void selectProjects(Lookup.Provider ... providerArray) {
        this.addProjects(this.selectionModel, this.selection, providerArray);
        this.removeProjects(this.poolModel, this.pool, providerArray);
    }

    private void unselectProjects(Lookup.Provider ... providerArray) {
        this.addProjects(this.poolModel, this.pool, providerArray);
        this.removeProjects(this.selectionModel, this.selection, providerArray);
    }

    private void addProjects(AbstractListModel abstractListModel, List<Lookup.Provider> list, Lookup.Provider ... providerArray) {
        list.addAll(Arrays.asList(providerArray));
        ListDataListener[] listDataListenerArray = abstractListModel.getListDataListeners();
        if (listDataListenerArray.length == 0) {
            return;
        }
        ListDataEvent listDataEvent = new ListDataEvent(this, 1, list.size() - providerArray.length, list.size());
        for (ListDataListener listDataListener : abstractListModel.getListDataListeners()) {
            listDataListener.intervalAdded(listDataEvent);
        }
    }

    private void removeProjects(AbstractListModel abstractListModel, List<Lookup.Provider> list, Lookup.Provider ... providerArray) {
        list.removeAll(Arrays.asList(providerArray));
        ListDataListener[] listDataListenerArray = abstractListModel.getListDataListeners();
        if (listDataListenerArray.length == 0) {
            return;
        }
        ListDataEvent listDataEvent = new ListDataEvent(this, 2, list.size(), list.size() + providerArray.length);
        for (ListDataListener listDataListener : listDataListenerArray) {
            listDataListener.intervalRemoved(listDataEvent);
        }
    }

    public void setSelection(List<Lookup.Provider> list) {
        this.selection.clear();
        this.selection.addAll(list);
        int n = this.pool.size();
        this.pool.removeAll(list);
        for (ListDataListener listDataListener : this.selectionModel.getListDataListeners()) {
            listDataListener.contentsChanged(new ListDataEvent(this, 1, 0, this.selection.size()));
        }
        for (ListDataListener listDataListener : this.poolModel.getListDataListeners()) {
            listDataListener.contentsChanged(new ListDataEvent(this, 2, 0, n));
            listDataListener.contentsChanged(new ListDataEvent(this, 1, 0, this.pool.size()));
        }
    }

    public List<Lookup.Provider> getSelection() {
        return new ArrayList<Lookup.Provider>(this.selection);
    }

    protected Lookup.Provider getCurrentProject() {
        return null;
    }

    private void postInit() {
        final ListCellRenderer listCellRenderer = this.projectList.getCellRenderer();
        ListCellRenderer listCellRenderer2 = new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = listCellRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
                if (component instanceof JLabel) {
                    ((JLabel)component).setText(ProjectUtilities.getDisplayName((Lookup.Provider)((Lookup.Provider)object)));
                    ((JLabel)component).setIcon(ProjectUtilities.getIcon((Lookup.Provider)((Lookup.Provider)object)));
                }
                return component;
            }
        };
        this.projectList.setCellRenderer(listCellRenderer2);
        this.selectionList.setCellRenderer(listCellRenderer2);
        this.projectList.getActionMap().put("selectProject", this.selectProjectAction);
        this.selectionList.getActionMap().put("unselectProject", this.unselectProjectAction);
        this.projectList.getInputMap().put(KeyStroke.getKeyStroke("SPACE"), "selectProject");
        this.selectionList.getInputMap().put(KeyStroke.getKeyStroke("SPACE"), "unselectProject");
    }
}

