/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.modules.autoupdate.updateprovider.AutoupdateCatalogCache;
import org.netbeans.modules.autoupdate.updateprovider.AutoupdateCatalogParser;
import org.netbeans.modules.autoupdate.updateprovider.ProviderCategory;
import org.netbeans.spi.autoupdate.UpdateItem;
import org.netbeans.spi.autoupdate.UpdateProvider;
import org.openide.util.Parameters;

public class AutoupdateCatalogProvider
implements UpdateProvider {
    private URL updateCenter;
    private final String codeName;
    private String displayName;
    private AutoupdateCatalogCache cache = AutoupdateCatalogCache.getDefault();
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.autoupdate.updateprovider.AutoupdateCatalog");
    private String description;
    private boolean descriptionInitialized;
    private ProviderCategory category;
    private String contentDescription;
    private boolean contentDescriptionInitialized;

    public AutoupdateCatalogProvider(String string, String string2, URL uRL) {
        this(string, string2, uRL, ProviderCategory.forValue(UpdateUnitProvider.CATEGORY.COMMUNITY));
    }

    public AutoupdateCatalogProvider(String string, String string2, URL uRL, ProviderCategory providerCategory) {
        Parameters.notNull((CharSequence)"name", (Object)string);
        this.codeName = string;
        this.displayName = string2;
        this.updateCenter = uRL;
        this.category = providerCategory;
    }

    public AutoupdateCatalogProvider(String string, String string2, URL uRL, UpdateUnitProvider.CATEGORY cATEGORY) {
        this(string, string2, uRL, ProviderCategory.forValue(cATEGORY));
    }

    @Override
    public String getName() {
        return this.codeName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName == null ? this.codeName : this.displayName;
    }

    @Override
    public String getDescription() {
        if (this.description == null && !this.descriptionInitialized) {
            try {
                this.getUpdateItems();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.description;
    }

    public void setNotification(String string) {
        this.description = string;
        this.descriptionInitialized = true;
    }

    public String getContentDescription() {
        if (this.contentDescription == null && !this.contentDescriptionInitialized) {
            try {
                this.getUpdateItems();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.contentDescription;
    }

    public void setContentDescription(String string) {
        this.contentDescription = string;
        this.contentDescriptionInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, UpdateItem> getUpdateItems() throws IOException {
        Map<String, UpdateItem> map;
        URL uRL = this.cache.getCatalogURL(this.codeName);
        if (uRL == null) {
            LOG.log(Level.FINE, "No content in cache for {0} provider. Returns EMPTY_MAP", this.codeName);
            return Collections.emptyMap();
        }
        String string = this.cache.getLock(uRL);
        synchronized (string) {
            map = AutoupdateCatalogParser.getUpdateItems(uRL, this);
        }
        this.descriptionInitialized = true;
        return map;
    }

    @Override
    public boolean refresh(boolean bl) throws IOException {
        boolean bl2;
        LOG.log(Level.FINER, "Try write(force? {0}) to cache Update Provider {1} from {2}", new Object[]{bl, this.codeName, this.getUpdateCenterURL()});
        if (bl) {
            bl2 = this.cache.writeCatalogToCache(this.codeName, this.getUpdateCenterURL()) != null;
            this.description = null;
            this.descriptionInitialized = false;
        } else {
            bl2 = true;
        }
        return bl2;
    }

    public URL getUpdateCenterURL() {
        assert (this.updateCenter != null) : "XMLCatalogUpdatesProvider " + this.codeName + " must have a URL to Update Center";
        return this.updateCenter;
    }

    public void setUpdateCenterURL(URL uRL) {
        assert (uRL != null);
        this.updateCenter = uRL;
    }

    public String toString() {
        return this.displayName + "[" + this.codeName + "] to " + this.updateCenter;
    }

    @Override
    public UpdateUnitProvider.CATEGORY getCategory() {
        return this.category.toEnum();
    }

    public ProviderCategory getProviderCategory() {
        return this.category;
    }
}

