/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.Link;
import com.ericsson.otp.erlang.OtpErlangPid;

class Links {
    Link[] links;
    int count;

    Links() {
        this(10);
    }

    Links(int n) {
        this.links = new Link[n];
        this.count = 0;
    }

    synchronized void addLink(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2) {
        if (this.find(otpErlangPid, otpErlangPid2) == -1) {
            if (this.count >= this.links.length) {
                Link[] linkArray = new Link[this.count * 2];
                System.arraycopy(this.links, 0, linkArray, 0, this.count);
                this.links = linkArray;
            }
            this.links[this.count++] = new Link(otpErlangPid, otpErlangPid2);
        }
    }

    synchronized void removeLink(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2) {
        int n = this.find(otpErlangPid, otpErlangPid2);
        if (n != -1) {
            --this.count;
            this.links[n] = this.links[this.count];
            this.links[this.count] = null;
        }
    }

    synchronized boolean exists(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2) {
        return this.find(otpErlangPid, otpErlangPid2) != -1;
    }

    synchronized int find(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.links[i].equals(otpErlangPid, otpErlangPid2)) continue;
            return i;
        }
        return -1;
    }

    int count() {
        return this.count;
    }

    synchronized OtpErlangPid[] localPids() {
        OtpErlangPid[] otpErlangPidArray = null;
        if (this.count != 0) {
            otpErlangPidArray = new OtpErlangPid[this.count];
            for (int i = 0; i < this.count; ++i) {
                otpErlangPidArray[i] = this.links[i].local();
            }
        }
        return otpErlangPidArray;
    }

    synchronized OtpErlangPid[] remotePids() {
        OtpErlangPid[] otpErlangPidArray = null;
        if (this.count != 0) {
            otpErlangPidArray = new OtpErlangPid[this.count];
            for (int i = 0; i < this.count; ++i) {
                otpErlangPidArray[i] = this.links[i].remote();
            }
        }
        return otpErlangPidArray;
    }

    synchronized Link[] clearLinks() {
        Link[] linkArray = null;
        if (this.count != 0) {
            linkArray = new Link[this.count];
            for (int i = 0; i < this.count; ++i) {
                linkArray[i] = this.links[i];
                this.links[i] = null;
            }
            this.count = 0;
        }
        return linkArray;
    }

    synchronized Link[] links() {
        Link[] linkArray = null;
        if (this.count != 0) {
            linkArray = new Link[this.count];
            System.arraycopy(this.links, 0, linkArray, 0, this.count);
        }
        return linkArray;
    }
}

