/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.painterpack.fill;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.colorschemepack.MixColorScheme;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class MixDelegateFillPainter
implements SubstanceFillPainter {
    protected String painterName;
    protected SubstanceFillPainter delegate;

    public MixDelegateFillPainter(String painterName, SubstanceFillPainter delegate) {
        this.painterName = painterName;
        this.delegate = delegate;
    }

    public String getDisplayName() {
        return this.painterName;
    }

    public void paintContourBackground(Graphics g, Component comp, int width, int height, Shape contour, boolean isFocused, SubstanceColorScheme fillScheme, boolean hasShine) {
        if (fillScheme instanceof MixColorScheme) {
            MixColorScheme mixColorScheme = (MixColorScheme)fillScheme;
            SubstanceColorScheme[] origSchemes = mixColorScheme.getOrigSchemes();
            BufferedImage[] components = new BufferedImage[origSchemes.length];
            for (int i = 0; i < origSchemes.length; ++i) {
                components[i] = SubstanceCoreUtilities.getBlankImage((int)width, (int)height);
                Graphics2D g2d = components[i].createGraphics();
                this.delegate.paintContourBackground((Graphics)g2d, comp, width, height, contour, isFocused, origSchemes[i], hasShine);
                g2d.dispose();
            }
            BufferedImage current = components[0];
            for (int i = 1; i < components.length; ++i) {
                double start = ((double)i - 0.3) / (double)components.length;
                double end = ((double)i + 0.3) / (double)components.length;
                current = SubstanceCoreUtilities.blendImagesHorizontal((BufferedImage)current, (BufferedImage)components[i], (double)start, (double)end);
            }
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.drawImage((Image)current, 0, 0, null);
            g2d.dispose();
            return;
        }
        this.delegate.paintContourBackground(g, comp, width, height, contour, isFocused, fillScheme, hasShine);
    }
}

