/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.el;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import org.jdesktop.el.ELContext;
import org.jdesktop.el.ELResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeELResolver
extends ELResolver {
    private final ArrayList<ELResolver> elResolvers = new ArrayList();

    public void add(ELResolver elResolver) {
        if (elResolver == null) {
            throw new NullPointerException();
        }
        this.elResolvers.add(elResolver);
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        context.setPropertyResolved(false);
        int len = this.elResolvers.size();
        for (int i = 0; i < len; ++i) {
            ELResolver elResolver = this.elResolvers.get(i);
            Object value = elResolver.getValue(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return value;
        }
        return ELContext.UNRESOLVABLE_RESULT;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        context.setPropertyResolved(false);
        int len = this.elResolvers.size();
        for (int i = 0; i < len; ++i) {
            ELResolver elResolver = this.elResolvers.get(i);
            Class<?> type = elResolver.getType(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return type;
        }
        return null;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object val) {
        context.setPropertyResolved(false);
        int len = this.elResolvers.size();
        for (int i = 0; i < len; ++i) {
            ELResolver elResolver = this.elResolvers.get(i);
            elResolver.setValue(context, base, property, val);
            if (!context.isPropertyResolved()) continue;
            return;
        }
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        context.setPropertyResolved(false);
        int len = this.elResolvers.size();
        for (int i = 0; i < len; ++i) {
            ELResolver elResolver = this.elResolvers.get(i);
            boolean readOnly = elResolver.isReadOnly(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return readOnly;
        }
        return false;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return new CompositeIterator(this.elResolvers.iterator(), context, base);
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        Class<?> commonPropertyType = null;
        for (ELResolver elResolver : this.elResolvers) {
            Class<?> type = elResolver.getCommonPropertyType(context, base);
            if (type == null) continue;
            if (commonPropertyType == null) {
                commonPropertyType = type;
                continue;
            }
            if (commonPropertyType.isAssignableFrom(type)) continue;
            if (type.isAssignableFrom(commonPropertyType)) {
                commonPropertyType = type;
                continue;
            }
            return null;
        }
        return commonPropertyType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositeIterator
    implements Iterator<FeatureDescriptor> {
        Iterator<ELResolver> compositeIter;
        Iterator<FeatureDescriptor> propertyIter;
        ELContext context;
        Object base;

        CompositeIterator(Iterator<ELResolver> iter, ELContext context, Object base) {
            this.compositeIter = iter;
            this.context = context;
            this.base = base;
        }

        @Override
        public boolean hasNext() {
            if (this.propertyIter == null || !this.propertyIter.hasNext()) {
                while (this.compositeIter.hasNext()) {
                    ELResolver elResolver = this.compositeIter.next();
                    this.propertyIter = elResolver.getFeatureDescriptors(this.context, this.base);
                    if (this.propertyIter == null) continue;
                    return this.propertyIter.hasNext();
                }
                return false;
            }
            return this.propertyIter.hasNext();
        }

        @Override
        public FeatureDescriptor next() {
            if (this.propertyIter == null || !this.propertyIter.hasNext()) {
                while (this.compositeIter.hasNext()) {
                    ELResolver elResolver = this.compositeIter.next();
                    this.propertyIter = elResolver.getFeatureDescriptors(this.context, this.base);
                    if (this.propertyIter == null) continue;
                    return this.propertyIter.next();
                }
                return null;
            }
            return this.propertyIter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

