/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import java.io.File;
import org.apache.tools.ant.Task;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.dsl.ArtifactFile;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.internal.artifacts.publish.DecoratingPublishArtifact;
import org.gradle.api.internal.artifacts.publish.DefaultPublishArtifact;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.internal.Factory;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.MapKey;
import org.gradle.internal.typeconversion.MapNotationConverter;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypedNotationConverter;

public class PublishArtifactNotationParserFactory
implements Factory<NotationParser<Object, ConfigurablePublishArtifact>> {
    private final Instantiator instantiator;
    private final DependencyMetaDataProvider metaDataProvider;

    public PublishArtifactNotationParserFactory(Instantiator instantiator, DependencyMetaDataProvider metaDataProvider) {
        this.instantiator = instantiator;
        this.metaDataProvider = metaDataProvider;
    }

    public NotationParser<Object, ConfigurablePublishArtifact> create() {
        FileNotationConverter fileConverter = new FileNotationConverter();
        return NotationParserBuilder.toType(ConfigurablePublishArtifact.class).converter((NotationConverter)new DecoratingConverter()).converter((NotationConverter)new ArchiveTaskNotationConverter()).converter((NotationConverter)new FileMapNotationConverter(fileConverter)).converter((NotationConverter)fileConverter).toComposite();
    }

    private class FileNotationConverter
    extends TypedNotationConverter<File, ConfigurablePublishArtifact> {
        private FileNotationConverter() {
            super(File.class);
        }

        protected ConfigurablePublishArtifact parseType(File file) {
            Module module = PublishArtifactNotationParserFactory.this.metaDataProvider.getModule();
            ArtifactFile artifactFile = new ArtifactFile(file, module.getVersion());
            return (ConfigurablePublishArtifact)PublishArtifactNotationParserFactory.this.instantiator.newInstance(DefaultPublishArtifact.class, new Object[]{artifactFile.getName(), artifactFile.getExtension(), artifactFile.getExtension(), artifactFile.getClassifier(), null, file, new Task[0]});
        }
    }

    private class FileMapNotationConverter
    extends MapNotationConverter<ConfigurablePublishArtifact> {
        private final FileNotationConverter fileConverter;

        private FileMapNotationConverter(FileNotationConverter fileConverter) {
            this.fileConverter = fileConverter;
        }

        protected PublishArtifact parseMap(@MapKey(value="file") File file) {
            return this.fileConverter.parseType(file);
        }
    }

    private class ArchiveTaskNotationConverter
    extends TypedNotationConverter<AbstractArchiveTask, ConfigurablePublishArtifact> {
        private ArchiveTaskNotationConverter() {
            super(AbstractArchiveTask.class);
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Instances of AbstractArchiveTask").example("jar");
        }

        protected ConfigurablePublishArtifact parseType(AbstractArchiveTask notation) {
            return (ConfigurablePublishArtifact)PublishArtifactNotationParserFactory.this.instantiator.newInstance(ArchivePublishArtifact.class, new Object[]{notation});
        }
    }

    private class DecoratingConverter
    extends TypedNotationConverter<PublishArtifact, ConfigurablePublishArtifact> {
        private DecoratingConverter() {
            super(PublishArtifact.class);
        }

        protected ConfigurablePublishArtifact parseType(PublishArtifact notation) {
            return (ConfigurablePublishArtifact)PublishArtifactNotationParserFactory.this.instantiator.newInstance(DecoratingPublishArtifact.class, new Object[]{notation});
        }
    }
}

