/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.DefaultUnresolvedDependency;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DependencyArtifactsVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphPathResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.ResolvedConfigurationBuilder;
import org.gradle.internal.resolve.ModuleVersionResolveException;

public class ResolvedConfigurationDependencyGraphVisitor
implements DependencyGraphVisitor,
DependencyArtifactsVisitor {
    private final ResolvedConfigurationBuilder builder;
    private final Map<ModuleVersionSelector, BrokenDependency> failuresByRevisionId = new LinkedHashMap<ModuleVersionSelector, BrokenDependency>();
    private DependencyGraphNode root;

    public ResolvedConfigurationDependencyGraphVisitor(ResolvedConfigurationBuilder builder) {
        this.builder = builder;
    }

    @Override
    public void start(DependencyGraphNode root) {
        this.root = root;
    }

    @Override
    public void visitNode(DependencyGraphNode resolvedConfiguration) {
        this.builder.newResolvedDependency(resolvedConfiguration);
        for (DependencyGraphEdge dependencyGraphEdge : resolvedConfiguration.getOutgoingEdges()) {
            ModuleVersionResolveException failure = dependencyGraphEdge.getFailure();
            if (failure == null) continue;
            this.addUnresolvedDependency(dependencyGraphEdge, dependencyGraphEdge.getRequestedModuleVersion(), failure);
        }
    }

    @Override
    public void visitEdge(DependencyGraphNode resolvedConfiguration) {
        for (DependencyGraphEdge dependencyGraphEdge : resolvedConfiguration.getIncomingEdges()) {
            if (dependencyGraphEdge.getFrom() != this.root) continue;
            ModuleDependency moduleDependency = dependencyGraphEdge.getModuleDependency();
            this.builder.addFirstLevelDependency(moduleDependency, resolvedConfiguration);
        }
    }

    @Override
    public void visitArtifacts(DependencyGraphNode from, DependencyGraphNode to, ArtifactSet artifacts) {
        this.builder.addChild(from, to, artifacts.getId());
    }

    @Override
    public void finish(DependencyGraphNode root) {
        this.attachFailures(this.builder);
        this.builder.done(root);
    }

    @Override
    public void finishArtifacts() {
    }

    private void attachFailures(ResolvedConfigurationBuilder result) {
        for (Map.Entry<ModuleVersionSelector, BrokenDependency> entry : this.failuresByRevisionId.entrySet()) {
            Collection<List<ComponentIdentifier>> paths = DependencyGraphPathResolver.calculatePaths(entry.getValue().requiredBy, this.root);
            result.addUnresolvedDependency(new DefaultUnresolvedDependency(entry.getKey(), (Throwable)((Object)entry.getValue().failure.withIncomingPaths(paths))));
        }
    }

    private void addUnresolvedDependency(DependencyGraphEdge dependency, ModuleVersionSelector requested, ModuleVersionResolveException failure) {
        BrokenDependency breakage = this.failuresByRevisionId.get(requested);
        if (breakage == null) {
            breakage = new BrokenDependency(failure);
            this.failuresByRevisionId.put(requested, breakage);
        }
        breakage.requiredBy.add(dependency.getFrom());
    }

    private static class BrokenDependency {
        final ModuleVersionResolveException failure;
        final List<DependencyGraphNode> requiredBy = new ArrayList<DependencyGraphNode>();

        private BrokenDependency(ModuleVersionResolveException failure) {
            this.failure = failure;
        }
    }
}

