/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import org.gradle.api.internal.GradleInternal;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.progress.BuildOperationInternal;
import org.gradle.internal.progress.InternalBuildListener;
import org.gradle.internal.progress.OperationResult;
import org.gradle.internal.progress.OperationStartEvent;
import org.gradle.tooling.internal.provider.BuildClientSubscriptions;
import org.gradle.tooling.internal.provider.SubscribableBuildAction;
import org.gradle.tooling.internal.provider.runner.ClientForwardingBuildListener;
import org.gradle.tooling.internal.provider.runner.ClientForwardingTaskListener;
import org.gradle.tooling.internal.provider.runner.ClientForwardingTestListener;

public class SubscribableBuildActionRunner
implements BuildActionRunner {
    private static final InternalBuildListener NO_OP = new InternalBuildListener(){

        public void started(BuildOperationInternal buildOperation, OperationStartEvent startEvent) {
        }

        public void finished(BuildOperationInternal buildOperation, OperationResult finishEvent) {
        }
    };
    private final BuildActionRunner delegate;

    public SubscribableBuildActionRunner(BuildActionRunner delegate) {
        this.delegate = delegate;
    }

    private void registerListenersForClientSubscriptions(BuildClientSubscriptions clientSubscriptions, GradleInternal gradle, BuildController buildController) {
        BuildEventConsumer eventConsumer = (BuildEventConsumer)gradle.getServices().get(BuildEventConsumer.class);
        if (clientSubscriptions.isSendTestProgressEvents()) {
            buildController.addNestedListener((Object)new ClientForwardingTestListener(eventConsumer, clientSubscriptions));
        }
        if (!clientSubscriptions.isSendBuildProgressEvents() && !clientSubscriptions.isSendTaskProgressEvents()) {
            return;
        }
        InternalBuildListener buildListener = NO_OP;
        if (clientSubscriptions.isSendBuildProgressEvents()) {
            buildListener = new ClientForwardingBuildListener(eventConsumer);
        }
        buildListener = new ClientForwardingTaskListener(eventConsumer, clientSubscriptions, buildListener);
        buildController.addNestedListener((Object)buildListener);
    }

    public void run(BuildAction action, BuildController buildController) {
        if (!(action instanceof SubscribableBuildAction)) {
            return;
        }
        GradleInternal gradle = buildController.getGradle();
        SubscribableBuildAction subscribableBuildAction = (SubscribableBuildAction)action;
        this.registerListenersForClientSubscriptions(subscribableBuildAction.getClientSubscriptions(), gradle, buildController);
        this.delegate.run(action, buildController);
    }
}

