/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport.connect;

import java.io.IOException;
import java.net.SocketAddress;
import javax.net.ssl.SSLContext;
import org.simpleframework.http.core.Container;
import org.simpleframework.http.core.ContainerServer;
import org.simpleframework.transport.Server;
import org.simpleframework.transport.connect.Connection;
import org.simpleframework.transport.connect.ConnectionException;
import org.simpleframework.transport.connect.ListenerManager;

public class SocketConnection
implements Connection {
    private ListenerManager manager;
    private Server server;
    private boolean closed;

    public SocketConnection(Server server) throws IOException {
        this.manager = new ListenerManager(server);
        this.server = server;
    }

    public SocketConnection(Container container) throws IOException {
        this(new ContainerServer(container));
    }

    public SocketAddress connect(SocketAddress address) throws IOException {
        if (this.closed) {
            throw new ConnectionException("Connection is closed");
        }
        return this.manager.listen(address);
    }

    public SocketAddress connect(SocketAddress address, SSLContext context) throws IOException {
        if (this.closed) {
            throw new ConnectionException("Connection is closed");
        }
        return this.manager.listen(address, context);
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.manager.close();
            this.server.stop();
        }
        this.closed = true;
    }
}

