/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.internal.attributes.DefaultAttributeMatchingStrategy;
import org.gradle.internal.Cast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAttributesSchema
implements AttributesSchema {
    private final Map<Attribute<?>, AttributeMatchingStrategy<?>> strategies = Maps.newHashMap();

    @Override
    public <T> AttributeMatchingStrategy<T> getMatchingStrategy(Attribute<T> attribute) {
        AttributeMatchingStrategy<?> strategy = this.strategies.get(attribute);
        if (strategy == null) {
            throw new IllegalArgumentException("Unable to find matching strategy for " + attribute);
        }
        return (AttributeMatchingStrategy)Cast.uncheckedCast(strategy);
    }

    @Override
    public <T> AttributeMatchingStrategy<T> attribute(Attribute<T> attribute) {
        return this.attribute(attribute, null);
    }

    @Override
    public <T> AttributeMatchingStrategy<T> attribute(Attribute<T> attribute, Action<? super AttributeMatchingStrategy<T>> configureAction) {
        DefaultAttributeMatchingStrategy strategy = (DefaultAttributeMatchingStrategy)Cast.uncheckedCast(this.strategies.get(attribute));
        if (strategy == null) {
            strategy = new DefaultAttributeMatchingStrategy();
            this.strategies.put(attribute, strategy);
        }
        if (configureAction != null) {
            configureAction.execute(strategy);
        }
        return strategy;
    }

    @Override
    public Set<Attribute<?>> getAttributes() {
        return this.strategies.keySet();
    }

    @Override
    public boolean hasAttribute(Attribute<?> key) {
        return this.strategies.containsKey(key);
    }
}

