/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.internal.PropertiesUtils;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
@CacheableTask
@ParallelizableTask
public class WriteProperties
extends DefaultTask {
    private Properties properties = new Properties();
    private String lineSeparator = "\n";
    private Object outputFile;
    private String comment;
    private String encoding = "ISO_8859_1";

    @Input
    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Map<?, ?> properties) {
        this.properties.clear();
        this.properties.putAll(properties);
    }

    @Input
    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    @Input
    @Optional
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Input
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @OutputFile
    public File getOutputFile() {
        return this.getProject().file(this.outputFile);
    }

    public void setOutputFile(Object outputFile) {
        this.outputFile = outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void writeProperties() throws IOException {
        Charset charset = Charset.forName(this.getEncoding());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.getOutputFile()));
        try {
            PropertiesUtils.store(this.getProperties(), out, this.getComment(), charset, this.getLineSeparator());
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }
}

