/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncCacheAccessContext {
    private static final ThreadLocal<AsyncCacheAccessContext> CONTEXT_THREAD_LOCAL = new ThreadLocal();
    private final Map<String, Object> contextMap;

    public static AsyncCacheAccessContext current() {
        return CONTEXT_THREAD_LOCAL.get();
    }

    public static boolean createWhenMissing() {
        if (AsyncCacheAccessContext.current() != null) {
            return false;
        }
        AsyncCacheAccessContext context = new AsyncCacheAccessContext();
        CONTEXT_THREAD_LOCAL.set(context);
        return true;
    }

    public static void apply(AsyncCacheAccessContext context) {
        CONTEXT_THREAD_LOCAL.set(context);
    }

    public static void remove() {
        CONTEXT_THREAD_LOCAL.remove();
    }

    public static String createKey(Class<?> ownerClass, String name) {
        return ownerClass.getName() + "." + name;
    }

    private AsyncCacheAccessContext() {
        this(new HashMap<String, Object>());
    }

    private AsyncCacheAccessContext(HashMap<String, Object> contextMap) {
        this.contextMap = contextMap;
    }

    public void put(String key, Object value) {
        this.contextMap.put(key, value);
    }

    public <T> T get(String key, Class<T> type) {
        return type.cast(this.contextMap.get(key));
    }

    public void remove(String key) {
        this.contextMap.remove(key);
    }

    public static AsyncCacheAccessContext copyOfCurrent() {
        AsyncCacheAccessContext current = AsyncCacheAccessContext.current();
        if (current == null) {
            return null;
        }
        return current.copy();
    }

    private AsyncCacheAccessContext copy() {
        return new AsyncCacheAccessContext(new HashMap<String, Object>(this.contextMap));
    }
}

