/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.concurrent.locks.Lock;
import org.gradle.api.Action;
import org.gradle.cache.internal.AbstractCrossProcessCacheAccess;
import org.gradle.cache.internal.CacheInitializationAction;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.filelock.LockOptions;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LockOnDemandCrossProcessCacheAccess
extends AbstractCrossProcessCacheAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(LockOnDemandCrossProcessCacheAccess.class);
    private final String cacheDisplayName;
    private final File lockTarget;
    private final LockOptions lockOptions;
    private final FileLockManager lockManager;
    private final Lock stateLock;
    private final Action<FileLock> onOpen;
    private final Action<FileLock> onClose;
    private int lockCount;
    private FileLock fileLock;
    private CacheInitializationAction initAction;

    public LockOnDemandCrossProcessCacheAccess(String cacheDisplayName, File lockTarget, LockOptions lockOptions, FileLockManager lockManager, Lock stateLock, CacheInitializationAction initAction, Action<FileLock> onOpen, Action<FileLock> onClose) {
        this.cacheDisplayName = cacheDisplayName;
        this.lockTarget = lockTarget;
        this.lockOptions = lockOptions;
        this.lockManager = lockManager;
        this.stateLock = stateLock;
        this.initAction = initAction;
        this.onOpen = onOpen;
        this.onClose = onClose;
    }

    @Override
    public void open() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.stateLock.lock();
        try {
            if (this.lockCount != 0) {
                throw new IllegalStateException(String.format("Cannot close cache access for %s as it is currently in use for %s operations.", this.cacheDisplayName, this.lockCount));
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withFileLock(Factory<T> factory) {
        this.incrementLockCount();
        try {
            Object object = factory.create();
            return (T)object;
        }
        finally {
            this.decrementLockCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementLockCount() {
        this.stateLock.lock();
        try {
            if (this.lockCount == 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Acquiring file lock for {}", (Object)this.cacheDisplayName);
                }
                this.fileLock = this.lockManager.lock(this.lockTarget, this.lockOptions, this.cacheDisplayName);
                try {
                    if (this.initAction.requiresInitialization(this.fileLock)) {
                        this.fileLock.writeFile(new Runnable(){

                            public void run() {
                                LockOnDemandCrossProcessCacheAccess.this.initAction.initialize(LockOnDemandCrossProcessCacheAccess.this.fileLock);
                            }
                        });
                    }
                    this.onOpen.execute((Object)this.fileLock);
                }
                catch (Exception e) {
                    this.fileLock.close();
                    this.fileLock = null;
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            ++this.lockCount;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementLockCount() {
        this.stateLock.lock();
        try {
            --this.lockCount;
            if (this.lockCount == 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Releasing file lock for {}", (Object)this.cacheDisplayName);
                }
                this.onClose.execute((Object)this.fileLock);
                this.fileLock.close();
                this.fileLock = null;
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    public Runnable acquireFileLock() {
        this.incrementLockCount();
        return new Runnable(){

            public void run() {
                LockOnDemandCrossProcessCacheAccess.this.decrementLockCount();
            }
        };
    }
}

