/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.local;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.collections.SingleIncludePatternFileTree;
import org.gradle.api.internal.file.delete.Deleter;
import org.gradle.internal.FileUtils;
import org.gradle.internal.resource.local.AbstractLocallyAvailableResource;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.FileStoreSearcher;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathKeyFileStore
implements FileStore<String>,
FileStoreSearcher<String> {
    public static final String IN_PROGRESS_MARKER_FILE_SUFFIX = ".fslck";
    private File baseDir;
    private final Deleter deleter;

    public PathKeyFileStore(File baseDir) {
        this.baseDir = baseDir;
        IdentityFileResolver fileResolver = new IdentityFileResolver();
        this.deleter = new Deleter(fileResolver, fileResolver.getFileSystem());
    }

    protected File getBaseDir() {
        return this.baseDir;
    }

    public LocallyAvailableResource move(String path, File source) {
        return this.saveIntoFileStore(source, this.getFile(path), true);
    }

    public LocallyAvailableResource copy(String path, File source) {
        return this.saveIntoFileStore(source, this.getFile(path), false);
    }

    private File getFile(String path) {
        return new File(this.baseDir, path);
    }

    private File getFileWhileCleaningInProgress(String path) {
        File file = this.getFile(path);
        File markerFile = this.getInProgressMarkerFile(file);
        if (markerFile.exists()) {
            this.deleter.delete(file);
            this.deleter.delete(markerFile);
        }
        return file;
    }

    public void moveFilestore(File destination) {
        if (this.baseDir.exists()) {
            GFileUtils.moveDirectory(this.baseDir, destination);
        }
        this.baseDir = destination;
    }

    public LocallyAvailableResource add(String path, Action<File> addAction) {
        String error = String.format("Failed to add into filestore '%s' at '%s' ", this.getBaseDir().getAbsolutePath(), path);
        return this.doAdd(this.getFile(path), error, addAction);
    }

    protected LocallyAvailableResource saveIntoFileStore(final File source, final File destination, final boolean isMove) {
        String verb;
        String string = verb = isMove ? "move" : "copy";
        if (!source.exists()) {
            throw new GradleException(String.format("Cannot %s '%s' into filestore @ '%s' as it does not exist", verb, source, destination));
        }
        String error = String.format("Failed to %s file '%s' into filestore at '%s' ", verb, source, destination);
        return this.doAdd(destination, error, new Action<File>(){

            public void execute(File file) {
                if (isMove) {
                    GFileUtils.moveFile(source, destination);
                } else {
                    GFileUtils.copyFile(source, destination);
                }
            }
        });
    }

    protected LocallyAvailableResource doAdd(File destination, String failureDescription, Action<File> action) {
        try {
            GFileUtils.parentMkdirs(destination);
            File inProgressMarkerFile = this.getInProgressMarkerFile(destination);
            GFileUtils.touch(inProgressMarkerFile);
            try {
                this.deleter.delete(destination);
                action.execute((Object)destination);
            }
            catch (Throwable t) {
                try {
                    this.deleter.delete(destination);
                    throw t;
                }
                catch (Throwable throwable) {
                    this.deleter.delete(inProgressMarkerFile);
                    throw throwable;
                }
            }
            this.deleter.delete(inProgressMarkerFile);
        }
        catch (Throwable t) {
            throw new GradleException(failureDescription, t);
        }
        return this.entryAt(destination);
    }

    public Set<? extends LocallyAvailableResource> search(String pattern) {
        if (!this.getBaseDir().exists()) {
            return Collections.emptySet();
        }
        final HashSet entries = new HashSet();
        this.findFiles(pattern).visit(new EmptyFileVisitor(){

            public void visitFile(FileVisitDetails fileDetails) {
                File file = fileDetails.getFile();
                if (!PathKeyFileStore.this.isInProgressMarkerFile(file) && !PathKeyFileStore.this.isInProgressFile(file)) {
                    entries.add(PathKeyFileStore.this.entryAt(file));
                }
            }
        });
        return entries;
    }

    private File getInProgressMarkerFile(File file) {
        return new File(file.getParent(), file.getName() + IN_PROGRESS_MARKER_FILE_SUFFIX);
    }

    private boolean isInProgressMarkerFile(File file) {
        return FileUtils.hasExtension((File)file, (String)IN_PROGRESS_MARKER_FILE_SUFFIX);
    }

    private boolean isInProgressFile(File file) {
        return this.getInProgressMarkerFile(file).exists();
    }

    private MinimalFileTree findFiles(String pattern) {
        return new SingleIncludePatternFileTree(this.baseDir, pattern);
    }

    protected LocallyAvailableResource entryAt(File file) {
        return this.entryAt(GFileUtils.relativePath(this.baseDir, file));
    }

    protected LocallyAvailableResource entryAt(final String path) {
        return new AbstractLocallyAvailableResource(){

            public File getFile() {
                return new File(PathKeyFileStore.this.baseDir, path);
            }
        };
    }

    public LocallyAvailableResource get(String key) {
        File file = this.getFileWhileCleaningInProgress(key);
        if (file.exists()) {
            return this.entryAt(file);
        }
        return null;
    }
}

