/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.foundation.output;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.foundation.output.FileLink;
import org.gradle.foundation.output.FileLinkDefinitionLord;
import org.gradle.foundation.output.definitions.FileLinkDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputParser {
    private FileLinkDefinitionLord fileLinkDefinitionLord;
    private boolean verifyFileExists;

    public OutputParser(FileLinkDefinitionLord fileLinkDefinitionLord, boolean verifyFileExists) {
        this.fileLinkDefinitionLord = fileLinkDefinitionLord;
        this.verifyFileExists = verifyFileExists;
    }

    public boolean isVerifyFileExists() {
        return this.verifyFileExists;
    }

    public FileLinkDefinitionLord getFileLinkDefinitionLord() {
        return this.fileLinkDefinitionLord;
    }

    public List<FileLink> parseText(String text) {
        ArrayList<FileLink> fileLinks = new ArrayList<FileLink>();
        Pattern combinedSearchPattern = this.fileLinkDefinitionLord.getSearchPattern();
        Matcher matcher = combinedSearchPattern.matcher(text);
        int index = 0;
        boolean foundAMatch = matcher.find(index);
        while (foundAMatch) {
            String matchedText = matcher.group();
            int start = matcher.start();
            int end = matcher.end();
            int nextStarting = start;
            FileLinkDefinition fileLinkDefinition = this.fileLinkDefinitionLord.getMatchingFileLinkDefinition(matchedText);
            if (fileLinkDefinition != null) {
                nextStarting = fileLinkDefinition.parseFileLink(text, matchedText, start, end, this.verifyFileExists, fileLinks);
            } else {
                System.out.println("We found a match but didn't find the matching definition. Matched text:\n" + text);
            }
            if (nextStarting == -1 || nextStarting < start) {
                nextStarting = start;
            }
            if ((index = nextStarting + 1) < text.length()) {
                foundAMatch = matcher.find(index);
                continue;
            }
            foundAMatch = false;
        }
        return fileLinks;
    }
}

