/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg.pseudocode;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.ControlFlowProcessor;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.AccessTarget;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.AccessValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.VariableDeclarationInstruction;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.resolvedCallUtil.ResolvedCallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class PseudocodeUtil {
    @NotNull
    public static Pseudocode generatePseudocode(@NotNull KtDeclaration declaration, final @NotNull BindingContext bindingContext) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeUtil", "generatePseudocode"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeUtil", "generatePseudocode"));
        }
        BindingTrace mockTrace = new BindingTrace(){

            @Override
            @NotNull
            public BindingContext getBindingContext() {
                BindingContext bindingContext2 = bindingContext;
                if (bindingContext2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeUtil$1", "getBindingContext"));
                }
                return bindingContext2;
            }

            @Override
            public <K, V> void record(WritableSlice<K, V> slice, K key, V value) {
            }

            @Override
            public <K> void record(WritableSlice<K, Boolean> slice, K key) {
            }

            @Override
            public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
                return bindingContext.get(slice, key);
            }

            @Override
            @NotNull
            public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
                Collection<K> collection = bindingContext.getKeys(slice);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeUtil$1", "getKeys"));
                }
                return collection;
            }

            @Override
            @Nullable
            public KotlinType getType(@NotNull KtExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeUtil$1", "getType"));
                }
                return bindingContext.getType(expression);
            }

            @Override
            public void recordType(@NotNull KtExpression expression, @Nullable KotlinType type2) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeUtil$1", "recordType"));
                }
            }

            @Override
            public void report(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeUtil$1", "report"));
                }
            }

            @Override
            public boolean wantsDiagnostics() {
                return false;
            }
        };
        Pseudocode pseudocode = new ControlFlowProcessor(mockTrace).generatePseudocode(declaration);
        if (pseudocode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeUtil", "generatePseudocode"));
        }
        return pseudocode;
    }

    @Nullable
    public static VariableDescriptor extractVariableDescriptorFromReference(@NotNull Instruction instruction, @NotNull BindingContext bindingContext) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeUtil", "extractVariableDescriptorFromReference"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeUtil", "extractVariableDescriptorFromReference"));
        }
        if (instruction instanceof AccessValueInstruction) {
            KtElement element = ((AccessValueInstruction)instruction).getElement();
            return element instanceof KtDeclaration ? null : PseudocodeUtil.extractVariableDescriptorIfAny(instruction, bindingContext);
        }
        return null;
    }

    @Nullable
    public static VariableDescriptor extractVariableDescriptorIfAny(@NotNull Instruction instruction, @NotNull BindingContext bindingContext) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeUtil", "extractVariableDescriptorIfAny"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeUtil", "extractVariableDescriptorIfAny"));
        }
        if (instruction instanceof VariableDeclarationInstruction) {
            KtDeclaration declaration = ((VariableDeclarationInstruction)instruction).getVariableDeclarationElement();
            return BindingContextUtils.variableDescriptorForDeclaration(bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, declaration));
        }
        if (instruction instanceof AccessValueInstruction) {
            AccessTarget target = ((AccessValueInstruction)instruction).getTarget();
            if (target instanceof AccessTarget.Declaration) {
                return ((AccessTarget.Declaration)target).getDescriptor();
            }
            if (target instanceof AccessTarget.Call) {
                return BindingContextUtils.variableDescriptorForDeclaration(((AccessTarget.Call)target).getResolvedCall().getResultingDescriptor());
            }
        }
        return null;
    }

    public static boolean isThisOrNoDispatchReceiver(@NotNull AccessValueInstruction instruction, @NotNull BindingContext bindingContext) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeUtil", "isThisOrNoDispatchReceiver"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/cfg/pseudocode/PseudocodeUtil", "isThisOrNoDispatchReceiver"));
        }
        if (instruction.getReceiverValues().isEmpty()) {
            return true;
        }
        AccessTarget accessTarget = instruction.getTarget();
        if (accessTarget instanceof AccessTarget.BlackBox) {
            return false;
        }
        assert (accessTarget instanceof AccessTarget.Call) : "AccessTarget.Declaration has no receivers and it's not BlackBox, so it should be Call";
        ResolvedCall<?> accessResolvedCall = ((AccessTarget.Call)accessTarget).getResolvedCall();
        return ResolvedCallUtilKt.hasThisOrNoDispatchReceiver(accessResolvedCall, bindingContext);
    }
}

