/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal;

import org.gradle.api.BuildableComponentSpec;
import org.gradle.api.Task;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.AbstractBuildableComponentSpec;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.platform.base.internal.ComponentSpecIdentifier;

public abstract class AbstractLanguageSourceSet
extends AbstractBuildableComponentSpec
implements LanguageSourceSetInternal {
    private final String languageName;
    private final SourceDirectorySet source;
    private boolean generated;
    private Task generatorTask;

    public AbstractLanguageSourceSet(ComponentSpecIdentifier identifier, Class<? extends BuildableComponentSpec> publicType, SourceDirectorySet source) {
        super(identifier, publicType);
        this.source = source;
        this.languageName = this.guessLanguageName(this.getTypeName());
        super.builtBy(source.getBuildDependencies());
    }

    protected String getLanguageName() {
        return this.languageName;
    }

    private String guessLanguageName(String typeName) {
        return typeName.replaceAll("LanguageSourceSet$", "").replaceAll("SourceSet$", "").replaceAll("Source$", "").replaceAll("Set$", "");
    }

    @Override
    public String getProjectScopedName() {
        return this.getIdentifier().getProjectScopedName();
    }

    @Override
    public void builtBy(Object ... tasks) {
        this.generated = true;
        super.builtBy(tasks);
    }

    @Override
    public void generatedBy(Task generatorTask) {
        this.generatorTask = generatorTask;
    }

    @Override
    public Task getGeneratorTask() {
        return this.generatorTask;
    }

    @Override
    public boolean getMayHaveSources() {
        return this.generated || !this.source.isEmpty();
    }

    @Override
    public String getDisplayName() {
        String languageName = this.getLanguageName();
        if (languageName.toLowerCase().endsWith("resources")) {
            return languageName + " '" + this.getIdentifier().getPath() + "'";
        }
        return languageName + " source '" + this.getIdentifier().getPath() + "'";
    }

    @Override
    public SourceDirectorySet getSource() {
        return this.source;
    }

    @Override
    public String getParentName() {
        return this.getIdentifier().getParent() == null ? null : this.getIdentifier().getParent().getName();
    }
}

