/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.daemon;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonForkOptions {
    private final String minHeapSize;
    private final String maxHeapSize;
    private final Iterable<String> jvmArgs;
    private final Iterable<File> classpath;
    private final Iterable<String> sharedPackages;

    public DaemonForkOptions(@Nullable String minHeapSize, @Nullable String maxHeapSize, Iterable<String> jvmArgs) {
        this(minHeapSize, maxHeapSize, jvmArgs, Collections.emptyList(), Collections.emptyList());
    }

    public DaemonForkOptions(@Nullable String minHeapSize, @Nullable String maxHeapSize, Iterable<String> jvmArgs, Iterable<File> classpath, Iterable<String> sharedPackages) {
        this.minHeapSize = minHeapSize;
        this.maxHeapSize = maxHeapSize;
        this.jvmArgs = jvmArgs;
        this.classpath = classpath;
        this.sharedPackages = sharedPackages;
    }

    public String getMinHeapSize() {
        return this.minHeapSize;
    }

    public String getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public Iterable<String> getJvmArgs() {
        return this.jvmArgs;
    }

    public Iterable<File> getClasspath() {
        return this.classpath;
    }

    public Iterable<String> getSharedPackages() {
        return this.sharedPackages;
    }

    public boolean isCompatibleWith(DaemonForkOptions other) {
        return this.getHeapSizeMb(this.minHeapSize) >= this.getHeapSizeMb(other.getMinHeapSize()) && this.getHeapSizeMb(this.maxHeapSize) >= this.getHeapSizeMb(other.getMaxHeapSize()) && this.getNormalizedJvmArgs(this.jvmArgs).containsAll(this.getNormalizedJvmArgs(other.getJvmArgs())) && this.getNormalizedClasspath(this.classpath).containsAll(this.getNormalizedClasspath(other.getClasspath())) && this.getNormalizedSharedPackages(this.sharedPackages).containsAll(this.getNormalizedSharedPackages(other.sharedPackages));
    }

    public DaemonForkOptions mergeWith(DaemonForkOptions other) {
        String mergedMinHeapSize = this.mergeHeapSize(this.minHeapSize, other.minHeapSize);
        String mergedMaxHeapSize = this.mergeHeapSize(this.maxHeapSize, other.maxHeapSize);
        Set<String> mergedJvmArgs = this.getNormalizedJvmArgs(this.jvmArgs);
        mergedJvmArgs.addAll(this.getNormalizedJvmArgs(other.getJvmArgs()));
        Set<File> mergedClasspath = this.getNormalizedClasspath(this.classpath);
        mergedClasspath.addAll(this.getNormalizedClasspath(other.classpath));
        Set<String> mergedAllowedPackages = this.getNormalizedSharedPackages(this.sharedPackages);
        mergedAllowedPackages.addAll(this.getNormalizedSharedPackages(other.sharedPackages));
        return new DaemonForkOptions(mergedMinHeapSize, mergedMaxHeapSize, mergedJvmArgs, mergedClasspath, mergedAllowedPackages);
    }

    private int getHeapSizeMb(String heapSize) {
        if (heapSize == null) {
            return -1;
        }
        String normalized = heapSize.trim().toLowerCase();
        try {
            if (normalized.endsWith("m")) {
                return Integer.parseInt(normalized.substring(0, normalized.length() - 1));
            }
            if (normalized.endsWith("g")) {
                return Integer.parseInt(normalized.substring(0, normalized.length() - 1)) * 1024;
            }
        }
        catch (NumberFormatException e) {
            throw new InvalidUserDataException("Cannot parse heap size: " + heapSize, (Throwable)e);
        }
        throw new InvalidUserDataException("Cannot parse heap size: " + heapSize);
    }

    private String mergeHeapSize(String heapSize1, String heapSize2) {
        int mergedHeapSizeMb = Math.max(this.getHeapSizeMb(heapSize1), this.getHeapSizeMb(heapSize2));
        return mergedHeapSizeMb == -1 ? null : String.valueOf(mergedHeapSizeMb) + "m";
    }

    private Set<String> getNormalizedJvmArgs(Iterable<String> jvmArgs) {
        LinkedHashSet normalized = Sets.newLinkedHashSet();
        for (String jvmArg : jvmArgs) {
            normalized.add(jvmArg.trim());
        }
        return normalized;
    }

    private Set<File> getNormalizedClasspath(Iterable<File> classpath) {
        return Sets.newLinkedHashSet(classpath);
    }

    private Set<String> getNormalizedSharedPackages(Iterable<String> allowedPackages) {
        return Sets.newLinkedHashSet(allowedPackages);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("minHeapSize", (Object)this.minHeapSize).add("maxHeapSize", (Object)this.maxHeapSize).add("jvmArgs", this.jvmArgs).add("classpath", this.classpath).toString();
    }
}

