/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.daemon;

import java.io.File;
import net.jcip.annotations.ThreadSafe;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.process.internal.daemon.DaemonForkOptions;
import org.gradle.process.internal.daemon.WorkSpec;
import org.gradle.process.internal.daemon.WorkerDaemon;
import org.gradle.process.internal.daemon.WorkerDaemonAction;
import org.gradle.process.internal.daemon.WorkerDaemonClient;
import org.gradle.process.internal.daemon.WorkerDaemonClientsManager;
import org.gradle.process.internal.daemon.WorkerDaemonFactory;
import org.gradle.process.internal.daemon.WorkerDaemonProtocol;
import org.gradle.process.internal.daemon.WorkerDaemonResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class WorkerDaemonManager
implements WorkerDaemonFactory,
Stoppable {
    private WorkerDaemonClientsManager clientsManager;

    public WorkerDaemonManager(WorkerDaemonClientsManager clientsManager) {
        this.clientsManager = clientsManager;
    }

    @Override
    public WorkerDaemon getDaemon(final Class<? extends WorkerDaemonProtocol> serverImplementationClass, final File workingDir, final DaemonForkOptions forkOptions) {
        return new WorkerDaemon(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <T extends WorkSpec> WorkerDaemonResult execute(WorkerDaemonAction<T> action, T spec) {
                WorkerDaemonClient client = WorkerDaemonManager.this.clientsManager.reserveIdleClient(forkOptions);
                if (client == null) {
                    client = WorkerDaemonManager.this.clientsManager.reserveNewClient(serverImplementationClass, workingDir, forkOptions);
                }
                try {
                    WorkerDaemonResult workerDaemonResult = client.execute(action, spec);
                    return workerDaemonResult;
                }
                finally {
                    WorkerDaemonManager.this.clientsManager.release(client);
                }
            }
        };
    }

    public void stop() {
        this.clientsManager.stop();
    }
}

