package flash.media;

extern class AVSegmentedSource extends AVSource {
	var cookieHeader(never,default) : String;
	var masterUpdateInterval(never,default) : Int;
	var networkingParams : AVNetworkingParams;
	var useRedirectedUrl(never,default) : Bool;
	function new() : Void;
	function addCustomHeader(headerName : String, args : flash.Vector<String>) : Void;
	function clearPauseAtPeriodEnd(periodIndex : Int) : AVResult;
	function getABRProfileCount(periodIndex : Int) : Int;
	function getABRProfileInfoAtIndex(periodIndex : Int, abrProfileIndex : Int) : AVABRProfileInfo;
	function getBackgroundPeriodInfo(periodIndex : Int) : AVPeriodInfo;
	function getBackgroundTimeline() : AVTimeline;
	function getCuePoint(periodIndex : Int, cuePointIndex : Int) : AVCuePoint;
	function getPerceivedBandwidth() : UInt;
	function getPeriodInfo(periodIndex : Int) : AVPeriodInfo;
	function getSubscribedTag(periodIndex : Int, tagDataIndex : Int) : AVTagData;
	function getSubscribedTagForBackgroundManifest(periodIndex : Int, tagDataIndex : Int) : AVTagData;
	function getTimeline() : AVTimeline;
	function getTimelineSubscribedTag(tagDataIndex : Int) : AVTagData;
	function getTimelineSubscribedTagForBackgroundManifest(tagDataIndex : Int) : AVTagData;
	function getTrackCount(periodIndex : Int, payloadType : String) : Int;
	function getTrackInfo(periodIndex : Int, payloadType : String, trackIndex : Int) : AVTrackInfo;
	function insertByLocalTime(periodIndex : Int, insertionTime : Float, handle : Int, userData : Int = 0, replaceDuration : Float = 0) : AVInsertionResult;
	function insertByVirtualTime(insertionTime : Float, handle : Int, userData : Int = 0, replaceDuration : Float = 0) : AVInsertionResult;
	function load(url : String, ?containerType : String, userData : Int = 0) : AVResult;
	function loadManifest(uri : String, userData : Int = 0, ?containerType : String) : AVResult;
	function loadWithBackgroundManifest(url : String, containerType : String, userData : Int, backgroundManifest : String) : AVResult;
	function releaseManifest(handle : Int) : AVResult;
	function removeByLocalTime(periodIndex : Int, timeStart : Float, timeEnd : Float, replaceWithMainMedia : Bool) : AVResult;
	function removeByVirtualTime(virtualTimeStart : Float, virtualTimeEnd : Float) : AVResult;
	function selectTrack(periodIndex : Int, payloadType : String, trackIndex : Int) : AVResult;
	function selectTrackString(periodIndex : Int, payloadType : String, trackString : String) : AVResult;
	function setABRParameters(params : AVABRParameters) : AVResult;
	function setBandwidth(bitsPerSecond : Int) : AVResult;
	function setCuePointTags(tagArray : Array<Dynamic>) : AVResult;
	function setHoldAt(time : Float) : AVResult;
	function setPauseAtPeriodEnd(periodIndex : Int, userData : Int = 0) : AVResult;
	function setSubscribedTags(tagArray : Array<Dynamic>) : AVResult;
	function setSubscribedTagsForBackgroundManifest(tagArray : Array<Dynamic>) : AVResult;
	static var AUDIO(default,never) : String;
	static var AUDIO_DESCRIPTION(default,never) : String;
	static var AUDIO_LANGUAGE(default,never) : String;
	static var AUDIO_PID(default,never) : String;
	static var DASH(default,never) : String;
	static var DATA(default,never) : String;
	static var DATA_DESCRIPTION(default,never) : String;
	static var HLS(default,never) : String;
	static var VIDEO(default,never) : String;
	static var VIDEO_DESCRIPTION(default,never) : String;
}
