/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.apache.batik.anim.dom.AnimatedLiveAttributeValue;
import org.apache.batik.anim.dom.SVGOMAnimatedPoints;
import org.apache.batik.anim.dom.SVGOMPolylineElement;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.SVGDecoratedShapeElementBridge;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.parser.AWTPolylineProducer;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGPointList;

public class SVGPolylineElementBridge
extends SVGDecoratedShapeElementBridge {
    protected static final Shape DEFAULT_SHAPE = new GeneralPath();

    @Override
    public String getLocalName() {
        return "polyline";
    }

    @Override
    public Bridge getInstance() {
        return new SVGPolylineElementBridge();
    }

    @Override
    protected void buildShape(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        SVGOMPolylineElement sVGOMPolylineElement = (SVGOMPolylineElement)element;
        try {
            SVGOMAnimatedPoints sVGOMAnimatedPoints = sVGOMPolylineElement.getSVGOMAnimatedPoints();
            sVGOMAnimatedPoints.check();
            SVGPointList sVGPointList = sVGOMAnimatedPoints.getAnimatedPoints();
            int n = sVGPointList.getNumberOfItems();
            if (n == 0) {
                shapeNode.setShape(DEFAULT_SHAPE);
            } else {
                AWTPolylineProducer aWTPolylineProducer = new AWTPolylineProducer();
                aWTPolylineProducer.setWindingRule(CSSUtilities.convertFillRule(element));
                aWTPolylineProducer.startPoints();
                for (int i = 0; i < n; ++i) {
                    SVGPoint sVGPoint = sVGPointList.getItem(i);
                    aWTPolylineProducer.point(sVGPoint.getX(), sVGPoint.getY());
                }
                aWTPolylineProducer.endPoints();
                shapeNode.setShape(aWTPolylineProducer.getShape());
            }
        }
        catch (LiveAttributeException liveAttributeException) {
            throw new BridgeException(bridgeContext, liveAttributeException);
        }
    }

    @Override
    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue animatedLiveAttributeValue) {
        String string;
        if (animatedLiveAttributeValue.getNamespaceURI() == null && (string = animatedLiveAttributeValue.getLocalName()).equals("points")) {
            this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            this.handleGeometryChanged();
            return;
        }
        super.handleAnimatedAttributeChanged(animatedLiveAttributeValue);
    }

    @Override
    protected void handleCSSPropertyChanged(int n) {
        switch (n) {
            case 17: {
                this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
                this.handleGeometryChanged();
                break;
            }
            default: {
                super.handleCSSPropertyChanged(n);
            }
        }
    }
}

