/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openscience.jmol.app.nbo.FileHndlr;
import org.openscience.jmol.app.nbo.HelpBtn;
import org.openscience.jmol.app.nbo.NBODialog;
import org.openscience.jmol.app.nbo.NBODialogConfig;
import org.openscience.jmol.app.nbo.NBODialogRun;

abstract class NBODialogView
extends NBODialogRun {
    protected static final String[] basSet = new String[]{"AO", "PNAO", "NAO", "PNHO", "NHO", "PNBO", "NBO", "PNLMO", "NLMO", "MO"};
    protected JList<String> orbitals;
    String vectorDef;
    String planeDef;
    protected DefaultComboBoxModel<String> alphaList;
    protected DefaultComboBoxModel<String> betaList;
    protected JComboBox<String> basis;
    protected JRadioButton alphaSpin;
    protected JRadioButton betaSpin;
    protected int viewState;
    protected boolean positiveSign;
    protected boolean jmolView;
    protected JRadioButton[] storage;
    protected Container settingsBox;
    protected int startingModelCount;
    protected int modelCount = 1;
    protected boolean newModel = true;
    protected String currOrb = "";
    protected char currSign = (char)43;
    private char lastSign = (char)43;
    protected int iLast = 0;
    protected String selectedOrbs = "";
    private String[] plVal;
    private String[] vecVal;
    private String[] lineVal;
    protected final JTextField[] vectorFields = new JTextField[8];
    protected final JTextField[] planeFields = new JTextField[12];
    protected final JTextField[] camFields = new JTextField[53];
    protected final JTextField[] lineFields = new JTextField[7];
    private String[] camVal = new String[]{"6.43", "0.0", "0.0", "50.0", "2.0", "2.0", "0.0", "0.60", "1.0", "1.0", "40.0", "0.0", "0.60", "1.0", "1.0", "40.0", "0.0", "0.60", "1.0", "1.0", "40.0", "0.0", "0.60", "1.0", "1.0", "40.0", "0.5", "1.0", "1.0", "1.0", "0.8", "0.0", "0.0", "1.0", "0.8", "0.4", "0.0", "1.0", "1.0", "0.5", "0.5", "0.5", "0.0", "0.7", "1.0", "0.22", "0.40", "0.10", "0.05", "0.0316", "0.0001", "0.4000", "1"};
    String[] camFieldIDs = new String[]{"1a", "1b", "1c", "1d", "1e", "1f", "1g", "2a", "2b", "2c", "2d", "2e", "2f", "2g", "2h", "2i", "2j", "2k", "2l", "2m", "2n", "2o", "2p", "2q", "2r", "2s", "2t", "3a", "3b", "3c", "3d", "3e", "3f", "3g", "3h", "3i", "3j", "3k", "3l", "3m", "3n", "3o", "3p", "3q", "3r", "4a", "4b", "4c", "4d", "5a", "5b", "5c", "6"};
    protected final JTextField[] contourFields = new JTextField[7];
    protected static final int VIEW_STATE_MAIN = 0;
    protected static final int VIEW_STATE_PLANE = 1;
    protected static final int VIEW_STATE_VECTOR = 2;
    protected static final int VIEW_STATE_CAMERA = 3;
    private int viewVectorPt = 0;
    private int viewPlanePt = 0;

    protected NBODialogView(JFrame f) {
        super(f);
    }

    protected JPanel buildViewPanel() {
        this.startingModelCount = this.vwr.ms.mc;
        this.panel = new JPanel();
        this.viewState = 0;
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.runScriptQueued("set bondpicking true");
        this.panel.add(NBODialogView.titleBox(" Select Job ", new HelpBtn("view_job_help.htm")));
        Box inputBox = this.borderBox(true);
        inputBox.setPreferredSize(new Dimension(355, 40));
        inputBox.setMaximumSize(new Dimension(355, 40));
        this.panel.add(inputBox);
        this.fileHndlr = new FileHndlr("", "47", 3, "47", (NBODialog)this);
        inputBox.add(this.fileHndlr);
        inputBox.setMaximumSize(new Dimension(350, 75));
        Box horizBox = Box.createHorizontalBox();
        this.betaList = null;
        this.alphaList = null;
        this.basis = new JComboBox<String>(basSet);
        this.basis.setMaximumSize(new Dimension(70, 25));
        this.basis.setUI(new NBODialogConfig.StyledComboBoxUI(180, -1));
        horizBox.add(this.basis);
        this.basis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NBODialogView.this.alphaList != null) {
                    NBODialogView.this.betaList = null;
                    NBODialogView.this.alphaList = null;
                }
                NBODialogView.this.basisSel();
            }
        });
        this.betaSpin = new JRadioButton("<html>&#x3B2</html>");
        this.alphaSpin = new JRadioButton("<html>&#x3B1</html>");
        this.alphaSpin.setSelected(true);
        ButtonGroup spinSelection = new ButtonGroup();
        spinSelection.add(this.alphaSpin);
        spinSelection.add(this.betaSpin);
        this.betaSpin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NBODialogView.this.betaSpin.isSelected()) {
                    NBODialogView.this.setBonds(false);
                    NBODialogView.this.showAtomNums(false);
                }
                if (NBODialogView.this.nboView) {
                    String s2 = NBODialogView.this.runScriptNow("print {*}.bonds");
                    NBODialogView.this.runScriptQueued("select " + s2 + ";color bonds lightgrey");
                }
                NBODialogView.this.basisSel();
            }
        });
        this.alphaSpin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NBODialogView.this.alphaSpin.isSelected()) {
                    NBODialogView.this.setBonds(true);
                    NBODialogView.this.showAtomNums(true);
                }
                if (NBODialogView.this.nboView) {
                    String s2 = NBODialogView.this.runScriptNow("print {*}.bonds");
                    NBODialogView.this.runScriptQueued("select " + s2 + ";color bonds lightgrey");
                }
                NBODialogView.this.basisSel();
            }
        });
        horizBox.add(this.alphaSpin);
        this.alphaSpin.setVisible(false);
        horizBox.add(this.betaSpin);
        this.betaSpin.setVisible(false);
        horizBox.add(new HelpBtn("view_orbital_help.htm"));
        this.panel.add(NBODialogView.titleBox(" Select Orbital(s) ", horizBox)).setVisible(false);
        JPanel orbPanel = new JPanel(new BorderLayout());
        orbPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.orbitals = new JList();
        this.orbitals.setFont(nboFont);
        this.orbitals.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int fileNum = 31 + NBODialogView.this.basis.getSelectedIndex();
                File f = FileHndlr.newNBOFile(NBODialogView.this.fileHndlr.inputFile, "" + fileNum);
                int[] selected = NBODialogView.this.orbitals.getSelectedIndices();
                int size = selected.length - 1;
                if (size < 0) {
                    return;
                }
                if (size == 0) {
                    NBODialogView.this.selectedOrbs = "";
                    NBODialogView.this.runScriptQueued("mo delete");
                }
                for (int i = NBODialogView.this.modelCount - 1; i < size / 2; ++i) {
                    NBODialogView.this.newModel = false;
                    NBODialogView.this.runScriptQueued("load append " + f.getAbsolutePath());
                }
                NBODialogView.this.modelCount = size / 2 + 1;
                String type = NBODialogView.this.basis.getSelectedItem().toString();
                for (int i = 0; i <= size; ++i) {
                    if (PT.isOneOf("" + (selected[i] + 1), NBODialogView.this.selectedOrbs)) continue;
                    NBODialogView.this.selectedOrbs = NBODialogView.this.selectedOrbs + (selected[i] + 1) + ";";
                    NBODialogView.this.runScriptNow("frame " + (i / 2 + 1) + ".1");
                    if (size % 2 == 0) {
                        NBODialogView.this.showOrbJmol(type, selected[i] + 1);
                        continue;
                    }
                    NBODialogView.this.showMOJmol(type, selected[i] + 1);
                }
                String frame = NBODialogView.this.startingModelCount + NBODialogView.this.modelCount - 1 + ".1";
                NBODialogView.this.runScriptQueued("frame " + NBODialogView.this.startingModelCount + ".1 " + frame);
            }
        });
        this.orbitals.setBackground(Color.WHITE);
        JScrollPane sp = new JScrollPane();
        sp.setMaximumSize(new Dimension(355, 400));
        sp.getViewport().setMinimumSize(new Dimension(250, 400));
        sp.getViewport().add(this.orbitals);
        orbPanel.add((Component)new JLabel("(ctrl+click to select up to 9)"), "South");
        orbPanel.add((Component)sp, "Center");
        orbPanel.setVisible(false);
        final JButton goBtn = new JButton("GO");
        goBtn.setEnabled(false);
        Box profBox = Box.createVerticalBox();
        profBox.add(new JLabel("<html><u> Display Type</u></html>")).setFont(nboFont);
        ButtonGroup bg = new ButtonGroup();
        final JRadioButton profileBtn = new JRadioButton("1D Profile");
        profileBtn.setToolTipText("Produce profile plot from axis parameters");
        bg.add(profileBtn);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                goBtn.setEnabled(true);
            }
        };
        profileBtn.addActionListener(al);
        profBox.add(profileBtn).setFont(nboFont);
        final JRadioButton contourBtn = new JRadioButton("2D Contour");
        contourBtn.setToolTipText("Produce contour plot from plane parameters");
        profBox.add(contourBtn).setFont(nboFont);
        contourBtn.addActionListener(al);
        bg.add(contourBtn);
        final JRadioButton viewBtn = new JRadioButton("3D view");
        viewBtn.addActionListener(al);
        profBox.add(viewBtn).setFont(nboFont);
        bg.add(viewBtn);
        goBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] sel = NBODialogView.this.orbitals.getSelectedIndices();
                if (sel.length > 9) {
                    NBODialogView.this.vwr.alert("More than 9 orbitals selected");
                    return;
                }
                if (profileBtn.isSelected()) {
                    NBODialogView.this.goViewClicked(true);
                } else if (contourBtn.isSelected()) {
                    NBODialogView.this.goViewClicked(false);
                } else if (viewBtn.isSelected()) {
                    NBODialogView.this.view3D(NBODialogView.this.orbitals.getSelectedIndices());
                }
            }
        });
        profBox.add(goBtn);
        orbPanel.add((Component)profBox, "East");
        orbPanel.setAlignmentX(0.0f);
        this.panel.add(orbPanel);
        this.viewSettings();
        this.fileHndlr.browse.setEnabled(true);
        return this.panel;
    }

    private void viewSettings() {
        this.settingsBox.removeAll();
        this.settingsBox.setLayout(new BorderLayout());
        Box top = Box.createVerticalBox();
        JLabel lab = new JLabel("Settings:");
        lab.setBackground(Color.black);
        lab.setForeground(Color.white);
        lab.setOpaque(true);
        lab.setFont(nboFont);
        top.add(lab);
        Box tmp = Box.createHorizontalBox();
        tmp.add(new JLabel("View Type: "));
        final JRadioButton customOrient = new JRadioButton("Atoms");
        final JRadioButton jmolOrient = new JRadioButton("Jmol");
        tmp.add(customOrient);
        tmp.add(jmolOrient);
        ButtonGroup bg = new ButtonGroup();
        bg.add(jmolOrient);
        bg.add(customOrient);
        this.settingsBox.add((Component)lab, "North");
        Box middle = Box.createVerticalBox();
        middle.add(tmp);
        tmp = Box.createHorizontalBox();
        JButton btnVec = new JButton("Axis");
        JButton btnPla = new JButton("Plane");
        JButton btnLines = new JButton("Lines");
        tmp.add(btnVec);
        tmp.add(btnPla);
        tmp.add(btnLines);
        btnVec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogView.this.vector();
            }
        });
        btnPla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogView.this.plane();
            }
        });
        btnLines.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogView.this.lines();
            }
        });
        btnPla.setMargin(null);
        JButton btnCam = new JButton("Camera");
        btnCam.setMargin(null);
        middle.add(tmp);
        btnCam.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogView.this.cam1();
            }
        });
        this.settingsBox.add((Component)middle, "Center");
        jmolOrient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (jmolOrient.isSelected()) {
                    SB sb = new SB();
                    sb.append("CMD JVIEW");
                    NBODialogView.this.nboService.rawCmdNew("v", sb, 0, null, "");
                    NBODialogView.this.jmolView = true;
                }
            }
        });
        customOrient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (customOrient.isSelected()) {
                    SB sb = new SB();
                    sb.append("CMD AVIEW");
                    NBODialogView.this.nboService.rawCmdNew("v", sb, 0, null, "");
                    NBODialogView.this.jmolView = false;
                }
            }
        });
        customOrient.setSelected(true);
        Box bottom = Box.createHorizontalBox();
        bottom.add(btnCam);
        bottom.add(new JLabel("   Phase: "));
        final JRadioButton pSign = new JRadioButton("+");
        final JRadioButton nSign = new JRadioButton("-");
        this.positiveSign = true;
        pSign.setSelected(true);
        pSign.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (pSign.isSelected()) {
                    NBODialogView.this.positiveSign = true;
                    NBODialogView.this.currSign = (char)43;
                    NBODialogView.this.runScriptQueued("nbo color " + NBODialogView.this.color2 + " " + NBODialogView.this.color1);
                }
            }
        });
        nSign.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (nSign.isSelected()) {
                    NBODialogView.this.positiveSign = false;
                    NBODialogView.this.currSign = (char)45;
                    NBODialogView.this.runScriptQueued("nbo color " + NBODialogView.this.color1 + " " + NBODialogView.this.color2);
                }
            }
        });
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(pSign);
        bg2.add(nSign);
        bottom.add(pSign);
        bottom.add(nSign);
        this.settingsBox.add((Component)bottom, "South");
        this.repaint();
        this.revalidate();
    }

    private String getPlaneParams() {
        String s = "";
        for (int i = 0; i < this.planeFields.length; ++i) {
            if (this.plVal[i].equals(this.planeFields[i].getText())) continue;
            this.plVal[i] = this.planeFields[i].getText();
            s = s + "GLOBAL PLANE_" + (char)(97 + i) + " " + this.planeFields[i].getText() + sep;
        }
        return s;
    }

    protected void plane() {
        this.viewPlanePt = 0;
        this.runScriptNow("set bondpicking false");
        this.viewState = 1;
        Box box = NBODialogView.titleBox(" Definiton of Plane ", null);
        JPanel plane = new JPanel(new BorderLayout());
        JPanel labs = new JPanel(new GridLayout(7, 1, 5, 0));
        labs.add(new JLabel("Enter or select three atoms:"));
        labs.add(new JLabel("Enter fraction to locate origin:"));
        labs.add(new JLabel("Enter two rotation angles:"));
        labs.add(new JLabel("Enter shift of plane along normal:"));
        labs.add(new JLabel("Enter min and max X values:"));
        labs.add(new JLabel("Enter min and max Y values:"));
        labs.add(new JLabel("Enter number of steps NX:"));
        plane.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(7, 1, 5, 0));
        Box bo = Box.createHorizontalBox();
        bo.add(this.planeFields[0]);
        bo.add(this.planeFields[1]);
        bo.add(this.planeFields[2]);
        in.add(bo);
        in.add(this.planeFields[3]);
        bo = Box.createHorizontalBox();
        bo.add(this.planeFields[4]);
        bo.add(this.planeFields[5]);
        in.add(bo);
        in.add(this.planeFields[6]);
        bo = Box.createHorizontalBox();
        bo.add(this.planeFields[7]);
        bo.add(this.planeFields[8]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.planeFields[9]);
        bo.add(this.planeFields[10]);
        in.add(bo);
        in.add(this.planeFields[11]);
        plane.add((Component)in, "Center");
        JButton b = new JButton("OK");
        plane.add((Component)b, "South");
        Box box2 = Box.createVerticalBox();
        box2.setBorder(BorderFactory.createLineBorder(Color.black));
        box2.add(plane);
        box2.setAlignmentX(0.0f);
        box2.setMaximumSize(new Dimension(355, 250));
        box.add(box2);
        final JDialog d = new JDialog((Dialog)this, "Vector definition");
        d.setSize(new Dimension(300, 300));
        d.setVisible(true);
        d.add(box);
        int x = (this.getX() + this.getWidth()) / 2 + 150;
        int y = (this.getY() + this.getHeight()) / 2 - 175;
        d.setLocation(x, y);
        this.showSelected(this.planeDef.split(";"));
        d.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NBODialogView.this.planeDef = NBODialogView.this.planeFields[0].getText() + ";" + NBODialogView.this.planeFields[1].getText() + ";" + NBODialogView.this.planeFields[2].getText();
                NBODialogView.this.runScriptQueued("select off");
                NBODialogView.this.runScriptNow("set bondpicking true");
                NBODialogView.this.viewState = 0;
            }
        });
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                d.dispose();
                NBODialogView.this.planeDef = NBODialogView.this.planeFields[0].getText() + ";" + NBODialogView.this.planeFields[1].getText() + ";" + NBODialogView.this.planeFields[2].getText();
                NBODialogView.this.runScriptQueued("select off");
                NBODialogView.this.runScriptNow("set bondpicking true");
                NBODialogView.this.viewState = 0;
            }
        });
        plane.setVisible(true);
    }

    private String getVectorParams() {
        String s = "";
        for (int i = 0; i < this.vectorFields.length; ++i) {
            if (this.vecVal[i].equals(this.vectorFields[i].getText())) continue;
            this.vecVal[i] = this.vectorFields[i].getText();
            s = s + "GLOBAL VECTOR_" + (char)(97 + i) + " " + this.vectorFields[i].getText() + sep;
        }
        return s;
    }

    protected void vector() {
        this.runScriptNow("set bondpicking false");
        this.viewState = 2;
        this.viewVectorPt = 0;
        Box box = NBODialogView.titleBox(" Vector Definition ", null);
        JPanel vect = new JPanel(new BorderLayout());
        JPanel labs = new JPanel(new GridLayout(5, 1, 5, 0));
        labs.add(new JLabel("Enter or select two atom numbers:"));
        labs.add(new JLabel("Enter fraction to locate origin:"));
        labs.add(new JLabel("Enter min and max X values:"));
        labs.add(new JLabel("Enter min and max function values:"));
        labs.add(new JLabel("Enter number of steps NX:"));
        vect.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(5, 1, 5, 0));
        Box bo = Box.createHorizontalBox();
        bo.add(this.vectorFields[0]);
        bo.add(this.vectorFields[1]);
        in.add(bo);
        in.add(this.vectorFields[2]);
        bo = Box.createHorizontalBox();
        bo.add(this.vectorFields[3]);
        bo.add(this.vectorFields[4]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.vectorFields[5]);
        bo.add(this.vectorFields[6]);
        in.add(bo);
        in.add(this.vectorFields[7]);
        vect.add((Component)in, "Center");
        JButton b = new JButton("OK");
        Box box2 = Box.createVerticalBox();
        vect.add((Component)b, "South");
        vect.setAlignmentX(0.0f);
        box2.setAlignmentX(0.0f);
        box.setAlignmentX(0.0f);
        box2.setBorder(BorderFactory.createLineBorder(Color.black));
        box2.add(vect);
        box2.setMaximumSize(new Dimension(355, 250));
        box.add(box2);
        final JDialog d = new JDialog((Dialog)this, "Vector definition");
        d.setSize(new Dimension(300, 300));
        d.setVisible(true);
        d.add(box);
        int x = (this.getX() + this.getWidth()) / 2 + 150;
        int y = (this.getY() + this.getHeight()) / 2 - 150;
        d.setLocation(x, y);
        this.showSelected(this.vectorDef.split(";"));
        d.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NBODialogView.this.vectorDef = NBODialogView.this.vectorFields[0].getText() + ";" + NBODialogView.this.vectorFields[1].getText();
                NBODialogView.this.runScriptQueued("select off");
                NBODialogView.this.runScriptNow("set bondpicking true");
                NBODialogView.this.viewState = 0;
            }
        });
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                d.dispose();
                NBODialogView.this.vectorDef = NBODialogView.this.vectorFields[0].getText() + ";" + NBODialogView.this.vectorFields[1].getText();
                NBODialogView.this.runScriptQueued("select off");
                NBODialogView.this.runScriptNow("set bondpicking true");
                NBODialogView.this.viewState = 0;
            }
        });
    }

    private String getLineParams() {
        String s = "";
        for (int i = 0; i < this.lineFields.length; ++i) {
            if (this.lineVal[i].equals(this.lineFields[i].getText())) continue;
            this.lineVal[i] = this.lineFields[i].getText();
            s = s + "GLOBAL LINES_" + (char)(97 + i) + " " + this.lineVal[i] + sep;
        }
        return s;
    }

    protected void lines() {
        Box box = NBODialogView.titleBox(" Contour lines ", null);
        JPanel lines = new JPanel(new BorderLayout());
        JPanel labs = new JPanel(new GridLayout(5, 1, 5, 0));
        labs.add(new JLabel("Enter first contour line:"));
        labs.add(new JLabel("Enter contour step size:"));
        labs.add(new JLabel("Enter number of contours:"));
        labs.add(new JLabel("Enter length of dash (cm):"));
        labs.add(new JLabel("Enter length of space (cm):"));
        lines.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(5, 1, 5, 0));
        in.add(this.lineFields[0]);
        in.add(this.lineFields[1]);
        in.add(this.lineFields[2]);
        in.add(this.lineFields[3]);
        in.add(this.lineFields[4]);
        lines.add((Component)in, "Center");
        Box box2 = Box.createVerticalBox();
        box2.setBorder(BorderFactory.createLineBorder(Color.black));
        box2.add(lines);
        box.add(box2);
        box2.setAlignmentX(0.0f);
        final JDialog d = new JDialog((Dialog)this, "Line settings");
        d.setSize(new Dimension(300, 300));
        d.setVisible(true);
        d.add(box);
        box = NBODialogView.titleBox(" Orbital diagram lines ", null);
        lines = new JPanel(new BorderLayout());
        labs = new JPanel(new GridLayout(2, 1, 5, 0));
        labs.add(new JLabel("Enter length of dash (cm):"));
        labs.add(new JLabel("Enter length of space (cm):"));
        lines.add((Component)labs, "West");
        in = new JPanel(new GridLayout(2, 1, 5, 0));
        in.add(this.lineFields[5]);
        in.add(this.lineFields[6]);
        lines.add((Component)in, "Center");
        box2 = Box.createVerticalBox();
        box2.setAlignmentX(0.0f);
        box2.setBorder(BorderFactory.createLineBorder(Color.black));
        box2.add(lines);
        box.add(box2);
        JButton b = new JButton("OK");
        lines.add((Component)b, "South");
        d.add((Component)box, "South");
        int x = (this.getX() + this.getWidth()) / 2 + 150;
        int y = (this.getY() + this.getHeight()) / 2 - 150;
        d.setLocation(x, y);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                d.dispose();
                NBODialogView.this.viewState = 0;
            }
        });
        lines.setVisible(true);
    }

    private String getCameraParams() {
        String s = "";
        for (int i = 0; i < this.camFields.length; ++i) {
            if (this.camFields[i].getText().equals(this.camVal[i])) continue;
            this.camVal[i] = this.camFields[i].getText();
            s = s + "GLOBAL CAMERA_" + this.camFieldIDs[i] + " " + this.camVal[i] + sep;
        }
        return s;
    }

    protected void cam1() {
        this.viewState = 3;
        JPanel panel = new JPanel();
        JPanel cam1 = new JPanel();
        cam1.setLayout(new BorderLayout());
        cam1.setMinimumSize(new Dimension(350, 200));
        cam1.setVisible(true);
        cam1.setBorder(BorderFactory.createLineBorder(Color.black));
        Box box = NBODialogView.titleBox(" Camera and Light-Source ", null);
        JPanel labs = new JPanel(new GridLayout(5, 1, 5, 0));
        labs.add(new JLabel("Bounding sphere radius"));
        labs.add(new JLabel("Camera distance from screen center:"));
        labs.add(new JLabel("Two rotation angles (about X, Y):"));
        labs.add(new JLabel("Camera view angle:"));
        labs.add(new JLabel("Lighting (RL, UD, BF w.r.t. camera):"));
        cam1.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(5, 1, 5, 0));
        Box bo = Box.createHorizontalBox();
        in.add(this.camFields[52]);
        in.add(this.camFields[0]);
        bo.add(this.camFields[1]);
        bo.add(this.camFields[2]);
        in.add(bo);
        in.add(this.camFields[3]);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[4]);
        bo.add(this.camFields[5]);
        bo.add(this.camFields[6]);
        in.add(bo);
        cam1.add((Component)in, "Center");
        cam1.setAlignmentX(0.0f);
        box.add(cam1);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(box);
        this.cam2(panel);
        this.cam3(panel);
        this.cam4(panel);
        this.cam5(panel);
        JScrollPane sp = new JScrollPane();
        sp.setMaximumSize(new Dimension(350, 500));
        sp.getViewport().add(panel);
        final JDialog d = new JDialog((Dialog)this, "Camera parameters");
        d.setSize(new Dimension(360, 500));
        d.setVisible(true);
        d.add((Component)sp, "Center");
        int x = (this.getX() + this.getWidth()) / 2 + 100;
        int y = (this.getY() + this.getHeight()) / 2 - 250;
        d.setLocation(x, y);
        JButton b = new JButton("OK");
        d.add((Component)b, "South");
        b.setAlignmentX(0.0f);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                d.dispose();
            }
        });
    }

    private void cam2(JPanel panel) {
        Box box = NBODialogView.titleBox(" Surface Optical Parameters: ", null);
        JPanel cam2 = new JPanel(new BorderLayout());
        cam2.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel labs = new JPanel(new GridLayout(4, 1, 5, 0));
        labs.add(new JLabel("atoms:"));
        labs.add(new JLabel("bonds:"));
        labs.add(new JLabel("H-bonds:"));
        labs.add(new JLabel("orbitals:"));
        cam2.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(4, 1, 5, 0));
        Box bo = Box.createHorizontalBox();
        bo.add(this.camFields[7]);
        bo.add(this.camFields[8]);
        bo.add(this.camFields[9]);
        bo.add(this.camFields[10]);
        bo.add(this.camFields[11]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[12]);
        bo.add(this.camFields[13]);
        bo.add(this.camFields[14]);
        bo.add(this.camFields[15]);
        bo.add(this.camFields[16]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[17]);
        bo.add(this.camFields[18]);
        bo.add(this.camFields[19]);
        bo.add(this.camFields[20]);
        bo.add(this.camFields[21]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[22]);
        bo.add(this.camFields[23]);
        bo.add(this.camFields[24]);
        bo.add(this.camFields[25]);
        bo.add(this.camFields[26]);
        in.add(bo);
        cam2.add((Component)in, "Center");
        cam2.add((Component)new JLabel("                    amb              diff           spec        pow        transp"), "North");
        cam2.setAlignmentX(0.0f);
        box.add(cam2);
        panel.add(box);
    }

    private void cam3(JPanel panel) {
        JPanel cam3 = new JPanel(new BorderLayout());
        Box box = NBODialogView.titleBox(" Color (Blue/Green/Red) Parameters: ", null);
        cam3.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel labs = new JPanel(new GridLayout(6, 1, 5, 0));
        labs.add(new JLabel("light source color:"));
        labs.add(new JLabel("background color:"));
        labs.add(new JLabel("orbital (+ phase) color:"));
        labs.add(new JLabel("orbital (- phase) color:"));
        labs.add(new JLabel("bond color"));
        labs.add(new JLabel("H-Bond color"));
        cam3.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(6, 1, 5, 0));
        Box bo = Box.createHorizontalBox();
        bo.add(this.camFields[27]);
        bo.add(this.camFields[28]);
        bo.add(this.camFields[29]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[30]);
        bo.add(this.camFields[31]);
        bo.add(this.camFields[32]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[33]);
        bo.add(this.camFields[34]);
        bo.add(this.camFields[35]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[36]);
        bo.add(this.camFields[37]);
        bo.add(this.camFields[38]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[39]);
        bo.add(this.camFields[40]);
        bo.add(this.camFields[41]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[42]);
        bo.add(this.camFields[43]);
        bo.add(this.camFields[44]);
        in.add(bo);
        cam3.add((Component)in, "Center");
        cam3.add((Component)new JLabel("                                                 Blue               Green             Red"), "North");
        cam3.setAlignmentX(0.0f);
        box.add(cam3);
        panel.add(box);
    }

    private void cam4(JPanel panel) {
        JPanel cam4 = new JPanel(new BorderLayout());
        Box box = NBODialogView.titleBox(" Atomic and Bond Radii: ", null);
        cam4.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel labs = new JPanel(new GridLayout(4, 1, 5, 0));
        labs.add(new JLabel("Atomic radius for H:"));
        labs.add(new JLabel("Atomic radius for C:"));
        labs.add(new JLabel("Bond radius:"));
        labs.add(new JLabel("H-bond radius:"));
        cam4.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(4, 1, 5, 0));
        in.add(this.camFields[45]);
        in.add(this.camFields[46]);
        in.add(this.camFields[47]);
        in.add(this.camFields[48]);
        cam4.add((Component)in, "Center");
        cam4.setAlignmentX(0.0f);
        box.add(cam4);
        panel.add(box);
    }

    private void cam5(JPanel panel) {
        JPanel cam5 = new JPanel(new BorderLayout());
        Box box = NBODialogView.titleBox(" Contour Parameters: ", null);
        cam5.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel labs = new JPanel(new GridLayout(3, 1, 5, 0));
        labs.add(new JLabel("Contour value:"));
        labs.add(new JLabel("Contour tolerance:"));
        labs.add(new JLabel("Stepsize:"));
        cam5.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(3, 1, 5, 0));
        in.add(this.camFields[49]);
        in.add(this.camFields[50]);
        in.add(this.camFields[51]);
        cam5.add((Component)in, "Center");
        cam5.setAlignmentX(0.0f);
        box.add(cam5);
        panel.add(box);
    }

    protected void showMOJmol(String type, int i) {
        if (!type.startsWith("P") && !type.equals("MO")) {
            type = "P" + type;
        }
        this.runScriptQueued("MO TYPE " + type + "; MO " + i);
    }

    protected void showOrbJmol(String type, int i) {
        if (type.trim().equals("NAO")) {
            type = "PNAO";
        }
        if (!(this.dialogMode != 's' || type.startsWith("P") || type.equals("MO") || type.equals("AO"))) {
            type = "P" + type;
        }
        this.runScriptQueued("NBO TYPE " + type + "; NBO " + i);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void basisSel() {
        SB sb;
        File f;
        block8: {
            this.newModel = true;
            int fileNum = 31 + this.basis.getSelectedIndex();
            f = FileHndlr.newNBOFile(this.fileHndlr.inputFile, "" + fileNum);
            if (!f.exists()) {
                this.runJob("PLOT", this.fileHndlr.inputFile, "gennbo");
                return;
            }
            this.iLast = this.orbitals.getSelectedIndex();
            int keywordNumber = this.basis.getSelectedIndex() + 1;
            if (keywordNumber == 10) {
                this.nboKeywords = this.cleanNBOKeylist(this.fileHndlr.read47File()[1]);
                if (!this.nboKeywords.contains("CMO")) {
                    this.runJob("CMO", this.fileHndlr.inputFile, "gennbo");
                    return;
                }
            }
            this.reqInfo = "";
            sb = new SB();
            sb.append("GLOBAL C_PATH " + this.fileHndlr.inputFile.getParent() + sep);
            sb.append("GLOBAL C_JOBSTEM " + this.fileHndlr.jobStem + sep);
            sb.append("GLOBAL I_BAS_1 " + keywordNumber + sep);
            if (this.isOpenShell) {
                if (this.alphaSpin.isSelected()) {
                    sb.append("GLOBAL I_SPIN 1" + sep);
                    break block8;
                } else {
                    if (this.betaList == null) {
                        this.betaList = new DefaultComboBoxModel();
                        this.orbitals.setModel(this.betaList);
                        sb.append("GLOBAL I_SPIN -1" + sep);
                        sb.append("CMD LABEL");
                        this.nboService.rawCmdNew("v", sb, 46, this.betaList, "Getting list");
                        return;
                    }
                    this.orbitals.setModel(this.betaList);
                    return;
                }
            }
            sb.append("GLOBAL I_SPIN 0" + sep);
        }
        if (this.alphaList == null) {
            this.alphaList = new DefaultComboBoxModel();
            this.orbitals.setModel(this.alphaList);
            sb.append("CMD LABEL");
            this.nboService.rawCmdNew("v", sb, 46, this.alphaList, "Getting list");
            this.runScriptQueued("load " + f.getAbsolutePath());
            return;
        }
        this.orbitals.setModel(this.alphaList);
    }

    protected void goViewClicked(boolean oneD) {
        this.runScriptNow("image close");
        int[] selected = this.orbitals.getSelectedIndices();
        int size = selected.length;
        if (size > 1) {
            this.showView(selected, oneD);
            return;
        }
        String tmp2 = "";
        SB sb = new SB();
        for (int i = 1; i <= 3; ++i) {
            for (int j = 1; j <= 3; ++j) {
                Object oi = this.vwr.getProperty("string", "orientationInfo.rotationMatrix[" + j + "][" + i + "]", null);
                tmp2 = tmp2 + oi.toString() + " ";
            }
            sb.append("a U" + i + " " + tmp2 + sep);
            tmp2 = "";
        }
        this.vwr.writeTextFile(this.nboService.serverDir + "/jview.txt", sb.toString());
        sb = new SB();
        sb.append("GLOBAL C_PATH " + this.fileHndlr.inputFile.getParent() + sep);
        sb.append("GLOBAL C_JOBSTEM " + this.fileHndlr.jobStem + sep);
        sb.append("GLOBAL I_BAS_1 " + (this.basis.getSelectedIndex() + 1) + sep);
        if (this.currSign != this.lastSign) {
            sb.append("GLOBAL SIGN +1 " + sep);
        }
        this.lastSign = this.currSign;
        int ind = this.orbitals.getSelectedIndex();
        if (this.isOpenShell) {
            sb.append("GLOBAL I_SPIN " + (this.alphaSpin.isSelected() ? "1" : "-1") + sep);
        } else {
            sb.append("GLOBAL I_SPIN 0" + sep);
        }
        sb.append(this.getLineParams());
        if (oneD) {
            sb.append(this.getVectorParams());
            sb.append("CMD PROFILE " + (ind + 1));
            this.appendOutputWithCaret("Profile " + (ind + 1), 'i');
        } else {
            sb.append(this.getPlaneParams());
            sb.append("CMD CONTOUR " + (ind + 1));
            this.appendOutputWithCaret("Contour " + (ind + 1), 'i');
        }
        this.nboService.rawCmdNew("v", sb, 88, null, oneD ? "Profiling.." : "Contouring..");
    }

    protected void showView(int[] selected, boolean oneD) {
        int i;
        String tmp2 = "";
        SB sb = new SB();
        this.nboService.restart();
        if (this.jmolView) {
            for (int i2 = 1; i2 <= 3; ++i2) {
                for (int j = 1; j <= 3; ++j) {
                    Object oi = this.vwr.getProperty("string", "orientationInfo.rotationMatrix[" + j + "][" + i2 + "]", null);
                    tmp2 = tmp2 + oi.toString() + " ";
                }
                sb.append("a V_U" + i2 + " " + tmp2 + sep);
                tmp2 = "";
            }
            this.vwr.writeTextFile(this.nboService.serverDir + "/jview.txt", sb.toString());
            sb = new SB();
            sb.append("GLOBAL C_PATH " + this.fileHndlr.inputFile.getParent() + sep);
            sb.append("GLOBAL C_JOBSTEM " + this.fileHndlr.jobStem + sep);
            sb.append("GLOBAL I_BAS_1 " + (this.basis.getSelectedIndex() + 1) + sep);
            if (this.isOpenShell) {
                sb.append("GLOBAL I_SPIN " + (this.alphaSpin.isSelected() ? "1" : "-1") + sep);
            } else {
                sb.append("GLOBAL I_SPIN 0" + sep);
            }
            sb.append("CMD LABEL");
            this.nboService.rawCmdNew("v", sb, 0, null, "");
            sb = new SB();
            sb.append("CMD JVIEW");
            this.nboService.rawCmdNew("v", sb, 0, null, "");
        }
        String tmp = oneD ? "Profile " : "Contour ";
        for (i = 0; i < selected.length; ++i) {
            sb = new SB();
            sb.append("GLOBAL C_PATH " + this.fileHndlr.inputFile.getParent() + sep);
            sb.append("GLOBAL C_JOBSTEM " + this.fileHndlr.jobStem + sep);
            sb.append("GLOBAL I_BAS_1 " + (this.basis.getSelectedIndex() + 1) + sep);
            if (this.isOpenShell) {
                sb.append("GLOBAL I_SPIN " + (this.alphaSpin.isSelected() ? "1" : "-1") + sep);
            } else {
                sb.append("GLOBAL I_SPIN 0" + sep);
            }
            if (oneD) {
                sb.append("CMD PROFILE " + (selected[i] + 1));
            } else {
                sb.append("CMD CONTOUR " + (selected[i] + 1));
            }
            tmp = tmp + (selected[i] + 1) + " ";
            this.nboService.rawCmdNew("v", sb, 0, null, "");
        }
        this.appendOutputWithCaret(tmp, 'i');
        sb = new SB();
        this.runScriptNow("image close");
        tmp = "";
        for (i = 0; i < selected.length; ++i) {
            tmp = tmp + (i + 1) + " ";
        }
        if (tmp.equals("")) {
            this.vwr.alert("Select an orbital");
            return;
        }
        sb.append("GLOBAL C_PATH " + this.fileHndlr.inputFile.getParent() + sep);
        sb.append("GLOBAL C_JOBSTEM " + this.fileHndlr.jobStem + sep);
        if (this.isOpenShell) {
            sb.append("GLOBAL I_SPIN " + (this.alphaSpin.isSelected() ? "1" : "-1") + sep);
        } else {
            sb.append("GLOBAL I_SPIN 0" + sep);
        }
        sb.append(this.getLineParams());
        sb.append("CMD DRAW " + tmp);
        this.nboService.rawCmdNew("v", sb, 88, null, "Raytracing...");
    }

    protected void view3D(int[] selected) {
        int i;
        this.runScriptNow("image close");
        String tmp2 = "";
        this.nboService.restart();
        SB sb = new SB();
        if (this.jmolView) {
            for (int i2 = 1; i2 <= 3; ++i2) {
                for (int j = 1; j <= 3; ++j) {
                    Object oi = this.vwr.getProperty("string", "orientationInfo.rotationMatrix[" + j + "][" + i2 + "]", null);
                    tmp2 = tmp2 + oi.toString() + " ";
                }
                sb.append("a V_U" + i2 + " " + tmp2 + sep);
                tmp2 = "";
            }
            this.vwr.writeTextFile(this.nboService.serverDir + "/jview.txt", sb.toString());
            sb = new SB();
            sb.append("GLOBAL C_PATH " + this.fileHndlr.inputFile.getParent() + sep);
            sb.append("GLOBAL C_JOBSTEM " + this.fileHndlr.jobStem + sep);
            sb.append("GLOBAL I_BAS_1 " + (this.basis.getSelectedIndex() + 1) + sep);
            if (this.isOpenShell) {
                sb.append("GLOBAL I_SPIN " + (this.alphaSpin.isSelected() ? "1" : "-1") + sep);
            } else {
                sb.append("GLOBAL I_SPIN 0" + sep);
            }
            sb.append("CMD LABEL");
            this.nboService.rawCmdNew("v", sb, 0, null, "");
            sb = new SB();
            sb.append("CMD JVIEW");
            this.nboService.rawCmdNew("v", sb, 0, null, "");
        }
        sb = new SB();
        String tmp = "View ";
        for (i = 0; i < selected.length; ++i) {
            sb = new SB();
            sb.append("GLOBAL C_PATH " + this.fileHndlr.inputFile.getParent() + sep);
            sb.append("GLOBAL C_JOBSTEM " + this.fileHndlr.jobStem + sep);
            sb.append("GLOBAL I_BAS_1 " + (this.basis.getSelectedIndex() + 1) + sep);
            if (this.isOpenShell) {
                sb.append("GLOBAL I_SPIN " + (this.alphaSpin.isSelected() ? "1" : "-1") + sep);
            } else {
                sb.append("GLOBAL I_SPIN 0" + sep);
            }
            sb.append("CMD PROFILE " + (selected[i] + 1));
            tmp = tmp + (selected[i] + 1) + " ";
            this.nboService.rawCmdNew("v", sb, 0, null, "");
        }
        this.appendOutputWithCaret(tmp, 'i');
        this.vwr.writeTextFile(this.nboService.serverDir + "/jview", sb.toString());
        tmp = "";
        for (i = 0; i < selected.length; ++i) {
            tmp = tmp + " " + (i + 1);
        }
        if (tmp.equals("")) {
            this.vwr.alert("Select an orbital");
            return;
        }
        sb = new SB();
        sb.append("GLOBAL C_PATH " + this.fileHndlr.inputFile.getParent() + sep);
        sb.append("GLOBAL C_JOBSTEM " + this.fileHndlr.jobStem + sep);
        if (this.isOpenShell) {
            sb.append("GLOBAL I_SPIN " + (this.alphaSpin.isSelected() ? "1" : "-1") + sep);
        } else {
            sb.append("GLOBAL I_SPIN 0" + sep);
        }
        sb.append(this.getCameraParams());
        sb.append("CMD VIEW ");
        sb.append(tmp);
        this.nboService.rawCmdNew("v", sb, 88, null, "Raytracing...");
    }

    protected void notifyPick_v(String atomno) {
        block0 : switch (this.viewState) {
            case 2: {
                this.vectorFields[this.viewVectorPt++].setText(atomno);
                this.vectorDef = this.vectorFields[0].getText() + ";" + this.vectorFields[1].getText();
                this.showSelected(this.vectorDef.split(";"));
                this.viewVectorPt %= 2;
                break;
            }
            case 1: {
                this.planeFields[this.viewPlanePt++].setText(atomno);
                this.planeDef = this.planeFields[0].getText() + ";" + this.planeFields[1].getText() + ";" + this.planeFields[2].getText();
                this.showSelected(this.planeDef.split(";"));
                this.viewPlanePt %= 3;
                break;
            }
            case 0: {
                String[] tok = atomno.split(",");
                if (tok.length < 2) {
                    return;
                }
                String[] tok2 = tok[1].split(" ");
                switch (this.basis.getSelectedIndex()) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        this.pickNBO(tok2[2], tok2[5], this.alphaList, this.orbitals);
                        break block0;
                    }
                }
            }
        }
    }

    protected void notifyList_v(DefaultComboBoxModel<String> list) {
        if (list != null) {
            if (this.iLast < 0) {
                this.iLast = 0;
            }
            this.orbitals.setSelectedIndex(this.iLast);
        }
    }

    protected void pickAtomic(String atomno, DefaultComboBoxModel<String> list, JComboBox<String> orb) {
        int ind = Integer.parseInt(atomno) - 1;
        String at = this.vwr.ms.at[ind].getElementSymbol() + atomno + "(";
        int curr = 0;
        int size = list.getSize();
        if (this.currOrb.contains(at)) {
            curr = orb.getSelectedIndex() + 1;
        }
        int i = 0;
        while (i < size) {
            String str = list.getElementAt(curr % size).replaceAll(" ", "");
            if (str.contains(at + "lp)")) {
                orb.setSelectedIndex(curr % size);
                this.currOrb = str;
                break;
            }
            if (str.contains(at + "ry)")) {
                orb.setSelectedIndex(curr % size);
                this.currOrb = str;
                break;
            }
            ++i;
            ++curr;
        }
    }

    protected void pickNBO(String at1, String at2, DefaultComboBoxModel<String> list, JComboBox<String> orb) {
        String bond = at1 + "-" + at2;
        int curr = 0;
        int size = list.getSize();
        if (this.currOrb.contains(bond)) {
            curr = orb.getSelectedIndex() + 1;
        }
        int i = 0;
        while (i < size) {
            String str = list.getElementAt(curr % size).replace(" ", "");
            if (str.contains(bond)) {
                orb.setSelectedIndex(curr % size);
                this.currOrb = str;
                break;
            }
            ++i;
            ++curr;
        }
    }

    protected void pickNBO(String at1, String at2, DefaultComboBoxModel<String> list, JList<String> orb) {
        String bond = at1 + "-" + at2;
        int curr = 0;
        int size = list.getSize();
        if (this.currOrb.contains(bond)) {
            curr = orb.getSelectedIndex() + 1;
        }
        int i = 0;
        while (i < size) {
            String str = list.getElementAt(curr % size).replace(" ", "");
            if (str.contains(bond)) {
                orb.setSelectedIndex(curr % size);
                this.currOrb = str;
                break;
            }
            ++i;
            ++curr;
        }
    }

    protected void pickNHO(String at1, String at2, DefaultComboBoxModel<String> list, JComboBox<String> orb) {
        String bond = at1 + "(" + at2 + ")";
        String bond2 = at2 + "(" + at1 + ")";
        int curr = 0;
        int size = list.getSize();
        if (this.currOrb.contains(bond)) {
            curr = orb.getSelectedIndex() + 1;
        }
        int i = 0;
        while (i < size) {
            String str = list.getElementAt(curr % size).replace(" ", "");
            if (str.contains(bond)) {
                list.setSelectedItem(bond);
                this.currOrb = str;
                break;
            }
            if (str.contains(bond2)) {
                orb.setSelectedIndex(curr % size);
                this.currOrb = str;
                break;
            }
            ++i;
            ++curr;
        }
    }

    protected void resetView() {
        this.newModel = true;
        this.selectedOrbs = "";
        for (int i = 0; i < 9; ++i) {
        }
        this.iLast = 0;
    }

    private void resetValues() {
        int i;
        this.plVal = new String[]{"1", "2", "3", "0.5", "0.0", "0.0", "0.0", "-3.0", "3.0", "-3.0", "3.0", "25"};
        this.vecVal = new String[]{"1", "2", "0.5", "-2.0", "2.0", "-1.0", "1.0", "100"};
        this.lineVal = new String[]{"0.03", "0.05", "4", "0.05", "0.05", "0.1", "0.1"};
        for (i = 0; i < this.planeFields.length; ++i) {
            this.planeFields[i] = new JTextField(this.plVal[i]);
        }
        for (i = 0; i < this.vectorFields.length; ++i) {
            this.vectorFields[i] = new JTextField(this.vecVal[i]);
        }
        for (i = 0; i < this.lineFields.length; ++i) {
            this.lineFields[i] = new JTextField(this.lineVal[i]);
        }
        for (i = 0; i < this.camFields.length; ++i) {
            this.camFields[i] = new JTextField(this.camVal[i]);
        }
        this.vectorDef = "1;2";
        this.planeDef = "1;2;3";
    }

    protected void notifyLoad_v() {
        if (this.vwr.ms.ac == 0) {
            return;
        }
        if (!this.newModel) {
            String frame = this.startingModelCount + this.modelCount - 1 + ".1";
            this.runScriptNow("frame " + frame);
            if (!this.useWireMesh) {
                this.runScriptNow("nbo nomesh fill translucent " + this.opacityOp);
                this.runScriptNow("mo nomesh fill translucent " + this.opacityOp);
            }
            this.runScriptNow("nbo color " + this.color2 + " " + this.color1);
            this.runScriptNow("mo color " + this.color2 + " " + this.color1);
            String bonds = this.runScriptNow("print {visible}.bonds");
            this.runScriptQueued("select bonds " + bonds + ";wireframe 0");
            return;
        }
        this.resetValues();
        this.settingsBox.setVisible(true);
        if (!this.fileHndlr.getChooseList()) {
            this.vwr.alert("Error reading $CHOOSE list");
        }
        this.showAtomNums(true);
        if (!this.useWireMesh) {
            this.runScriptQueued("nbo nomesh fill translucent " + this.opacityOp);
            this.runScriptQueued("mo nomesh fill translucent " + this.opacityOp);
        }
        this.runScriptQueued("nbo color " + this.color2 + " " + this.color1);
        this.runScriptQueued("mo color " + this.color2 + " " + this.color1);
        if (this.isOpenShell) {
            this.alphaSpin.setVisible(true);
            this.betaSpin.setVisible(true);
        } else {
            this.alphaSpin.setVisible(false);
            this.betaSpin.setVisible(false);
        }
        this.setBonds(true);
        for (int i = 0; i < this.panel.getComponentCount(); ++i) {
            this.panel.getComponent(i).setVisible(true);
        }
    }

    @Override
    protected void showConfirmationDialog(String st, File newFile, String ext) {
        int i = JOptionPane.showConfirmDialog(this, st, "Message", 0);
        if (i == 0) {
            JDialog d = new JDialog(this);
            d.setLayout(new BorderLayout());
            JTextPane tp = new JTextPane();
            d.add((Component)tp, "Center");
            d.setSize(new Dimension(500, 600));
            tp.setText(this.fileHndlr.getFileData(FileHndlr.newNBOFile(newFile, "nbo").toString()));
            d.setVisible(true);
        }
    }
}

