/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class SiestaReader
extends AtomSetCollectionReader {
    private int noAtoms;
    private float[] unitCellData = new float[9];

    @Override
    protected void initializeReader() {
        this.doApplySymmetry = true;
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.contains("%block LatticeVectors")) {
            if (this.doGetModel(++this.modelNumber, null)) {
                this.readCellThenAtomsCartesian();
            }
            return true;
        }
        if (this.line.contains("outcoor: Atomic coordinates")) {
            if (this.doGetModel(++this.modelNumber, null)) {
                this.readAtomsCartGeomThenCell();
            }
            return true;
        }
        return true;
    }

    private void setCell() throws Exception {
        this.fillFloatArray(null, 0, this.unitCellData);
        this.addPrimitiveLatticeVector(0, this.unitCellData, 0);
        this.addPrimitiveLatticeVector(1, this.unitCellData, 3);
        this.addPrimitiveLatticeVector(2, this.unitCellData, 6);
    }

    private void readCellThenAtomsCartesian() throws Exception {
        this.newAtomSet();
        this.setCell();
        this.discardLinesUntilContains("AtomicCoordinatesFormat Ang");
        this.rd();
        this.setFractionalCoordinates(false);
        while (this.rd() != null && this.line.indexOf("%endblock Atomic") < 0) {
            String[] tokens = this.getTokens();
            this.addAtomXYZSymName(tokens, 0, null, tokens[4]);
        }
        this.noAtoms = this.asc.ac;
    }

    private void newAtomSet() throws Exception {
        this.applySymmetryAndSetTrajectory();
        this.asc.newAtomSet();
        this.setSpaceGroupName("P1");
        this.setFractionalCoordinates(false);
    }

    private void readAtomsCartGeomThenCell() throws Exception {
        this.readLines(1);
        this.newAtomSet();
        int atom0 = this.asc.ac;
        for (int i = 0; i < this.noAtoms; ++i) {
            String[] tokens = this.getTokens();
            Atom atom = this.asc.addNewAtom();
            atom.atomName = tokens[4];
            float x = this.parseFloatStr(tokens[0]);
            float y = this.parseFloatStr(tokens[1]);
            float z = this.parseFloatStr(tokens[2]);
            atom.set(x, y, z);
            this.rd();
        }
        this.discardLinesUntilContains("outcell: Unit cell vectors");
        this.setCell();
        Atom[] atoms = this.asc.atoms;
        int ac = this.asc.ac;
        for (int i = atom0; i < ac; ++i) {
            this.setAtomCoord(atoms[i]);
        }
        this.discardLinesUntilContains("siesta: E_KS(eV) = ");
        String[] tokens = this.getTokens();
        Double energy = Double.parseDouble(tokens[3]);
        this.asc.setAtomSetEnergy("" + energy, energy.floatValue());
        this.asc.setCurrentModelInfo("Energy", energy);
        this.asc.setInfo("Energy", energy);
        this.asc.setAtomSetName("Energy = " + energy + " eV");
    }
}

